/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.ProjectInfo;
import com.ca.apim.gateway.cagatewayconfig.beans.CassandraConnection;
import com.ca.apim.gateway.cagatewayconfig.beans.ClusterProperty;
import com.ca.apim.gateway.cagatewayconfig.beans.ContextVariableEnvironmentProperty;
import com.ca.apim.gateway.cagatewayconfig.beans.Dependency;
import com.ca.apim.gateway.cagatewayconfig.beans.DependentBundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.FolderTree;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.GenericEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.GlobalEnvironmentProperty;
import com.ca.apim.gateway.cagatewayconfig.beans.IdentityProvider;
import com.ca.apim.gateway.cagatewayconfig.beans.JdbcConnection;
import com.ca.apim.gateway.cagatewayconfig.beans.JmsDestination;
import com.ca.apim.gateway.cagatewayconfig.beans.ListenPort;
import com.ca.apim.gateway.cagatewayconfig.beans.MissingGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyBackedService;
import com.ca.apim.gateway.cagatewayconfig.beans.PrivateKey;
import com.ca.apim.gateway.cagatewayconfig.beans.ScheduledTask;
import com.ca.apim.gateway.cagatewayconfig.beans.Service;
import com.ca.apim.gateway.cagatewayconfig.beans.ServiceEnvironmentProperty;
import com.ca.apim.gateway.cagatewayconfig.beans.SoapResource;
import com.ca.apim.gateway.cagatewayconfig.beans.SsgActiveConnector;
import com.ca.apim.gateway.cagatewayconfig.beans.StoredPassword;
import com.ca.apim.gateway.cagatewayconfig.beans.TrustedCert;
import com.ca.apim.gateway.cagatewayconfig.beans.UnsupportedGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadingOperation;
import com.ca.apim.gateway.cagatewayconfig.util.file.SupplierWithIO;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Bundle {
    private static final String DISABLE_ENVIRONMENT_ENTITY_UNIQUE_NAMING = "com.ca.apim.build.disableEnvironmentEntityUniqueNaming";
    private final Map<Class, Map<String, ?>> entities = new ConcurrentHashMap();
    private final Map<String, SupplierWithIO<InputStream>> certificateFiles = new HashMap<String, SupplierWithIO<InputStream>>();
    private final Map<String, SupplierWithIO<InputStream>> privateKeyFiles = new HashMap<String, SupplierWithIO<InputStream>>();
    private Set<Bundle> dependencies;
    private FolderTree folderTree;
    private Map<Dependency, List<Dependency>> dependencyMap;
    private BundleLoadingOperation loadingMode;
    private DependentBundle dependentBundleFrom;
    private List<DependentBundle> dependentBundles = new ArrayList<DependentBundle>();
    private ProjectInfo projectInfo;
    private static final String UNIQUE_NAME_SEPARATOR = "::";
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9._\\-]*$");

    public Bundle(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    public Bundle() {
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public void setProjectInfo(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    public void addDependentBundle(DependentBundle dependentBundle) {
        this.dependentBundles.add(dependentBundle);
    }

    public List<DependentBundle> getDependentBundles() {
        return this.dependentBundles;
    }

    public DependentBundle getDependentBundleFrom() {
        return this.dependentBundleFrom;
    }

    public void setDependentBundleFrom(DependentBundle dependentBundleFrom) {
        this.dependentBundleFrom = dependentBundleFrom;
    }

    public <E extends GatewayEntity> Map<String, E> getEntities(Class<E> entityType) {
        return this.entities.computeIfAbsent(entityType, aClass -> new HashMap());
    }

    public Map<String, MissingGatewayEntity> getMissingEntities() {
        return this.getEntities(MissingGatewayEntity.class);
    }

    public Map<String, UnsupportedGatewayEntity> getUnsupportedEntities() {
        return this.getEntities(UnsupportedGatewayEntity.class);
    }

    public <E extends GatewayEntity> void addEntity(E entity) {
        this.getEntities(entity.getClass()).put(entity.getId(), entity);
    }

    public Map<String, ClusterProperty> getClusterProperties() {
        return this.getEntities(ClusterProperty.class);
    }

    public Map<String, Service> getServices() {
        return this.getEntities(Service.class);
    }

    public void putAllServices(@NotNull Map<String, Service> services) {
        this.getServices().putAll(services);
    }

    public Map<String, Policy> getPolicies() {
        return this.getEntities(Policy.class);
    }

    public synchronized void putAllPolicies(@NotNull Map<String, Policy> policies) {
        Map<String, Policy> policyMap = this.getPolicies();
        policies.forEach((path, p) -> policyMap.merge((String)path, (Policy)p, Policy::merge));
    }

    public Map<String, SoapResource> getSoapResources() {
        return this.getEntities(SoapResource.class);
    }

    public void putAllSoapResources(@NotNull Map<String, SoapResource> wsdls) {
        this.getSoapResources().putAll(wsdls);
    }

    public void putAllFolders(@NotNull Map<String, Folder> folders) {
        this.getFolders().putAll(folders);
    }

    public Map<String, Folder> getFolders() {
        return this.entities.computeIfAbsent(Folder.class, aClass -> new ConcurrentHashMap());
    }

    public void putAllEncasses(@NotNull Map<String, Encass> encasses) {
        this.getEncasses().putAll(encasses);
    }

    public Map<String, Encass> getEncasses() {
        return this.getEntities(Encass.class);
    }

    public void putAllStaticProperties(@NotNull Map<String, ClusterProperty> properties) {
        this.getEntities(ClusterProperty.class).putAll(properties);
    }

    public Map<String, ClusterProperty> getStaticProperties() {
        return this.getEntities(ClusterProperty.class);
    }

    public void putAllGlobalEnvironmentProperties(@NotNull Map<String, GlobalEnvironmentProperty> properties) {
        this.getEntities(GlobalEnvironmentProperty.class).putAll(properties);
    }

    public void putAllServiceEnvironmentProperties(@NotNull Map<String, ServiceEnvironmentProperty> properties) {
        this.getEntities(ServiceEnvironmentProperty.class).putAll(properties);
    }

    public void putAllContextVariableEnvironmentProperties(@NotNull Map<String, ContextVariableEnvironmentProperty> properties) {
        this.getEntities(ContextVariableEnvironmentProperty.class).putAll(properties);
    }

    public Map<String, GlobalEnvironmentProperty> getGlobalEnvironmentProperties() {
        return this.getEntities(GlobalEnvironmentProperty.class);
    }

    public Map<String, ServiceEnvironmentProperty> getServiceEnvironmentProperties() {
        return this.getEntities(ServiceEnvironmentProperty.class);
    }

    public Map<String, ContextVariableEnvironmentProperty> getContextVariableEnvironmentProperties() {
        return this.getEntities(ContextVariableEnvironmentProperty.class);
    }

    public void putAllPolicyBackedServices(@NotNull Map<String, PolicyBackedService> policyBackedServices) {
        this.getPolicyBackedServices().putAll(policyBackedServices);
    }

    public Map<String, PolicyBackedService> getPolicyBackedServices() {
        return this.getEntities(PolicyBackedService.class);
    }

    public Map<String, IdentityProvider> getIdentityProviders() {
        return this.getEntities(IdentityProvider.class);
    }

    public void putAllIdentityProviders(@NotNull Map<String, IdentityProvider> identityProviders) {
        this.getIdentityProviders().putAll(identityProviders);
    }

    public Map<String, ListenPort> getListenPorts() {
        return this.getEntities(ListenPort.class);
    }

    public void putAllListenPorts(@NotNull Map<String, ListenPort> listenPorts) {
        this.getEntities(ListenPort.class).putAll(listenPorts);
    }

    public Map<String, StoredPassword> getStoredPasswords() {
        return this.getEntities(StoredPassword.class);
    }

    public void putAllStoredPasswords(@NotNull Map<String, StoredPassword> storedPasswords) {
        this.getStoredPasswords().putAll(storedPasswords);
    }

    public Map<String, JdbcConnection> getJdbcConnections() {
        return this.getEntities(JdbcConnection.class);
    }

    public Map<String, SsgActiveConnector> getSsgActiveConnectors() {
        return this.getEntities(SsgActiveConnector.class);
    }

    public void putAllJdbcConnections(@NotNull Map<String, JdbcConnection> jdbcConnections) {
        this.getJdbcConnections().putAll(jdbcConnections);
    }

    public Set<Bundle> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(@NotNull Set<Bundle> dependencies) {
        this.dependencies = dependencies;
    }

    public Map<String, TrustedCert> getTrustedCerts() {
        return this.getEntities(TrustedCert.class);
    }

    public void putAllTrustedCerts(@NotNull Map<String, TrustedCert> trustedCerts) {
        this.getTrustedCerts().putAll(trustedCerts);
    }

    public Map<String, PrivateKey> getPrivateKeys() {
        return this.getEntities(PrivateKey.class);
    }

    public void putAllPrivateKeys(@NotNull Map<String, PrivateKey> privateKeys) {
        this.getPrivateKeys().putAll(privateKeys);
    }

    public Map<String, SupplierWithIO<InputStream>> getPrivateKeyFiles() {
        return this.privateKeyFiles;
    }

    public void putAllPrivateKeyFiles(@NotNull Map<String, SupplierWithIO<InputStream>> privateKeys) {
        this.privateKeyFiles.putAll(privateKeys);
    }

    public void putAllSsgActiveConnectors(@NotNull Map<String, SsgActiveConnector> ssgActiveConnectors) {
        this.getSsgActiveConnectors().putAll(ssgActiveConnectors);
    }

    public Map<String, CassandraConnection> getCassandraConnections() {
        return this.getEntities(CassandraConnection.class);
    }

    public void putAllCassandraConnections(@NotNull Map<String, CassandraConnection> cassandraConnections) {
        this.getCassandraConnections().putAll(cassandraConnections);
    }

    public Map<String, SupplierWithIO<InputStream>> getCertificateFiles() {
        return this.certificateFiles;
    }

    public void putAllCertificateFiles(@NotNull Map<String, SupplierWithIO<InputStream>> certificateFiles) {
        this.certificateFiles.putAll(certificateFiles);
    }

    public Map<String, ScheduledTask> getScheduledTasks() {
        return this.getEntities(ScheduledTask.class);
    }

    public void putAllScheduledTasks(@NotNull Map<String, ScheduledTask> scheduledTasks) {
        this.getScheduledTasks().putAll(scheduledTasks);
    }

    public Map<String, JmsDestination> getJmsDestinations() {
        return this.getEntities(JmsDestination.class);
    }

    public void putAllJmsDestinations(@NotNull Map<String, JmsDestination> jmsDestinations) {
        this.getJmsDestinations().putAll(jmsDestinations);
    }

    public Map<String, GenericEntity> getGenericEntities() {
        return this.getEntities(GenericEntity.class);
    }

    public FolderTree getFolderTree() {
        return this.folderTree;
    }

    public void setFolderTree(FolderTree folderTree) {
        this.folderTree = folderTree;
    }

    public void buildFolderTree() {
        this.folderTree = new FolderTree(this.getFolders().values());
    }

    public Map<Dependency, List<Dependency>> getDependencyMap() {
        return this.dependencyMap;
    }

    public void setDependencyMap(Map<Dependency, List<Dependency>> dependencyMap) {
        this.dependencyMap = dependencyMap;
    }

    public BundleLoadingOperation getLoadingMode() {
        return this.loadingMode;
    }

    public void setLoadingMode(BundleLoadingOperation loadingMode) {
        this.loadingMode = loadingMode;
    }

    public String getTargetFolderPath() {
        return this.projectInfo.getTargetFolderPath();
    }

    public String applyUniqueName(String entityName, EntityBuilder.BundleType bundleType) {
        return this.applyUniqueName(entityName, bundleType, false);
    }

    public String applyUniqueName(String entityName, EntityBuilder.BundleType bundleType, boolean isShared) {
        if (bundleType == EntityBuilder.BundleType.ENVIRONMENT && Bundle.isEnvironmentEntityUniqueNamingDisabled()) {
            return entityName;
        }
        StringBuilder uniqueName = new StringBuilder(UNIQUE_NAME_SEPARATOR);
        uniqueName.append(this.getNamespace(bundleType, isShared));
        uniqueName.append(UNIQUE_NAME_SEPARATOR);
        uniqueName.append(entityName);
        String version = this.getProjectInfo().getVersion();
        if (StringUtils.isNotBlank((CharSequence)version)) {
            uniqueName.append(UNIQUE_NAME_SEPARATOR);
            String[] subVersions = version.split("\\.");
            uniqueName.append(subVersions.length > 0 ? subVersions[0] : version);
            uniqueName.append(".");
            uniqueName.append(subVersions.length > 1 ? subVersions[1] : "0");
        }
        return uniqueName.toString();
    }

    public String getNamespace(EntityBuilder.BundleType bundleType, boolean isShared) {
        return this.getProjectInfo().getGroupName();
    }

    public static boolean isEnvironmentEntityUniqueNamingDisabled() {
        return Boolean.getBoolean(DISABLE_ENVIRONMENT_ENTITY_UNIQUE_NAMING);
    }
}

