/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.web.server.WebSession;

public class ReactiveMultiTenantOAuth2PrincipalSupport {
    private static final String OAUTH2_USERS_KEY = "com.c4-soft.spring-addons.oauth2.client.principal-by-client-registration-id";

    public static Map<String, Authentication> getAuthenticationsByClientRegistrationId(WebSession session) {
        return Optional.ofNullable((Map)session.getAttribute(OAUTH2_USERS_KEY)).orElse(new HashMap());
    }

    public static Optional<Authentication> getAuthentication(WebSession session, String clientRegistrationId) {
        return Optional.ofNullable(ReactiveMultiTenantOAuth2PrincipalSupport.getAuthenticationsByClientRegistrationId(session).get(clientRegistrationId));
    }

    public static synchronized void add(WebSession session, String clientRegistrationId, Authentication auth) {
        Map<String, Authentication> identities = ReactiveMultiTenantOAuth2PrincipalSupport.getAuthenticationsByClientRegistrationId(session);
        identities.put(clientRegistrationId, auth);
        session.getAttributes().put(OAUTH2_USERS_KEY, identities);
    }

    public static synchronized void remove(WebSession session, String clientRegistrationId) {
        Map<String, Authentication> identities = ReactiveMultiTenantOAuth2PrincipalSupport.getAuthenticationsByClientRegistrationId(session);
        identities.remove(clientRegistrationId);
        session.getAttributes().put(OAUTH2_USERS_KEY, identities);
    }
}

