/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcClientProperties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringAddonsOAuth2AuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private static final String REGISTRATION_ID_URI_VARIABLE_NAME = "registrationId";
    private final URI clientUri;
    private final DefaultOAuth2AuthorizationRequestResolver delegate;
    private final Map<String, Consumer<OAuth2AuthorizationRequest.Builder>> authRequestCustomizers;
    private final AntPathRequestMatcher authorizationRequestMatcher = new AntPathRequestMatcher("/oauth2/authorization/{registrationId}");

    public SpringAddonsOAuth2AuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcClientProperties addonsClientProperties) {
        this.clientUri = addonsClientProperties.getClientUri();
        this.authRequestCustomizers = addonsClientProperties.getAuthorizationRequestParams().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            List<SpringAddonsOidcClientProperties.RequestParam> params = addonsClientProperties.getAuthorizationRequestParams().get(e.getKey());
            return e.getValue() == null ? null : SpringAddonsOAuth2AuthorizationRequestResolver.requestParamAuthorizationRequestCustomizer(params);
        }));
        this.delegate = new DefaultOAuth2AuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    private Optional<String> getFirstParam(HttpServletRequest request, String paramName) {
        String[] values = request.getParameterValues(paramName);
        if (values == null || values.length < 1) {
            return Optional.empty();
        }
        return Optional.of(values[0]);
    }

    private void savePostLoginUrisInSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Optional.ofNullable(Optional.ofNullable(request.getHeader("X-POST-LOGIN-SUCCESS-URI")).orElse(this.getFirstParam(request, "post_login_success_uri").orElse(null))).filter(StringUtils::hasText).map(URI::create).ifPresent(postLoginSuccessUri -> session.setAttribute("post_login_success_uri", postLoginSuccessUri));
        Optional.ofNullable(Optional.ofNullable(request.getHeader("X-POST-LOGIN-FAILURE-URI")).orElse(this.getFirstParam(request, "post_login_failure_uri").orElse(null))).filter(StringUtils::hasText).map(URI::create).ifPresent(postLoginFailureUri -> session.setAttribute("post_login_failure_uri", postLoginFailureUri));
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        this.savePostLoginUrisInSession(request);
        String registrationId = this.resolveRegistrationId(request);
        this.delegate.setAuthorizationRequestCustomizer(this.authRequestCustomizers.getOrDefault(registrationId, b -> {}));
        OAuth2AuthorizationRequest resolved = this.delegate.resolve(request);
        OAuth2AuthorizationRequest absolute = this.toAbsolute(resolved, request);
        return absolute;
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
        this.savePostLoginUrisInSession(request);
        this.delegate.setAuthorizationRequestCustomizer(this.authRequestCustomizers.getOrDefault(clientRegistrationId, b -> {}));
        OAuth2AuthorizationRequest resolved = this.delegate.resolve(request, clientRegistrationId);
        OAuth2AuthorizationRequest absolute = this.toAbsolute(resolved, request);
        return absolute;
    }

    private OAuth2AuthorizationRequest toAbsolute(OAuth2AuthorizationRequest defaultAuthorizationRequest, HttpServletRequest request) {
        if (defaultAuthorizationRequest == null || this.clientUri == null) {
            return defaultAuthorizationRequest;
        }
        URI original = URI.create(defaultAuthorizationRequest.getRedirectUri());
        String redirectUri = UriComponentsBuilder.fromUri((URI)this.clientUri).path(original.getPath()).query(original.getQuery()).fragment(original.getFragment()).build().toString();
        return OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)defaultAuthorizationRequest).redirectUri(redirectUri).authorizationRequestUri(defaultAuthorizationRequest.getAuthorizationRequestUri()).build();
    }

    private String resolveRegistrationId(HttpServletRequest request) {
        if (this.authorizationRequestMatcher.matches(request)) {
            return (String)this.authorizationRequestMatcher.matcher(request).getVariables().get(REGISTRATION_ID_URI_VARIABLE_NAME);
        }
        return null;
    }

    private static Consumer<OAuth2AuthorizationRequest.Builder> requestParamAuthorizationRequestCustomizer(List<SpringAddonsOidcClientProperties.RequestParam> additionalParams) {
        return customizer -> customizer.additionalParameters(params -> {
            for (SpringAddonsOidcClientProperties.RequestParam reqParam : additionalParams) {
                params.put(reqParam.getName(), reqParam.getValue());
            }
        });
    }
}

