/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsOauth2ServerRedirectStrategy;
import java.net.URI;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import reactor.core.publisher.Mono;

public class SpringAddonsOauth2ServerAuthenticationFailureHandler
implements ServerAuthenticationFailureHandler {
    private final URI defaultRedirectUri;
    private final SpringAddonsOauth2ServerRedirectStrategy redirectStrategy;

    public SpringAddonsOauth2ServerAuthenticationFailureHandler(SpringAddonsOidcProperties addonsProperties) {
        this.defaultRedirectUri = addonsProperties.getClient().getLoginErrorRedirectPath().orElse(URI.create("/"));
        this.redirectStrategy = new SpringAddonsOauth2ServerRedirectStrategy(addonsProperties.getClient().getOauth2Redirections().getPostAuthorizationCode());
    }

    public Mono<Void> onAuthenticationFailure(WebFilterExchange webFilterExchange, AuthenticationException exception) {
        return webFilterExchange.getExchange().getSession().flatMap(session -> {
            URI uri = (URI)session.getAttributeOrDefault("post_login_failure_uri", (Object)this.defaultRedirectUri);
            return this.redirectStrategy.sendRedirect(webFilterExchange.getExchange(), uri);
        });
    }
}

