/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.switchview;

import android.content.Context;
import android.view.View;
import android.widget.CompoundButton;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.viewmanagers.AndroidSwitchManagerDelegate;
import com.facebook.react.viewmanagers.AndroidSwitchManagerInterface;
import com.facebook.react.views.switchview.ReactSwitch;
import com.facebook.react.views.switchview.ReactSwitchEvent;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;

public class ReactSwitchManager
extends SimpleViewManager<ReactSwitch>
implements AndroidSwitchManagerInterface<ReactSwitch> {
    public static final String REACT_CLASS = "AndroidSwitch";
    private static final CompoundButton.OnCheckedChangeListener ON_CHECKED_CHANGE_LISTENER = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            ReactContext reactContext = (ReactContext)buttonView.getContext();
            reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(new ReactSwitchEvent(buttonView.getId(), isChecked));
        }
    };
    private final ViewManagerDelegate<ReactSwitch> mDelegate = new AndroidSwitchManagerDelegate<ReactSwitch, ReactSwitchManager>(this);

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public LayoutShadowNode createShadowNodeInstance() {
        return new ReactSwitchShadowNode();
    }

    @Override
    public Class getShadowNodeClass() {
        return ReactSwitchShadowNode.class;
    }

    @Override
    protected ReactSwitch createViewInstance(ThemedReactContext context) {
        ReactSwitch view = new ReactSwitch((Context)context);
        view.setShowText(false);
        return view;
    }

    @Override
    @ReactProp(name="disabled", defaultBoolean=false)
    public void setDisabled(ReactSwitch view, boolean disabled) {
        view.setEnabled(!disabled);
    }

    @Override
    @ReactProp(name="enabled", defaultBoolean=true)
    public void setEnabled(ReactSwitch view, boolean enabled) {
        view.setEnabled(enabled);
    }

    @Override
    @ReactProp(name="on")
    public void setOn(ReactSwitch view, boolean on) {
        ReactSwitchManager.setValueInternal(view, on);
    }

    @Override
    @ReactProp(name="value")
    public void setValue(ReactSwitch view, boolean value) {
        ReactSwitchManager.setValueInternal(view, value);
    }

    @Override
    @ReactProp(name="thumbTintColor", customType="Color")
    public void setThumbTintColor(ReactSwitch view, @Nullable Integer color) {
        this.setThumbColor(view, color);
    }

    @Override
    @ReactProp(name="thumbColor", customType="Color")
    public void setThumbColor(ReactSwitch view, @Nullable Integer color) {
        view.setThumbColor(color);
    }

    @Override
    @ReactProp(name="trackColorForFalse", customType="Color")
    public void setTrackColorForFalse(ReactSwitch view, @Nullable Integer color) {
        view.setTrackColorForFalse(color);
    }

    @Override
    @ReactProp(name="trackColorForTrue", customType="Color")
    public void setTrackColorForTrue(ReactSwitch view, @Nullable Integer color) {
        view.setTrackColorForTrue(color);
    }

    @Override
    @ReactProp(name="trackTintColor", customType="Color")
    public void setTrackTintColor(ReactSwitch view, @Nullable Integer color) {
        view.setTrackColor(color);
    }

    @Override
    public void setNativeValue(ReactSwitch view, boolean value) {
    }

    @Override
    public void receiveCommand(@NonNull ReactSwitch view, String commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case "setNativeValue": {
                ReactSwitchManager.setValueInternal(view, args != null && args.getBoolean(0));
            }
        }
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, ReactSwitch view) {
        view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
    }

    @Override
    protected ViewManagerDelegate<ReactSwitch> getDelegate() {
        return this.mDelegate;
    }

    @Override
    public long measure(Context context, ReadableMap localData, ReadableMap props, ReadableMap state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        ReactSwitch view = new ReactSwitch(context);
        view.setShowText(false);
        int measureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(measureSpec, measureSpec);
        return YogaMeasureOutput.make(PixelUtil.toDIPFromPixel(view.getMeasuredWidth()), PixelUtil.toDIPFromPixel(view.getMeasuredHeight()));
    }

    private static void setValueInternal(ReactSwitch view, boolean value) {
        view.setOnCheckedChangeListener(null);
        view.setOn(value);
        view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
    }

    static class ReactSwitchShadowNode
    extends LayoutShadowNode
    implements YogaMeasureFunction {
        private int mWidth;
        private int mHeight;
        private boolean mMeasured;

        private ReactSwitchShadowNode() {
            this.initMeasureFunction();
        }

        private void initMeasureFunction() {
            this.setMeasureFunction(this);
        }

        @Override
        public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
            if (!this.mMeasured) {
                ReactSwitch reactSwitch = new ReactSwitch((Context)this.getThemedContext());
                reactSwitch.setShowText(false);
                int spec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                reactSwitch.measure(spec, spec);
                this.mWidth = reactSwitch.getMeasuredWidth();
                this.mHeight = reactSwitch.getMeasuredHeight();
                this.mMeasured = true;
            }
            return YogaMeasureOutput.make(this.mWidth, this.mHeight);
        }
    }
}

