/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.touch.ReactInterceptingViewGroup;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.annotations.ReactPropertyHolder;
import com.facebook.yoga.YogaMeasureMode;
import java.util.Map;

@ReactPropertyHolder
public abstract class ViewManager<T extends View, C extends ReactShadowNode>
extends BaseJavaModule {
    public void updateProperties(@NonNull T viewToUpdate, ReactStylesDiffMap props) {
        ViewManagerDelegate<T> delegate;
        if (ReactFeatureFlags.useViewManagerDelegates && (delegate = this.getDelegate()) != null) {
            ViewManagerPropertyUpdater.updateProps(delegate, viewToUpdate, props);
        } else {
            ViewManagerPropertyUpdater.updateProps(this, viewToUpdate, props);
        }
        this.onAfterUpdateTransaction(viewToUpdate);
    }

    @Nullable
    protected ViewManagerDelegate<T> getDelegate() {
        return null;
    }

    @NonNull
    private final T createView(@NonNull ThemedReactContext reactContext, JSResponderHandler jsResponderHandler) {
        return this.createView(reactContext, null, null, jsResponderHandler);
    }

    @NonNull
    public T createView(@NonNull ThemedReactContext reactContext, @Nullable ReactStylesDiffMap props, @Nullable StateWrapper stateWrapper, JSResponderHandler jsResponderHandler) {
        T view = this.createViewInstance(reactContext, props, stateWrapper);
        if (view instanceof ReactInterceptingViewGroup) {
            ((ReactInterceptingViewGroup)view).setOnInterceptTouchEventListener(jsResponderHandler);
        }
        return view;
    }

    @Override
    @NonNull
    public abstract String getName();

    public C createShadowNodeInstance() {
        throw new RuntimeException("ViewManager subclasses must implement createShadowNodeInstance()");
    }

    @NonNull
    public C createShadowNodeInstance(@NonNull ReactApplicationContext context) {
        return this.createShadowNodeInstance();
    }

    public abstract Class<? extends C> getShadowNodeClass();

    @NonNull
    protected abstract T createViewInstance(@NonNull ThemedReactContext var1);

    @NonNull
    protected T createViewInstance(@NonNull ThemedReactContext reactContext, @Nullable ReactStylesDiffMap initialProps, @Nullable StateWrapper stateWrapper) {
        Object extraData;
        T view = this.createViewInstance(reactContext);
        this.addEventEmitters(reactContext, view);
        if (initialProps != null) {
            this.updateProperties(view, initialProps);
        }
        if (stateWrapper != null && (extraData = this.updateState(view, initialProps, stateWrapper)) != null) {
            this.updateExtraData(view, extraData);
        }
        return view;
    }

    public void onDropViewInstance(@NonNull T view) {
    }

    protected void addEventEmitters(@NonNull ThemedReactContext reactContext, @NonNull T view) {
    }

    protected void onAfterUpdateTransaction(@NonNull T view) {
    }

    public abstract void updateExtraData(@NonNull T var1, Object var2);

    @Deprecated
    public void receiveCommand(@NonNull T root, int commandId, @Nullable ReadableArray args) {
    }

    public void receiveCommand(@NonNull T root, String commandId, @Nullable ReadableArray args) {
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return null;
    }

    public Map<String, String> getNativeProps() {
        return ViewManagerPropertyUpdater.getNativeProps(this.getClass(), this.getShadowNodeClass());
    }

    @Nullable
    public Object updateLocalData(@NonNull T view, ReactStylesDiffMap props, ReactStylesDiffMap localData) {
        return null;
    }

    @Nullable
    public Object updateState(@NonNull T view, ReactStylesDiffMap props, @Nullable StateWrapper stateWrapper) {
        return null;
    }

    public long measure(Context context, ReadableMap localData, ReadableMap props, ReadableMap state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        return 0L;
    }

    public void setPadding(T view, int left, int top, int right, int bottom) {
    }
}

