/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.facebook.react.views.scroll.ScrollEvent;
import com.facebook.react.views.scroll.ScrollEventType;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.TextAttributeProps;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.text.TextLayoutManager;
import com.facebook.react.views.text.TextTransform;
import com.facebook.react.views.textinput.ContentSizeWatcher;
import com.facebook.react.views.textinput.ReactContentSizeChangedEvent;
import com.facebook.react.views.textinput.ReactEditText;
import com.facebook.react.views.textinput.ReactTextChangedEvent;
import com.facebook.react.views.textinput.ReactTextInputBlurEvent;
import com.facebook.react.views.textinput.ReactTextInputEndEditingEvent;
import com.facebook.react.views.textinput.ReactTextInputEvent;
import com.facebook.react.views.textinput.ReactTextInputFocusEvent;
import com.facebook.react.views.textinput.ReactTextInputSelectionEvent;
import com.facebook.react.views.textinput.ReactTextInputShadowNode;
import com.facebook.react.views.textinput.ReactTextInputSubmitEditingEvent;
import com.facebook.react.views.textinput.ScrollWatcher;
import com.facebook.react.views.textinput.SelectionWatcher;
import com.facebook.yoga.YogaConstants;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Map;

@ReactModule(name="AndroidTextInput")
public class ReactTextInputManager
extends BaseViewManager<ReactEditText, LayoutShadowNode> {
    public static final String TAG = ReactTextInputManager.class.getSimpleName();
    public static final String REACT_CLASS = "AndroidTextInput";
    private static final int[] SPACING_TYPES = new int[]{8, 0, 2, 1, 3};
    private static final int FOCUS_TEXT_INPUT = 1;
    private static final int BLUR_TEXT_INPUT = 2;
    private static final int SET_MOST_RECENT_EVENT_COUNT = 3;
    private static final int SET_TEXT_AND_SELECTION = 4;
    private static final int INPUT_TYPE_KEYBOARD_NUMBER_PAD = 2;
    private static final int INPUT_TYPE_KEYBOARD_DECIMAL_PAD = 8194;
    private static final int INPUT_TYPE_KEYBOARD_NUMBERED = 12290;
    private static final int PASSWORD_VISIBILITY_FLAG = 16;
    private static final int KEYBOARD_TYPE_FLAGS = 12339;
    private static final int AUTOCAPITALIZE_FLAGS = 28672;
    private static final String KEYBOARD_TYPE_EMAIL_ADDRESS = "email-address";
    private static final String KEYBOARD_TYPE_NUMERIC = "numeric";
    private static final String KEYBOARD_TYPE_DECIMAL_PAD = "decimal-pad";
    private static final String KEYBOARD_TYPE_NUMBER_PAD = "number-pad";
    private static final String KEYBOARD_TYPE_PHONE_PAD = "phone-pad";
    private static final String KEYBOARD_TYPE_VISIBLE_PASSWORD = "visible-password";
    private static final InputFilter[] EMPTY_FILTERS = new InputFilter[0];
    private static final int UNSET = -1;
    private static final int IME_ACTION_ID = 1648;

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactEditText createViewInstance(ThemedReactContext context) {
        ReactEditText editText = new ReactEditText((Context)context);
        int inputType = editText.getInputType();
        editText.setInputType(inputType & 0xFFFDFFFF);
        editText.setReturnKeyType("done");
        return editText;
    }

    @Override
    public LayoutShadowNode createShadowNodeInstance() {
        return new ReactTextInputShadowNode();
    }

    @Override
    public Class<? extends LayoutShadowNode> getShadowNodeClass() {
        return ReactTextInputShadowNode.class;
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        return MapBuilder.builder().put("topSubmitEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onSubmitEditing", "captured", "onSubmitEditingCapture"))).put("topEndEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onEndEditing", "captured", "onEndEditingCapture"))).put("topTextInput", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTextInput", "captured", "onTextInputCapture"))).put("topFocus", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onFocus", "captured", "onFocusCapture"))).put("topBlur", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onBlur", "captured", "onBlurCapture"))).put("topKeyPress", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onKeyPress", "captured", "onKeyPressCapture"))).build();
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put(ScrollEventType.getJSEventName(ScrollEventType.SCROLL), MapBuilder.of("registrationName", "onScroll")).build();
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("focusTextInput", 1, "blurTextInput", 2);
    }

    @Override
    public void receiveCommand(ReactEditText reactEditText, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                this.receiveCommand(reactEditText, "focus", args);
                break;
            }
            case 2: {
                this.receiveCommand(reactEditText, "blur", args);
                break;
            }
            case 3: {
                this.receiveCommand(reactEditText, "setMostRecentEventCount", args);
                break;
            }
            case 4: {
                this.receiveCommand(reactEditText, "setTextAndSelection", args);
            }
        }
    }

    @Override
    public void receiveCommand(ReactEditText reactEditText, String commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case "focus": 
            case "focusTextInput": {
                reactEditText.requestFocusFromJS();
                break;
            }
            case "blur": 
            case "blurTextInput": {
                reactEditText.clearFocusFromJS();
                break;
            }
            case "setMostRecentEventCount": {
                reactEditText.setMostRecentEventCount(args.getInt(0));
                break;
            }
            case "setTextAndSelection": {
                int mostRecentEventCount = args.getInt(0);
                reactEditText.setMostRecentEventCount(mostRecentEventCount);
                if (mostRecentEventCount == -1) break;
                String text = args.getString(1);
                int start = args.getInt(2);
                int end = args.getInt(3);
                if (end == -1) {
                    end = start;
                }
                reactEditText.maybeSetTextFromJS(this.getReactTextUpdate(text, mostRecentEventCount, start, end));
            }
        }
    }

    private ReactTextUpdate getReactTextUpdate(String text, int mostRecentEventCount, int start, int end) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        sb.append((CharSequence)TextTransform.apply(text, TextTransform.UNSET));
        return new ReactTextUpdate((Spannable)sb, mostRecentEventCount, false, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 0, start, end);
    }

    @Override
    public void updateExtraData(ReactEditText view, Object extraData) {
        if (extraData instanceof ReactTextUpdate) {
            ReactTextUpdate update = (ReactTextUpdate)extraData;
            int paddingLeft = (int)update.getPaddingLeft();
            int paddingTop = (int)update.getPaddingTop();
            int paddingRight = (int)update.getPaddingRight();
            int paddingBottom = (int)update.getPaddingBottom();
            if (paddingLeft != -1 || paddingTop != -1 || paddingRight != -1 || paddingBottom != -1) {
                view.setPadding(paddingLeft != -1 ? paddingLeft : view.getPaddingLeft(), paddingTop != -1 ? paddingTop : view.getPaddingTop(), paddingRight != -1 ? paddingRight : view.getPaddingRight(), paddingBottom != -1 ? paddingBottom : view.getPaddingBottom());
            }
            if (update.containsImages()) {
                Spannable spannable = update.getText();
                TextInlineImageSpan.possiblyUpdateInlineImageSpans(spannable, (TextView)view);
            }
            view.maybeSetTextFromState(update);
            if (update.getSelectionStart() != -1 && update.getSelectionEnd() != -1) {
                view.setSelection(update.getSelectionStart(), update.getSelectionEnd());
            }
        }
    }

    @ReactProp(name="fontSize", defaultFloat=14.0f)
    public void setFontSize(ReactEditText view, float fontSize) {
        view.setFontSize(fontSize);
    }

    @ReactProp(name="fontFamily")
    public void setFontFamily(ReactEditText view, String fontFamily) {
        view.setFontFamily(fontFamily);
    }

    @ReactProp(name="maxFontSizeMultiplier", defaultFloat=NaNf)
    public void setMaxFontSizeMultiplier(ReactEditText view, float maxFontSizeMultiplier) {
        view.setMaxFontSizeMultiplier(maxFontSizeMultiplier);
    }

    @ReactProp(name="fontWeight")
    public void setFontWeight(ReactEditText view, @Nullable String fontWeight) {
        view.setFontWeight(fontWeight);
    }

    @ReactProp(name="fontStyle")
    public void setFontStyle(ReactEditText view, @Nullable String fontStyle) {
        view.setFontStyle(fontStyle);
    }

    @ReactProp(name="includeFontPadding", defaultBoolean=true)
    public void setIncludeFontPadding(ReactEditText view, boolean includepad) {
        view.setIncludeFontPadding(includepad);
    }

    @ReactProp(name="importantForAutofill")
    public void setImportantForAutofill(ReactEditText view, @Nullable String value) {
        int mode = 0;
        if ("no".equals(value)) {
            mode = 2;
        } else if ("noExcludeDescendants".equals(value)) {
            mode = 8;
        } else if ("yes".equals(value)) {
            mode = 1;
        } else if ("yesExcludeDescendants".equals(value)) {
            mode = 4;
        }
        this.setImportantForAutofill(view, mode);
    }

    private void setImportantForAutofill(ReactEditText view, int mode) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        view.setImportantForAutofill(mode);
    }

    private void setAutofillHints(ReactEditText view, String ... hints) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        view.setAutofillHints(hints);
    }

    @ReactProp(name="onSelectionChange", defaultBoolean=false)
    public void setOnSelectionChange(ReactEditText view, boolean onSelectionChange) {
        if (onSelectionChange) {
            view.setSelectionWatcher(new ReactSelectionWatcher(view));
        } else {
            view.setSelectionWatcher(null);
        }
    }

    @ReactProp(name="blurOnSubmit")
    public void setBlurOnSubmit(ReactEditText view, @Nullable Boolean blurOnSubmit) {
        view.setBlurOnSubmit(blurOnSubmit);
    }

    @ReactProp(name="onContentSizeChange", defaultBoolean=false)
    public void setOnContentSizeChange(ReactEditText view, boolean onContentSizeChange) {
        if (onContentSizeChange) {
            view.setContentSizeWatcher(new ReactContentSizeWatcher(view));
        } else {
            view.setContentSizeWatcher(null);
        }
    }

    @ReactProp(name="onScroll", defaultBoolean=false)
    public void setOnScroll(ReactEditText view, boolean onScroll) {
        if (onScroll) {
            view.setScrollWatcher(new ReactScrollWatcher(view));
        } else {
            view.setScrollWatcher(null);
        }
    }

    @ReactProp(name="onKeyPress", defaultBoolean=false)
    public void setOnKeyPress(ReactEditText view, boolean onKeyPress) {
        view.setOnKeyPress(onKeyPress);
    }

    @ReactProp(name="letterSpacing", defaultFloat=0.0f)
    public void setLetterSpacing(ReactEditText view, float letterSpacing) {
        view.setLetterSpacingPt(letterSpacing);
    }

    @ReactProp(name="allowFontScaling", defaultBoolean=true)
    public void setAllowFontScaling(ReactEditText view, boolean allowFontScaling) {
        view.setAllowFontScaling(allowFontScaling);
    }

    @ReactProp(name="placeholder")
    public void setPlaceholder(ReactEditText view, @Nullable String placeholder) {
        view.setHint(placeholder);
    }

    @ReactProp(name="placeholderTextColor", customType="Color")
    public void setPlaceholderTextColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setHintTextColor(DefaultStyleValuesUtil.getDefaultTextColorHint(view.getContext()));
        } else {
            view.setHintTextColor(color);
        }
    }

    @ReactProp(name="selectionColor", customType="Color")
    public void setSelectionColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setHighlightColor(DefaultStyleValuesUtil.getDefaultTextColorHighlight(view.getContext()));
        } else {
            view.setHighlightColor(color);
        }
        this.setCursorColor(view, color);
    }

    @ReactProp(name="cursorColor", customType="Color")
    public void setCursorColor(ReactEditText view, @Nullable Integer color) {
        try {
            Field cursorDrawableResField = TextView.class.getDeclaredField("mCursorDrawableRes");
            cursorDrawableResField.setAccessible(true);
            int drawableResId = cursorDrawableResField.getInt((Object)view);
            if (drawableResId == 0) {
                return;
            }
            Drawable drawable = ContextCompat.getDrawable((Context)view.getContext(), (int)drawableResId);
            if (color != null) {
                drawable.setColorFilter(color.intValue(), PorterDuff.Mode.SRC_IN);
            }
            Drawable[] drawables = new Drawable[]{drawable, drawable};
            Field editorField = TextView.class.getDeclaredField("mEditor");
            editorField.setAccessible(true);
            Object editor = editorField.get((Object)view);
            Field cursorDrawableField = editor.getClass().getDeclaredField("mCursorDrawable");
            cursorDrawableField.setAccessible(true);
            cursorDrawableField.set(editor, drawables);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @ReactProp(name="mostRecentEventCount", defaultInt=0)
    public void setMostRecentEventCount(ReactEditText view, int mostRecentEventCount) {
        view.setMostRecentEventCount(mostRecentEventCount);
    }

    @ReactProp(name="caretHidden", defaultBoolean=false)
    public void setCaretHidden(ReactEditText view, boolean caretHidden) {
        view.setCursorVisible(!caretHidden);
    }

    @ReactProp(name="contextMenuHidden", defaultBoolean=false)
    public void setContextMenuHidden(ReactEditText view, boolean contextMenuHidden) {
        final boolean _contextMenuHidden = contextMenuHidden;
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return _contextMenuHidden;
            }
        });
    }

    @ReactProp(name="selectTextOnFocus", defaultBoolean=false)
    public void setSelectTextOnFocus(ReactEditText view, boolean selectTextOnFocus) {
        view.setSelectAllOnFocus(selectTextOnFocus);
    }

    @ReactProp(name="color", customType="Color")
    public void setColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setTextColor(DefaultStyleValuesUtil.getDefaultTextColor(view.getContext()));
        } else {
            view.setTextColor(color);
        }
    }

    @ReactProp(name="underlineColorAndroid", customType="Color")
    public void setUnderlineColor(ReactEditText view, @Nullable Integer underlineColor) {
        Drawable background;
        Drawable drawableToMutate = background = view.getBackground();
        if (background.getConstantState() != null) {
            try {
                drawableToMutate = background.mutate();
            }
            catch (NullPointerException e) {
                FLog.e((String)TAG, (String)"NullPointerException when setting underlineColorAndroid for TextInput", (Throwable)e);
            }
        }
        if (underlineColor == null) {
            drawableToMutate.clearColorFilter();
        } else {
            drawableToMutate.setColorFilter(underlineColor.intValue(), PorterDuff.Mode.SRC_IN);
        }
    }

    @ReactProp(name="textAlign")
    public void setTextAlign(ReactEditText view, @Nullable String textAlign) {
        if ("justify".equals(textAlign)) {
            if (Build.VERSION.SDK_INT >= 26) {
                view.setJustificationMode(1);
            }
            view.setGravityHorizontal(3);
        } else {
            if (Build.VERSION.SDK_INT >= 26) {
                view.setJustificationMode(0);
            }
            if (textAlign == null || "auto".equals(textAlign)) {
                view.setGravityHorizontal(0);
            } else if ("left".equals(textAlign)) {
                view.setGravityHorizontal(3);
            } else if ("right".equals(textAlign)) {
                view.setGravityHorizontal(5);
            } else if ("center".equals(textAlign)) {
                view.setGravityHorizontal(1);
            } else {
                throw new JSApplicationIllegalArgumentException("Invalid textAlign: " + textAlign);
            }
        }
    }

    @ReactProp(name="textAlignVertical")
    public void setTextAlignVertical(ReactEditText view, @Nullable String textAlignVertical) {
        if (textAlignVertical == null || "auto".equals(textAlignVertical)) {
            view.setGravityVertical(0);
        } else if ("top".equals(textAlignVertical)) {
            view.setGravityVertical(48);
        } else if ("bottom".equals(textAlignVertical)) {
            view.setGravityVertical(80);
        } else if ("center".equals(textAlignVertical)) {
            view.setGravityVertical(16);
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textAlignVertical: " + textAlignVertical);
        }
    }

    @ReactProp(name="inlineImageLeft")
    public void setInlineImageLeft(ReactEditText view, @Nullable String resource) {
        int id2 = ResourceDrawableIdHelper.getInstance().getResourceDrawableId(view.getContext(), resource);
        view.setCompoundDrawablesWithIntrinsicBounds(id2, 0, 0, 0);
    }

    @ReactProp(name="inlineImagePadding")
    public void setInlineImagePadding(ReactEditText view, int padding) {
        view.setCompoundDrawablePadding(padding);
    }

    @ReactProp(name="editable", defaultBoolean=true)
    public void setEditable(ReactEditText view, boolean editable) {
        view.setEnabled(editable);
    }

    @ReactProp(name="numberOfLines", defaultInt=1)
    public void setNumLines(ReactEditText view, int numLines) {
        view.setLines(numLines);
    }

    @ReactProp(name="maxLength")
    public void setMaxLength(ReactEditText view, @Nullable Integer maxLength) {
        InputFilter[] currentFilters = view.getFilters();
        InputFilter[] newFilters = EMPTY_FILTERS;
        if (maxLength == null) {
            if (currentFilters.length > 0) {
                LinkedList<InputFilter> list = new LinkedList<InputFilter>();
                for (int i = 0; i < currentFilters.length; ++i) {
                    if (currentFilters[i] instanceof InputFilter.LengthFilter) continue;
                    list.add(currentFilters[i]);
                }
                if (!list.isEmpty()) {
                    newFilters = list.toArray(new InputFilter[list.size()]);
                }
            }
        } else if (currentFilters.length > 0) {
            newFilters = currentFilters;
            boolean replaced = false;
            for (int i = 0; i < currentFilters.length; ++i) {
                if (!(currentFilters[i] instanceof InputFilter.LengthFilter)) continue;
                currentFilters[i] = new InputFilter.LengthFilter(maxLength.intValue());
                replaced = true;
            }
            if (!replaced) {
                newFilters = new InputFilter[currentFilters.length + 1];
                System.arraycopy(currentFilters, 0, newFilters, 0, currentFilters.length);
                currentFilters[currentFilters.length] = new InputFilter.LengthFilter(maxLength.intValue());
            }
        } else {
            newFilters = new InputFilter[]{new InputFilter.LengthFilter(maxLength.intValue())};
        }
        view.setFilters(newFilters);
    }

    @ReactProp(name="autoCompleteType")
    public void setTextContentType(ReactEditText view, @Nullable String autoCompleteType) {
        if (autoCompleteType == null) {
            this.setImportantForAutofill(view, 2);
        } else if ("username".equals(autoCompleteType)) {
            this.setAutofillHints(view, "username");
        } else if ("password".equals(autoCompleteType)) {
            this.setAutofillHints(view, "password");
        } else if ("email".equals(autoCompleteType)) {
            this.setAutofillHints(view, "emailAddress");
        } else if ("name".equals(autoCompleteType)) {
            this.setAutofillHints(view, "name");
        } else if ("tel".equals(autoCompleteType)) {
            this.setAutofillHints(view, "phone");
        } else if ("street-address".equals(autoCompleteType)) {
            this.setAutofillHints(view, "postalAddress");
        } else if ("postal-code".equals(autoCompleteType)) {
            this.setAutofillHints(view, "postalCode");
        } else if ("cc-number".equals(autoCompleteType)) {
            this.setAutofillHints(view, "creditCardNumber");
        } else if ("cc-csc".equals(autoCompleteType)) {
            this.setAutofillHints(view, "creditCardSecurityCode");
        } else if ("cc-exp".equals(autoCompleteType)) {
            this.setAutofillHints(view, "creditCardExpirationDate");
        } else if ("cc-exp-month".equals(autoCompleteType)) {
            this.setAutofillHints(view, "creditCardExpirationMonth");
        } else if ("cc-exp-year".equals(autoCompleteType)) {
            this.setAutofillHints(view, "creditCardExpirationYear");
        } else if ("off".equals(autoCompleteType)) {
            this.setImportantForAutofill(view, 2);
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid autoCompleteType: " + autoCompleteType);
        }
    }

    @ReactProp(name="autoCorrect")
    public void setAutoCorrect(ReactEditText view, @Nullable Boolean autoCorrect) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, 557056, autoCorrect != null ? (autoCorrect.booleanValue() ? 32768 : 524288) : 0);
    }

    @ReactProp(name="multiline", defaultBoolean=false)
    public void setMultiline(ReactEditText view, boolean multiline) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, multiline ? 0 : 131072, multiline ? 131072 : 0);
    }

    @ReactProp(name="secureTextEntry", defaultBoolean=false)
    public void setSecureTextEntry(ReactEditText view, boolean password) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, password ? 0 : 144, password ? 128 : 0);
        ReactTextInputManager.checkPasswordType(view);
    }

    @ReactProp(name="autoCapitalize")
    public void setAutoCapitalize(ReactEditText view, Dynamic autoCapitalize) {
        int autoCapitalizeValue = 16384;
        if (autoCapitalize.getType() == ReadableType.Number) {
            autoCapitalizeValue = autoCapitalize.asInt();
        } else if (autoCapitalize.getType() == ReadableType.String) {
            String autoCapitalizeStr = autoCapitalize.asString();
            if (autoCapitalizeStr.equals("none")) {
                autoCapitalizeValue = 0;
            } else if (autoCapitalizeStr.equals("characters")) {
                autoCapitalizeValue = 4096;
            } else if (autoCapitalizeStr.equals("words")) {
                autoCapitalizeValue = 8192;
            } else if (autoCapitalizeStr.equals("sentences")) {
                autoCapitalizeValue = 16384;
            }
        }
        ReactTextInputManager.updateStagedInputTypeFlag(view, 28672, autoCapitalizeValue);
    }

    @ReactProp(name="keyboardType")
    public void setKeyboardType(ReactEditText view, @Nullable String keyboardType) {
        int flagsToSet = 1;
        boolean unsettingFlagsBreaksAutocomplete = false;
        if (KEYBOARD_TYPE_NUMERIC.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 12290;
        } else if (KEYBOARD_TYPE_NUMBER_PAD.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 2;
        } else if (KEYBOARD_TYPE_DECIMAL_PAD.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 8194;
        } else if (KEYBOARD_TYPE_EMAIL_ADDRESS.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 33;
        } else if (KEYBOARD_TYPE_PHONE_PAD.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 3;
        } else if (KEYBOARD_TYPE_VISIBLE_PASSWORD.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 144;
        } else if ((view.getStagedInputType() & 0x7000) != 0) {
            unsettingFlagsBreaksAutocomplete = true;
        }
        ReactTextInputManager.updateStagedInputTypeFlag(view, unsettingFlagsBreaksAutocomplete ? 0 : 12339, flagsToSet);
        ReactTextInputManager.checkPasswordType(view);
    }

    @ReactProp(name="returnKeyType")
    public void setReturnKeyType(ReactEditText view, String returnKeyType) {
        view.setReturnKeyType(returnKeyType);
    }

    @ReactProp(name="disableFullscreenUI", defaultBoolean=false)
    public void setDisableFullscreenUI(ReactEditText view, boolean disableFullscreenUI) {
        view.setDisableFullscreenUI(disableFullscreenUI);
    }

    @ReactProp(name="returnKeyLabel")
    public void setReturnKeyLabel(ReactEditText view, String returnKeyLabel) {
        view.setImeActionLabel(returnKeyLabel, 1648);
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public void setBorderRadius(ReactEditText view, int index, float borderRadius) {
        if (!YogaConstants.isUndefined(borderRadius)) {
            borderRadius = PixelUtil.toPixelFromDIP(borderRadius);
        }
        if (index == 0) {
            view.setBorderRadius(borderRadius);
        } else {
            view.setBorderRadius(borderRadius, index - 1);
        }
    }

    @ReactProp(name="borderStyle")
    public void setBorderStyle(ReactEditText view, @Nullable String borderStyle) {
        view.setBorderStyle(borderStyle);
    }

    @ReactProp(name="showSoftInputOnFocus", defaultBoolean=true)
    public void showKeyboardOnFocus(ReactEditText view, boolean showKeyboardOnFocus) {
        view.setShowSoftInputOnFocus(showKeyboardOnFocus);
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public void setBorderWidth(ReactEditText view, int index, float width) {
        if (!YogaConstants.isUndefined(width)) {
            width = PixelUtil.toPixelFromDIP(width);
        }
        view.setBorderWidth(SPACING_TYPES[index], width);
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color")
    public void setBorderColor(ReactEditText view, int index, Integer color) {
        float rgbComponent = color == null ? Float.NaN : (float)(color & 0xFFFFFF);
        float alphaComponent = color == null ? Float.NaN : (float)(color >>> 24);
        view.setBorderColor(SPACING_TYPES[index], rgbComponent, alphaComponent);
    }

    @Override
    protected void onAfterUpdateTransaction(ReactEditText view) {
        super.onAfterUpdateTransaction(view);
        view.maybeUpdateTypeface();
        view.commitStagedInputType();
    }

    private static void checkPasswordType(ReactEditText view) {
        if ((view.getStagedInputType() & 0x3002) != 0 && (view.getStagedInputType() & 0x80) != 0) {
            ReactTextInputManager.updateStagedInputTypeFlag(view, 128, 16);
        }
    }

    private static void updateStagedInputTypeFlag(ReactEditText view, int flagsToUnset, int flagsToSet) {
        view.setStagedInputType(view.getStagedInputType() & ~flagsToUnset | flagsToSet);
    }

    @Override
    protected void addEventEmitters(final ThemedReactContext reactContext, final ReactEditText editText) {
        editText.addTextChangedListener(new ReactTextInputTextWatcher(reactContext, editText));
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
                if (hasFocus) {
                    eventDispatcher.dispatchEvent(new ReactTextInputFocusEvent(editText.getId()));
                } else {
                    eventDispatcher.dispatchEvent(new ReactTextInputBlurEvent(editText.getId()));
                    eventDispatcher.dispatchEvent(new ReactTextInputEndEditingEvent(editText.getId(), editText.getText().toString()));
                }
            }
        });
        editText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent keyEvent) {
                if ((actionId & 0xFF) != 0 || actionId == 0) {
                    boolean blurOnSubmit = editText.getBlurOnSubmit();
                    boolean isMultiline = editText.isMultiline();
                    EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
                    eventDispatcher.dispatchEvent(new ReactTextInputSubmitEditingEvent(editText.getId(), editText.getText().toString()));
                    if (blurOnSubmit) {
                        editText.clearFocus();
                    }
                    if (blurOnSubmit || !isMultiline) {
                        return true;
                    }
                    return actionId == 5 || actionId == 7;
                }
                return true;
            }
        });
    }

    @Override
    @Nullable
    public Map getExportedViewConstants() {
        return MapBuilder.of("AutoCapitalizationType", MapBuilder.of("none", 0, "characters", 4096, "words", 8192, "sentences", 16384));
    }

    @Override
    public void setPadding(ReactEditText view, int left, int top, int right, int bottom) {
        view.setPadding(left, top, right, bottom);
    }

    private int getTextBreakStrategy(@Nullable String textBreakStrategy) {
        int androidTextBreakStrategy = 1;
        if (textBreakStrategy != null) {
            switch (textBreakStrategy) {
                case "simple": {
                    androidTextBreakStrategy = 0;
                    break;
                }
                case "balanced": {
                    androidTextBreakStrategy = 2;
                    break;
                }
                default: {
                    androidTextBreakStrategy = 1;
                }
            }
        }
        return androidTextBreakStrategy;
    }

    @Override
    public Object updateState(ReactEditText view, ReactStylesDiffMap props, @Nullable StateWrapper stateWrapper) {
        ReadableNativeMap state = stateWrapper.getState();
        ReadableNativeMap attributedString = state.getMap("attributedString");
        ReadableNativeMap paragraphAttributes = state.getMap("paragraphAttributes");
        Spannable spanned = TextLayoutManager.getOrCreateSpannableForText(view.getContext(), attributedString);
        TextAttributeProps textViewProps = new TextAttributeProps(props);
        int textBreakStrategy = this.getTextBreakStrategy(paragraphAttributes.getString("textBreakStrategy"));
        int justificationMode = 0;
        view.mStateWrapper = stateWrapper;
        return ReactTextUpdate.buildReactTextUpdateFromState(spanned, state.getInt("mostRecentEventCount"), false, textViewProps.getTextAlign(), textBreakStrategy, justificationMode, attributedString);
    }

    private class ReactScrollWatcher
    implements ScrollWatcher {
        private ReactEditText mReactEditText;
        private EventDispatcher mEventDispatcher;
        private int mPreviousHoriz;
        private int mPreviousVert;

        public ReactScrollWatcher(ReactEditText editText) {
            this.mReactEditText = editText;
            ReactContext reactContext = (ReactContext)editText.getContext();
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        }

        @Override
        public void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
            if (this.mPreviousHoriz != horiz || this.mPreviousVert != vert) {
                ScrollEvent event = ScrollEvent.obtain(this.mReactEditText.getId(), ScrollEventType.SCROLL, horiz, vert, 0.0f, 0.0f, 0, 0, this.mReactEditText.getWidth(), this.mReactEditText.getHeight());
                this.mEventDispatcher.dispatchEvent(event);
                this.mPreviousHoriz = horiz;
                this.mPreviousVert = vert;
            }
        }
    }

    private class ReactSelectionWatcher
    implements SelectionWatcher {
        private ReactEditText mReactEditText;
        private EventDispatcher mEventDispatcher;
        private int mPreviousSelectionStart;
        private int mPreviousSelectionEnd;

        public ReactSelectionWatcher(ReactEditText editText) {
            this.mReactEditText = editText;
            ReactContext reactContext = (ReactContext)editText.getContext();
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        }

        @Override
        public void onSelectionChanged(int start, int end) {
            int realStart = Math.min(start, end);
            int realEnd = Math.max(start, end);
            if (this.mPreviousSelectionStart != realStart || this.mPreviousSelectionEnd != realEnd) {
                this.mEventDispatcher.dispatchEvent(new ReactTextInputSelectionEvent(this.mReactEditText.getId(), realStart, realEnd));
                this.mPreviousSelectionStart = realStart;
                this.mPreviousSelectionEnd = realEnd;
            }
        }
    }

    private class ReactContentSizeWatcher
    implements ContentSizeWatcher {
        private ReactEditText mEditText;
        private EventDispatcher mEventDispatcher;
        private int mPreviousContentWidth = 0;
        private int mPreviousContentHeight = 0;

        public ReactContentSizeWatcher(ReactEditText editText) {
            this.mEditText = editText;
            ReactContext reactContext = (ReactContext)editText.getContext();
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        }

        @Override
        public void onLayout() {
            int contentWidth = this.mEditText.getWidth();
            int contentHeight = this.mEditText.getHeight();
            if (this.mEditText.getLayout() != null) {
                contentWidth = this.mEditText.getCompoundPaddingLeft() + this.mEditText.getLayout().getWidth() + this.mEditText.getCompoundPaddingRight();
                contentHeight = this.mEditText.getCompoundPaddingTop() + this.mEditText.getLayout().getHeight() + this.mEditText.getCompoundPaddingBottom();
            }
            if (contentWidth != this.mPreviousContentWidth || contentHeight != this.mPreviousContentHeight) {
                this.mPreviousContentHeight = contentHeight;
                this.mPreviousContentWidth = contentWidth;
                this.mEventDispatcher.dispatchEvent(new ReactContentSizeChangedEvent(this.mEditText.getId(), PixelUtil.toDIPFromPixel(contentWidth), PixelUtil.toDIPFromPixel(contentHeight)));
            }
        }
    }

    private class ReactTextInputTextWatcher
    implements TextWatcher {
        private EventDispatcher mEventDispatcher;
        private ReactEditText mEditText;
        private String mPreviousText;

        public ReactTextInputTextWatcher(ReactContext reactContext, ReactEditText editText) {
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
            this.mEditText = editText;
            this.mPreviousText = null;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            this.mPreviousText = s.toString();
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (this.mEditText.mDisableTextDiffing) {
                return;
            }
            if (count == 0 && before == 0) {
                return;
            }
            Assertions.assertNotNull((Object)this.mPreviousText);
            String newText = s.toString().substring(start, start + count);
            String oldText = this.mPreviousText.substring(start, start + before);
            if (count == before && newText.equals(oldText)) {
                return;
            }
            JavaOnlyMap attributedString = this.mEditText.mAttributedString;
            if (attributedString != null && attributedString.hasKey("fragments")) {
                String changedText = s.subSequence(start, start + count).toString();
                String completeStr = attributedString.getString("string");
                String newCompleteStr = completeStr.substring(0, start) + changedText + (completeStr.length() > start + before ? completeStr.substring(start + before) : "");
                attributedString.putString("string", newCompleteStr);
                JavaOnlyArray fragments = (JavaOnlyArray)attributedString.getArray("fragments");
                int positionInAttributedString = 0;
                boolean found = false;
                for (int i = 0; i < fragments.size() && !found; ++i) {
                    JavaOnlyMap fragment = (JavaOnlyMap)fragments.getMap(i);
                    String fragmentStr = fragment.getString("string");
                    int positionBefore = positionInAttributedString;
                    if ((positionInAttributedString += fragmentStr.length()) < start) continue;
                    int relativePosition = start - positionBefore;
                    found = true;
                    int remaining = fragmentStr.length() - relativePosition;
                    String newString = fragmentStr.substring(0, relativePosition) + changedText + fragmentStr.substring(relativePosition + Math.min(before, remaining));
                    fragment.putString("string", newString);
                    if (remaining >= before) continue;
                    changedText = "";
                    start += remaining;
                    before -= remaining;
                    found = false;
                }
            }
            if (this.mEditText.mStateWrapper != null && attributedString != null) {
                WritableNativeMap map = new WritableNativeMap();
                WritableNativeMap newAttributedString = new WritableNativeMap();
                WritableNativeArray fragments = new WritableNativeArray();
                for (int i = 0; i < attributedString.getArray("fragments").size(); ++i) {
                    ReadableMap readableFragment = attributedString.getArray("fragments").getMap(i);
                    WritableNativeMap fragment = new WritableNativeMap();
                    fragment.putDouble("reactTag", readableFragment.getInt("reactTag"));
                    fragment.putString("string", readableFragment.getString("string"));
                    fragments.pushMap(fragment);
                }
                newAttributedString.putString("string", attributedString.getString("string"));
                newAttributedString.putArray("fragments", fragments);
                map.putInt("mostRecentEventCount", this.mEditText.incrementAndGetEventCounter());
                map.putMap("textChanged", newAttributedString);
                this.mEditText.mStateWrapper.updateState(map);
            }
            this.mEventDispatcher.dispatchEvent(new ReactTextChangedEvent(this.mEditText.getId(), s.toString(), this.mEditText.incrementAndGetEventCounter()));
            this.mEventDispatcher.dispatchEvent(new ReactTextInputEvent(this.mEditText.getId(), newText, oldText, start, start + before));
        }

        public void afterTextChanged(Editable s) {
        }
    }
}

