/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.art;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.art.ARTShapeShadowNode;

public class ARTTextShadowNode
extends ARTShapeShadowNode {
    private static final String PROP_LINES = "lines";
    private static final String PROP_FONT = "font";
    private static final String PROP_FONT_FAMILY = "fontFamily";
    private static final String PROP_FONT_SIZE = "fontSize";
    private static final String PROP_FONT_STYLE = "fontStyle";
    private static final String PROP_FONT_WEIGHT = "fontWeight";
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final int TEXT_ALIGNMENT_CENTER = 2;
    private static final int TEXT_ALIGNMENT_LEFT = 0;
    private static final int TEXT_ALIGNMENT_RIGHT = 1;
    @Nullable
    private ReadableMap mFrame;
    private int mTextAlignment = 0;

    @ReactProp(name="frame")
    public void setFrame(@Nullable ReadableMap frame) {
        this.mFrame = frame;
    }

    @ReactProp(name="alignment", defaultInt=0)
    public void setAlignment(int alignment) {
        this.mTextAlignment = alignment;
    }

    @Override
    public void draw(Canvas canvas, Paint paint, float opacity) {
        if (this.mFrame == null) {
            return;
        }
        if ((opacity *= this.mOpacity) <= 0.01f) {
            return;
        }
        if (!this.mFrame.hasKey(PROP_LINES)) {
            return;
        }
        ReadableArray linesProp = this.mFrame.getArray(PROP_LINES);
        if (linesProp == null || linesProp.size() == 0) {
            return;
        }
        this.saveAndSetupCanvas(canvas);
        Object[] lines = new String[linesProp.size()];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = linesProp.getString(i);
        }
        String text = TextUtils.join((CharSequence)"\n", (Object[])lines);
        if (this.setupStrokePaint(paint, opacity)) {
            this.applyTextPropertiesToPaint(paint);
            if (this.mPath == null) {
                canvas.drawText(text, 0.0f, -paint.ascent(), paint);
            } else {
                canvas.drawTextOnPath(text, this.mPath, 0.0f, 0.0f, paint);
            }
        }
        if (this.setupFillPaint(paint, opacity)) {
            this.applyTextPropertiesToPaint(paint);
            if (this.mPath == null) {
                canvas.drawText(text, 0.0f, -paint.ascent(), paint);
            } else {
                canvas.drawTextOnPath(text, this.mPath, 0.0f, 0.0f, paint);
            }
        }
        this.restoreCanvas(canvas);
        this.markUpdateSeen();
    }

    private void applyTextPropertiesToPaint(Paint paint) {
        ReadableMap font;
        int alignment = this.mTextAlignment;
        switch (alignment) {
            case 0: {
                paint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 1: {
                paint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            case 2: {
                paint.setTextAlign(Paint.Align.CENTER);
            }
        }
        if (this.mFrame != null && this.mFrame.hasKey(PROP_FONT) && (font = this.mFrame.getMap(PROP_FONT)) != null) {
            boolean isItalic;
            float fontSize = 12.0f;
            if (font.hasKey(PROP_FONT_SIZE)) {
                fontSize = (float)font.getDouble(PROP_FONT_SIZE);
            }
            paint.setTextSize(fontSize * this.mScale);
            boolean isBold = font.hasKey(PROP_FONT_WEIGHT) && "bold".equals(font.getString(PROP_FONT_WEIGHT));
            boolean bl = isItalic = font.hasKey(PROP_FONT_STYLE) && "italic".equals(font.getString(PROP_FONT_STYLE));
            int fontStyle = isBold && isItalic ? 3 : (isBold ? 1 : (isItalic ? 2 : 0));
            paint.setTypeface(Typeface.create((String)font.getString(PROP_FONT_FAMILY), (int)fontStyle));
        }
    }
}

