/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.JavascriptException;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.util.ExceptionDataHelper;
import com.facebook.react.util.JSStackTrace;

@ReactModule(name="ExceptionsManager")
public class ExceptionsManagerModule
extends ReactContextBaseJavaModule {
    public static final String NAME = "ExceptionsManager";
    private final DevSupportManager mDevSupportManager;

    public ExceptionsManagerModule(DevSupportManager devSupportManager) {
        this.mDevSupportManager = devSupportManager;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void reportFatalException(String message, ReadableArray stack, int id2) {
        JavaOnlyMap data = new JavaOnlyMap();
        data.putString("message", message);
        data.putArray("stack", stack);
        data.putInt("id", id2);
        data.putBoolean("isFatal", true);
        this.reportException(data);
    }

    @ReactMethod
    public void reportSoftException(String message, ReadableArray stack, int id2) {
        JavaOnlyMap data = new JavaOnlyMap();
        data.putString("message", message);
        data.putArray("stack", stack);
        data.putInt("id", id2);
        data.putBoolean("isFatal", false);
        this.reportException(data);
    }

    @ReactMethod
    public void reportException(ReadableMap data) {
        boolean isFatal;
        String message = data.hasKey("message") ? data.getString("message") : "";
        WritableArray stack = data.hasKey("stack") ? data.getArray("stack") : Arguments.createArray();
        int id2 = data.hasKey("id") ? data.getInt("id") : -1;
        boolean bl = isFatal = data.hasKey("isFatal") ? data.getBoolean("isFatal") : false;
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            boolean suppressRedBox = false;
            if (data.getMap("extraData") != null && data.getMap("extraData").hasKey("suppressRedBox")) {
                suppressRedBox = data.getMap("extraData").getBoolean("suppressRedBox");
            }
            if (!suppressRedBox) {
                this.mDevSupportManager.showNewJSError(message, stack, id2);
            }
        } else {
            String extraDataAsJson = ExceptionDataHelper.getExtraDataAsJson(data);
            if (isFatal) {
                throw new JavascriptException(JSStackTrace.format(message, stack)).setExtraDataAsJson(extraDataAsJson);
            }
            FLog.e((String)"ReactNative", (String)JSStackTrace.format(message, stack));
            if (extraDataAsJson != null) {
                FLog.d((String)"ReactNative", (String)"extraData: %s", (Object)extraDataAsJson);
            }
        }
    }

    @ReactMethod
    public void updateExceptionMessage(String title, ReadableArray details, int exceptionId) {
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            this.mDevSupportManager.updateJSError(title, details, exceptionId);
        }
    }

    @ReactMethod
    public void dismissRedbox() {
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            this.mDevSupportManager.hideRedboxDialog();
        }
    }
}

