/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import androidx.annotation.NonNull;
import com.facebook.react.bridge.JSIModuleProvider;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.fabric.Binding;
import com.facebook.react.fabric.ComponentFactoryDelegate;
import com.facebook.react.fabric.FabricComponents;
import com.facebook.react.fabric.FabricSoLoader;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.GuardedFrameCallback;
import com.facebook.react.fabric.ReactNativeConfig;
import com.facebook.react.fabric.StateWrapperImpl;
import com.facebook.react.fabric.events.EventBeatManager;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.events.FabricEventEmitter;
import com.facebook.react.fabric.mounting.LayoutMetricsConversions;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.BatchMountItem;
import com.facebook.react.fabric.mounting.mountitems.DeleteMountItem;
import com.facebook.react.fabric.mounting.mountitems.DispatchCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.DispatchStringCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.InsertMountItem;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.fabric.mounting.mountitems.PreAllocateViewMountItem;
import com.facebook.react.fabric.mounting.mountitems.RemoveMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdateEventEmitterMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdateLayoutMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdateLocalDataMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdatePaddingMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdatePropsMountItem;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.BatchEventDispatchedListener;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;

public class FabricJSIModuleProvider
implements JSIModuleProvider<UIManager> {
    @NonNull
    private final JavaScriptContextHolder mJSContext;
    @NonNull
    private final ReactApplicationContext mReactApplicationContext;
    @NonNull
    private final ComponentFactoryDelegate mComponentFactoryDelegate;
    @NonNull
    private final ReactNativeConfig mConfig;

    public FabricJSIModuleProvider(@NonNull ReactApplicationContext reactApplicationContext, @NonNull JavaScriptContextHolder jsContext, @NonNull ComponentFactoryDelegate componentFactoryDelegate, @NonNull ReactNativeConfig config) {
        this.mReactApplicationContext = reactApplicationContext;
        this.mJSContext = jsContext;
        this.mComponentFactoryDelegate = componentFactoryDelegate;
        this.mConfig = config;
    }

    @Override
    public UIManager get() {
        EventBeatManager eventBeatManager = new EventBeatManager(this.mReactApplicationContext);
        FabricUIManager uiManager = this.createUIManager(eventBeatManager);
        Systrace.beginSection(0L, "FabricJSIModuleProvider.registerBinding");
        Binding binding = new Binding();
        FabricJSIModuleProvider.loadClasses();
        MessageQueueThread jsMessageQueueThread = this.mReactApplicationContext.getCatalystInstance().getReactQueueConfiguration().getJSQueueThread();
        binding.register(this.mJSContext, uiManager, eventBeatManager, jsMessageQueueThread, this.mComponentFactoryDelegate, this.mConfig);
        Systrace.endSection(0L);
        return uiManager;
    }

    private FabricUIManager createUIManager(@NonNull EventBeatManager eventBeatManager) {
        Systrace.beginSection(0L, "FabricJSIModuleProvider.createUIManager");
        UIManagerModule nativeModule = this.mReactApplicationContext.getNativeModule(UIManagerModule.class);
        EventDispatcher eventDispatcher = nativeModule.getEventDispatcher();
        FabricUIManager fabricUIManager = new FabricUIManager(this.mReactApplicationContext, nativeModule.getViewManagerRegistry_DO_NOT_USE(), eventDispatcher, eventBeatManager);
        Systrace.endSection(0L);
        return fabricUIManager;
    }

    private static void loadClasses() {
        BatchEventDispatchedListener.class.getClass();
        ReactNativeConfig.class.getClass();
        FabricComponents.class.getClass();
        StateWrapper.class.getClass();
        FabricEventEmitter.class.getClass();
        FabricUIManager.class.getClass();
        GuardedFrameCallback.class.getClass();
        BatchMountItem.class.getClass();
        DeleteMountItem.class.getClass();
        DispatchCommandMountItem.class.getClass();
        DispatchStringCommandMountItem.class.getClass();
        InsertMountItem.class.getClass();
        MountItem.class.getClass();
        RemoveMountItem.class.getClass();
        UpdateEventEmitterMountItem.class.getClass();
        UpdateLayoutMountItem.class.getClass();
        UpdateLocalDataMountItem.class.getClass();
        UpdatePaddingMountItem.class.getClass();
        UpdatePropsMountItem.class.getClass();
        LayoutMetricsConversions.class.getClass();
        MountingManager.class.getClass();
        Binding.class.getClass();
        ComponentFactoryDelegate.class.getClass();
        EventBeatManager.class.getClass();
        EventEmitterWrapper.class.getClass();
        StateWrapperImpl.class.getClass();
        FabricSoLoader.class.getClass();
        PreAllocateViewMountItem.class.getClass();
    }
}

