/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

import android.os.Build;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;

public class ReactQueueConfigurationSpec {
    private static final long LEGACY_STACK_SIZE_BYTES = 2000000L;
    private final MessageQueueThreadSpec mNativeModulesQueueThreadSpec;
    private final MessageQueueThreadSpec mJSQueueThreadSpec;

    private ReactQueueConfigurationSpec(MessageQueueThreadSpec nativeModulesQueueThreadSpec, MessageQueueThreadSpec jsQueueThreadSpec) {
        this.mNativeModulesQueueThreadSpec = nativeModulesQueueThreadSpec;
        this.mJSQueueThreadSpec = jsQueueThreadSpec;
    }

    public MessageQueueThreadSpec getNativeModulesQueueThreadSpec() {
        return this.mNativeModulesQueueThreadSpec;
    }

    public MessageQueueThreadSpec getJSQueueThreadSpec() {
        return this.mJSQueueThreadSpec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReactQueueConfigurationSpec createDefault() {
        MessageQueueThreadSpec spec = Build.VERSION.SDK_INT < 21 ? MessageQueueThreadSpec.newBackgroundThreadSpec("native_modules", 2000000L) : MessageQueueThreadSpec.newBackgroundThreadSpec("native_modules");
        return ReactQueueConfigurationSpec.builder().setJSQueueThreadSpec(MessageQueueThreadSpec.newBackgroundThreadSpec("js")).setNativeModulesQueueThreadSpec(spec).build();
    }

    public static class Builder {
        @Nullable
        private MessageQueueThreadSpec mNativeModulesQueueSpec;
        @Nullable
        private MessageQueueThreadSpec mJSQueueSpec;

        public Builder setNativeModulesQueueThreadSpec(MessageQueueThreadSpec spec) {
            Assertions.assertCondition((this.mNativeModulesQueueSpec == null ? 1 : 0) != 0, (String)"Setting native modules queue spec multiple times!");
            this.mNativeModulesQueueSpec = spec;
            return this;
        }

        public Builder setJSQueueThreadSpec(MessageQueueThreadSpec spec) {
            Assertions.assertCondition((this.mJSQueueSpec == null ? 1 : 0) != 0, (String)"Setting JS queue multiple times!");
            this.mJSQueueSpec = spec;
            return this;
        }

        public ReactQueueConfigurationSpec build() {
            return new ReactQueueConfigurationSpec((MessageQueueThreadSpec)Assertions.assertNotNull((Object)this.mNativeModulesQueueSpec), (MessageQueueThreadSpec)Assertions.assertNotNull((Object)this.mJSQueueSpec));
        }
    }
}

