/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.Nullable;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ReactMarkerConstants;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@DoNotStrip
public class ReactMarker {
    private static final List<MarkerListener> sListeners = new CopyOnWriteArrayList<MarkerListener>();
    private static final List<FabricMarkerListener> sFabricMarkerListeners = new CopyOnWriteArrayList<FabricMarkerListener>();

    @DoNotStrip
    public static void addListener(MarkerListener listener) {
        if (!sListeners.contains(listener)) {
            sListeners.add(listener);
        }
    }

    @DoNotStrip
    public static void removeListener(MarkerListener listener) {
        sListeners.remove(listener);
    }

    @DoNotStrip
    public static void clearMarkerListeners() {
        sListeners.clear();
    }

    @DoNotStrip
    public static void addFabricListener(FabricMarkerListener listener) {
        if (!sFabricMarkerListeners.contains(listener)) {
            sFabricMarkerListeners.add(listener);
        }
    }

    @DoNotStrip
    public static void removeFabricListener(FabricMarkerListener listener) {
        sFabricMarkerListeners.remove(listener);
    }

    @DoNotStrip
    public static void clearFabricMarkerListeners() {
        sFabricMarkerListeners.clear();
    }

    @DoNotStrip
    public static void logFabricMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp) {
        for (FabricMarkerListener listener : sFabricMarkerListeners) {
            listener.logFabricMarker(name, tag, instanceKey, timestamp);
        }
    }

    @DoNotStrip
    public static void logFabricMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey) {
        ReactMarker.logFabricMarker(name, tag, instanceKey, -1L);
    }

    @DoNotStrip
    public static void logMarker(String name) {
        ReactMarker.logMarker(name, null);
    }

    @DoNotStrip
    public static void logMarker(String name, int instanceKey) {
        ReactMarker.logMarker(name, null, instanceKey);
    }

    @DoNotStrip
    public static void logMarker(String name, @Nullable String tag) {
        ReactMarker.logMarker(name, tag, 0);
    }

    @DoNotStrip
    public static void logMarker(String name, @Nullable String tag, int instanceKey) {
        ReactMarkerConstants marker = ReactMarkerConstants.valueOf(name);
        ReactMarker.logMarker(marker, tag, instanceKey);
    }

    @DoNotStrip
    public static void logMarker(ReactMarkerConstants name) {
        ReactMarker.logMarker(name, null, 0);
    }

    @DoNotStrip
    public static void logMarker(ReactMarkerConstants name, int instanceKey) {
        ReactMarker.logMarker(name, null, instanceKey);
    }

    @DoNotStrip
    public static void logMarker(ReactMarkerConstants name, @Nullable String tag) {
        ReactMarker.logMarker(name, tag, 0);
    }

    @DoNotStrip
    public static void logMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey) {
        ReactMarker.logFabricMarker(name, tag, instanceKey);
        for (MarkerListener listener : sListeners) {
            listener.logMarker(name, tag, instanceKey);
        }
    }

    public static interface FabricMarkerListener {
        public void logFabricMarker(ReactMarkerConstants var1, @Nullable String var2, int var3, long var4);
    }

    public static interface MarkerListener {
        public void logMarker(ReactMarkerConstants var1, @Nullable String var2, int var3);
    }
}

