/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.modal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.JSTouchDispatcher;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.common.ContextUtils;
import com.facebook.react.views.view.ReactViewGroup;
import java.util.ArrayList;

public class ReactModalHostView
extends ViewGroup
implements LifecycleEventListener {
    private DialogRootViewGroup mHostView;
    @Nullable
    private Dialog mDialog;
    private boolean mTransparent;
    private boolean mStatusBarTranslucent;
    private String mAnimationType;
    private boolean mHardwareAccelerated;
    private boolean mPropertyRequiresNewDialog;
    @Nullable
    private DialogInterface.OnShowListener mOnShowListener;
    @Nullable
    private OnRequestCloseListener mOnRequestCloseListener;

    public ReactModalHostView(Context context) {
        super(context);
        ((ReactContext)context).addLifecycleEventListener(this);
        this.mHostView = new DialogRootViewGroup(context);
    }

    @TargetApi(value=23)
    public void dispatchProvideStructure(ViewStructure structure) {
        this.mHostView.dispatchProvideStructure(structure);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.dismiss();
    }

    public void addView(View child, int index) {
        UiThreadUtil.assertOnUiThread();
        this.mHostView.addView(child, index);
    }

    public int getChildCount() {
        return this.mHostView.getChildCount();
    }

    public View getChildAt(int index) {
        return this.mHostView.getChildAt(index);
    }

    public void removeView(View child) {
        UiThreadUtil.assertOnUiThread();
        this.mHostView.removeView(child);
    }

    public void removeViewAt(int index) {
        UiThreadUtil.assertOnUiThread();
        View child = this.getChildAt(index);
        this.mHostView.removeView(child);
    }

    public void addChildrenForAccessibility(ArrayList<View> outChildren) {
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return false;
    }

    public void onDropInstance() {
        ((ReactContext)this.getContext()).removeLifecycleEventListener(this);
        this.dismiss();
    }

    private void dismiss() {
        UiThreadUtil.assertOnUiThread();
        if (this.mDialog != null) {
            Activity dialogContext;
            if (this.mDialog.isShowing() && ((dialogContext = ContextUtils.findContextOfType(this.mDialog.getContext(), Activity.class)) == null || !dialogContext.isFinishing())) {
                this.mDialog.dismiss();
            }
            this.mDialog = null;
            ViewGroup parent = (ViewGroup)this.mHostView.getParent();
            parent.removeViewAt(0);
        }
    }

    protected void setOnRequestCloseListener(OnRequestCloseListener listener) {
        this.mOnRequestCloseListener = listener;
    }

    protected void setOnShowListener(DialogInterface.OnShowListener listener) {
        this.mOnShowListener = listener;
    }

    protected void setTransparent(boolean transparent) {
        this.mTransparent = transparent;
    }

    protected void setStatusBarTranslucent(boolean statusBarTranslucent) {
        this.mStatusBarTranslucent = statusBarTranslucent;
        this.mPropertyRequiresNewDialog = true;
    }

    protected void setAnimationType(String animationType) {
        this.mAnimationType = animationType;
        this.mPropertyRequiresNewDialog = true;
    }

    protected void setHardwareAccelerated(boolean hardwareAccelerated) {
        this.mHardwareAccelerated = hardwareAccelerated;
        this.mPropertyRequiresNewDialog = true;
    }

    @Override
    public void onHostResume() {
        this.showOrUpdate();
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
        this.onDropInstance();
    }

    @VisibleForTesting
    @Nullable
    public Dialog getDialog() {
        return this.mDialog;
    }

    @Nullable
    private Activity getCurrentActivity() {
        return ((ReactContext)this.getContext()).getCurrentActivity();
    }

    protected void showOrUpdate() {
        UiThreadUtil.assertOnUiThread();
        if (this.mDialog != null) {
            if (this.mPropertyRequiresNewDialog) {
                this.dismiss();
            } else {
                this.updateProperties();
                return;
            }
        }
        this.mPropertyRequiresNewDialog = false;
        int theme = R.style.Theme_FullScreenDialog;
        if (this.mAnimationType.equals("fade")) {
            theme = R.style.Theme_FullScreenDialogAnimatedFade;
        } else if (this.mAnimationType.equals("slide")) {
            theme = R.style.Theme_FullScreenDialogAnimatedSlide;
        }
        Activity currentActivity = this.getCurrentActivity();
        Activity context = currentActivity == null ? this.getContext() : currentActivity;
        this.mDialog = new Dialog((Context)context, theme);
        this.mDialog.getWindow().setFlags(8, 8);
        this.mDialog.setContentView(this.getContentView());
        this.updateProperties();
        this.mDialog.setOnShowListener(this.mOnShowListener);
        this.mDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (event.getAction() == 1) {
                    if (keyCode == 4) {
                        Assertions.assertNotNull((Object)ReactModalHostView.this.mOnRequestCloseListener, (String)"setOnRequestCloseListener must be called by the manager");
                        ReactModalHostView.this.mOnRequestCloseListener.onRequestClose(dialog);
                        return true;
                    }
                    Activity currentActivity = ((ReactContext)ReactModalHostView.this.getContext()).getCurrentActivity();
                    if (currentActivity != null) {
                        return currentActivity.onKeyUp(keyCode, event);
                    }
                }
                return false;
            }
        });
        this.mDialog.getWindow().setSoftInputMode(16);
        if (this.mHardwareAccelerated) {
            this.mDialog.getWindow().addFlags(0x1000000);
        }
        if (currentActivity != null && !currentActivity.isFinishing()) {
            this.mDialog.show();
            if (context instanceof Activity) {
                this.mDialog.getWindow().getDecorView().setSystemUiVisibility(context.getWindow().getDecorView().getSystemUiVisibility());
            }
            this.mDialog.getWindow().clearFlags(8);
        }
    }

    @UiThread
    public void updateState(StateWrapper stateWrapper, int width, int height) {
        this.mHostView.updateState(stateWrapper, width, height);
    }

    private View getContentView() {
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.addView((View)this.mHostView);
        if (this.mStatusBarTranslucent) {
            frameLayout.setSystemUiVisibility(1024);
        } else {
            frameLayout.setFitsSystemWindows(true);
        }
        return frameLayout;
    }

    private void updateProperties() {
        Assertions.assertNotNull((Object)this.mDialog, (String)"mDialog must exist when we call updateProperties");
        Activity currentActivity = this.getCurrentActivity();
        if (currentActivity != null) {
            int activityWindowFlags = currentActivity.getWindow().getAttributes().flags;
            if ((activityWindowFlags & 0x400) != 0) {
                this.mDialog.getWindow().addFlags(1024);
            } else {
                this.mDialog.getWindow().clearFlags(1024);
            }
        }
        if (this.mTransparent) {
            this.mDialog.getWindow().clearFlags(2);
        } else {
            this.mDialog.getWindow().setDimAmount(0.5f);
            this.mDialog.getWindow().setFlags(2, 2);
        }
    }

    static class DialogRootViewGroup
    extends ReactViewGroup
    implements RootView {
        private boolean hasAdjustedSize = false;
        private int viewWidth;
        private int viewHeight;
        @Nullable
        private StateWrapper mStateWrapper;
        private final JSTouchDispatcher mJSTouchDispatcher = new JSTouchDispatcher(this);

        public DialogRootViewGroup(Context context) {
            super(context);
        }

        @Override
        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
            this.viewWidth = w;
            this.viewHeight = h;
            this.updateFirstChildView();
        }

        private void updateFirstChildView() {
            if (this.getChildCount() > 0) {
                this.hasAdjustedSize = false;
                final int viewTag = this.getChildAt(0).getId();
                if (this.mStateWrapper != null) {
                    this.updateState(this.mStateWrapper, this.viewWidth, this.viewHeight);
                } else {
                    ReactContext reactContext = this.getReactContext();
                    reactContext.runOnNativeModulesQueueThread(new GuardedRunnable(reactContext){

                        @Override
                        public void runGuarded() {
                            this.getReactContext().getNativeModule(UIManagerModule.class).updateNodeSize(viewTag, viewWidth, viewHeight);
                        }
                    });
                }
            } else {
                this.hasAdjustedSize = true;
            }
        }

        @UiThread
        public void updateState(StateWrapper stateWrapper, int width, int height) {
            this.mStateWrapper = stateWrapper;
            WritableNativeMap map = new WritableNativeMap();
            map.putDouble("screenWidth", PixelUtil.toDIPFromPixel(width));
            map.putDouble("screenHeight", PixelUtil.toDIPFromPixel(height));
            stateWrapper.updateState(map);
        }

        @Override
        public void addView(View child, int index, ViewGroup.LayoutParams params) {
            super.addView(child, index, params);
            if (this.hasAdjustedSize) {
                this.updateFirstChildView();
            }
        }

        @Override
        public void handleException(Throwable t) {
            this.getReactContext().handleException(new RuntimeException(t));
        }

        private ReactContext getReactContext() {
            return (ReactContext)this.getContext();
        }

        @Override
        public boolean onInterceptTouchEvent(MotionEvent event) {
            this.mJSTouchDispatcher.handleTouchEvent(event, this.getEventDispatcher());
            return super.onInterceptTouchEvent(event);
        }

        @Override
        public boolean onTouchEvent(MotionEvent event) {
            this.mJSTouchDispatcher.handleTouchEvent(event, this.getEventDispatcher());
            super.onTouchEvent(event);
            return true;
        }

        @Override
        public void onChildStartedNativeGesture(MotionEvent androidEvent) {
            this.mJSTouchDispatcher.onChildStartedNativeGesture(androidEvent, this.getEventDispatcher());
        }

        public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        }

        private EventDispatcher getEventDispatcher() {
            ReactContext reactContext = this.getReactContext();
            return reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        }
    }

    public static interface OnRequestCloseListener {
        public void onRequestClose(DialogInterface var1);
    }
}

