/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.modal;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.view.Display;
import android.view.WindowManager;
import com.facebook.infer.annotation.Assertions;

class ModalHostHelper {
    private static final Point MIN_POINT = new Point();
    private static final Point MAX_POINT = new Point();
    private static final Point SIZE_POINT = new Point();

    ModalHostHelper() {
    }

    public static Point getModalHostSize(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = ((WindowManager)Assertions.assertNotNull((Object)wm)).getDefaultDisplay();
        display.getCurrentSizeRange(MIN_POINT, MAX_POINT);
        display.getSize(SIZE_POINT);
        int[] attrs = new int[]{16843277};
        Resources.Theme theme = context.getTheme();
        TypedArray ta = theme.obtainStyledAttributes(attrs);
        boolean windowFullscreen = ta.getBoolean(0, false);
        Resources resources = context.getResources();
        int statusBarId = resources.getIdentifier("status_bar_height", "dimen", "android");
        int statusBarHeight = 0;
        if (windowFullscreen && statusBarId > 0) {
            statusBarHeight = (int)resources.getDimension(statusBarId);
        }
        if (ModalHostHelper.SIZE_POINT.x < ModalHostHelper.SIZE_POINT.y) {
            return new Point(ModalHostHelper.MIN_POINT.x, ModalHostHelper.MAX_POINT.y + statusBarHeight);
        }
        return new Point(ModalHostHelper.MAX_POINT.x, ModalHostHelper.MIN_POINT.y + statusBarHeight);
    }
}

