/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.opengl;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class DirectDrawer {
    private final String vertexShaderCode = "attribute vec4 vPosition;attribute vec2 inputTextureCoordinate;varying vec2 textureCoordinate;void main(){gl_Position = vPosition;textureCoordinate = inputTextureCoordinate;}";
    private final String fragmentShaderCode = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;varying vec2 textureCoordinate;\nuniform samplerExternalOES s_texture;\nvoid main() {  gl_FragColor = texture2D( s_texture, textureCoordinate );\n}";
    private FloatBuffer vertexBuffer;
    private FloatBuffer textureVerticesBuffer;
    private ShortBuffer drawListBuffer;
    private final int mProgram;
    private int mPositionHandle;
    private int mTextureCoordHandle;
    private short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private static final int COORDS_PER_VERTEX = 2;
    private final int vertexStride = 8;
    static float[] squareCoords = new float[]{-1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
    static float[] textureVertices = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    private int texture;

    public DirectDrawer(int texture) {
        this.texture = texture;
        ByteBuffer bb = ByteBuffer.allocateDirect(squareCoords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.vertexBuffer = bb.asFloatBuffer();
        this.vertexBuffer.put(squareCoords);
        this.vertexBuffer.position(0);
        ByteBuffer dlb = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
        dlb.order(ByteOrder.nativeOrder());
        this.drawListBuffer = dlb.asShortBuffer();
        this.drawListBuffer.put(this.drawOrder);
        this.drawListBuffer.position(0);
        ByteBuffer bb2 = ByteBuffer.allocateDirect(textureVertices.length * 4);
        bb2.order(ByteOrder.nativeOrder());
        this.textureVerticesBuffer = bb2.asFloatBuffer();
        this.textureVerticesBuffer.put(textureVertices);
        this.textureVerticesBuffer.position(0);
        int vertexShader = this.loadShader(35633, "attribute vec4 vPosition;attribute vec2 inputTextureCoordinate;varying vec2 textureCoordinate;void main(){gl_Position = vPosition;textureCoordinate = inputTextureCoordinate;}");
        int fragmentShader = this.loadShader(35632, "#extension GL_OES_EGL_image_external : require\nprecision mediump float;varying vec2 textureCoordinate;\nuniform samplerExternalOES s_texture;\nvoid main() {  gl_FragColor = texture2D( s_texture, textureCoordinate );\n}");
        this.mProgram = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)this.mProgram, (int)vertexShader);
        GLES20.glAttachShader((int)this.mProgram, (int)fragmentShader);
        GLES20.glLinkProgram((int)this.mProgram);
    }

    public void draw(float[] mtx) {
        GLES20.glUseProgram((int)this.mProgram);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.texture);
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"vPosition");
        GLES20.glEnableVertexAttribArray((int)this.mPositionHandle);
        GLES20.glVertexAttribPointer((int)this.mPositionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        this.mTextureCoordHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"inputTextureCoordinate");
        GLES20.glEnableVertexAttribArray((int)this.mTextureCoordHandle);
        GLES20.glVertexAttribPointer((int)this.mTextureCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVerticesBuffer);
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)this.mPositionHandle);
        GLES20.glDisableVertexAttribArray((int)this.mTextureCoordHandle);
    }

    private int loadShader(int type, String shaderCode) {
        int shader = GLES20.glCreateShader((int)type);
        GLES20.glShaderSource((int)shader, (String)shaderCode);
        GLES20.glCompileShader((int)shader);
        return shader;
    }
}

