/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromArray;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.config.ReactFeatureFlags;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@DoNotStrip
public class ReadableNativeArray
extends NativeArray
implements ReadableArray {
    @Nullable
    private Object[] mLocalArray;
    @Nullable
    private ReadableType[] mLocalTypeArray;
    private static int jniPassCounter;

    protected ReadableNativeArray(HybridData hybridData) {
        super(hybridData);
    }

    public static void setUseNativeAccessor(boolean useNativeAccessor) {
        ReactFeatureFlags.useArrayNativeAccessor = useNativeAccessor;
    }

    public static int getJNIPassCounter() {
        return jniPassCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getLocalArray() {
        if (this.mLocalArray != null) {
            return this.mLocalArray;
        }
        ReadableNativeArray readableNativeArray = this;
        synchronized (readableNativeArray) {
            if (this.mLocalArray == null) {
                ++jniPassCounter;
                this.mLocalArray = (Object[])Assertions.assertNotNull((Object)this.importArray());
            }
        }
        return this.mLocalArray;
    }

    private native Object[] importArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadableType[] getLocalTypeArray() {
        if (this.mLocalTypeArray != null) {
            return this.mLocalTypeArray;
        }
        ReadableNativeArray readableNativeArray = this;
        synchronized (readableNativeArray) {
            if (this.mLocalTypeArray == null) {
                ++jniPassCounter;
                Object[] tempArray = (Object[])Assertions.assertNotNull((Object)this.importTypeArray());
                this.mLocalTypeArray = (ReadableType[])Arrays.copyOf(tempArray, tempArray.length, ReadableType[].class);
            }
        }
        return this.mLocalTypeArray;
    }

    private native Object[] importTypeArray();

    @Override
    public int size() {
        if (ReactFeatureFlags.useArrayNativeAccessor) {
            ++jniPassCounter;
            return this.sizeNative();
        }
        return this.getLocalArray().length;
    }

    private native int sizeNative();

    @Override
    public boolean isNull(int index) {
        if (ReactFeatureFlags.useArrayNativeAccessor) {
            ++jniPassCounter;
            return this.isNullNative(index);
        }
        return this.getLocalArray()[index] == null;
    }

    private native boolean isNullNative(int var1);

    @Override
    public boolean getBoolean(int index) {
        if (ReactFeatureFlags.useArrayNativeAccessor) {
            ++jniPassCounter;
            return this.getBooleanNative(index);
        }
        return (Boolean)this.getLocalArray()[index];
    }

    private native boolean getBooleanNative(int var1);

    @Override
    public double getDouble(int index) {
        if (ReactFeatureFlags.useArrayNativeAccessor) {
            ++jniPassCounter;
            return this.getDoubleNative(index);
        }
        return (Double)this.getLocalArray()[index];
    }

    private native double getDoubleNative(int var1);

    @Override
    public int getInt(int index) {
        if (ReactFeatureFlags.useArrayNativeAccessor) {
            ++jniPassCounter;
            return this.getIntNative(index);
        }
        return ((Double)this.getLocalArray()[index]).intValue();
    }

    private native int getIntNative(int var1);

    @Override
    @Nullable
    public String getString(int index) {
        if (ReactFeatureFlags.useArrayNativeAccessor) {
            ++jniPassCounter;
            return this.getStringNative(index);
        }
        return (String)this.getLocalArray()[index];
    }

    private native String getStringNative(int var1);

    @Override
    @Nullable
    public ReadableNativeArray getArray(int index) {
        if (ReactFeatureFlags.useArrayNativeAccessor) {
            ++jniPassCounter;
            return this.getArrayNative(index);
        }
        return (ReadableNativeArray)this.getLocalArray()[index];
    }

    private native ReadableNativeArray getArrayNative(int var1);

    @Override
    @Nullable
    public ReadableNativeMap getMap(int index) {
        if (ReactFeatureFlags.useArrayNativeAccessor) {
            ++jniPassCounter;
            return this.getMapNative(index);
        }
        return (ReadableNativeMap)this.getLocalArray()[index];
    }

    private native ReadableNativeMap getMapNative(int var1);

    @Override
    @Nonnull
    public ReadableType getType(int index) {
        if (ReactFeatureFlags.useArrayNativeAccessor) {
            ++jniPassCounter;
            return this.getTypeNative(index);
        }
        return this.getLocalTypeArray()[index];
    }

    private native ReadableType getTypeNative(int var1);

    @Override
    @Nonnull
    public Dynamic getDynamic(int index) {
        return DynamicFromArray.create(this, index);
    }

    @Override
    @Nonnull
    public ArrayList<Object> toArrayList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block8: for (int i = 0; i < this.size(); ++i) {
            switch (this.getType(i)) {
                case Null: {
                    arrayList.add(null);
                    continue block8;
                }
                case Boolean: {
                    arrayList.add(this.getBoolean(i));
                    continue block8;
                }
                case Number: {
                    arrayList.add(this.getDouble(i));
                    continue block8;
                }
                case String: {
                    arrayList.add(this.getString(i));
                    continue block8;
                }
                case Map: {
                    arrayList.add(this.getMap(i).toHashMap());
                    continue block8;
                }
                case Array: {
                    arrayList.add(this.getArray(i).toArrayList());
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Could not convert object at index: " + i + ".");
                }
            }
        }
        return arrayList;
    }

    static {
        ReactBridge.staticInit();
        jniPassCounter = 0;
    }
}

