/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bdlocation;

import androidx.annotation.Nullable;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalArgumentException(Preconditions.format(string, objectArray));
        }
    }

    public static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalStateException(Preconditions.format(string, objectArray));
        }
    }

    public static <T> T checkNotNull(T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    public static <T> T checkNotNull(T t2, @Nullable Object object) {
        if (t2 == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t2;
    }

    public static <T> T checkNotNull(T t2, @Nullable String string, Object ... objectArray) {
        if (t2 == null) {
            throw new NullPointerException(Preconditions.format(string, objectArray));
        }
        return t2;
    }

    public static int checkElementIndex(int n2, int n3) {
        return Preconditions.checkElementIndex(n2, n3, "index");
    }

    public static int checkElementIndex(int n2, int n3, @Nullable String string) {
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(n2, n3, string));
        }
        return n2;
    }

    private static String badElementIndex(int n2, int n3, @Nullable String string) {
        if (n2 < 0) {
            return Preconditions.format("%s (%s) must not be negative", string, n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative size: " + n3);
        }
        return Preconditions.format("%s (%s) must be less than size (%s)", string, n2, n3);
    }

    public static int checkPositionIndex(int n2, int n3) {
        return Preconditions.checkPositionIndex(n2, n3, "index");
    }

    public static int checkPositionIndex(int n2, int n3, @Nullable String string) {
        if (n2 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(n2, n3, string));
        }
        return n2;
    }

    private static String badPositionIndex(int n2, int n3, @Nullable String string) {
        if (n2 < 0) {
            return Preconditions.format("%s (%s) must not be negative", string, n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative size: " + n3);
        }
        return Preconditions.format("%s (%s) must not be greater than size (%s)", string, n2, n3);
    }

    public static void checkPositionIndexes(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < n2 || n3 > n4) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n2, n3, n4));
        }
    }

    private static String badPositionIndexes(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > n4) {
            return Preconditions.badPositionIndex(n2, n4, "start index");
        }
        if (n3 < 0 || n3 > n4) {
            return Preconditions.badPositionIndex(n3, n4, "end index");
        }
        return Preconditions.format("end index (%s) must not be less than start index (%s)", n3, n2);
    }

    static String format(@Nullable String string, Object ... objectArray) {
        int n2;
        string = String.valueOf(string);
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16 * objectArray.length);
        int n3 = 0;
        int n4 = 0;
        while (n4 < objectArray.length && (n2 = string.indexOf("%s", n3)) != -1) {
            stringBuilder.append(string.substring(n3, n2));
            stringBuilder.append(objectArray[n4++]);
            n3 = n2 + 2;
        }
        stringBuilder.append(string.substring(n3));
        if (n4 < objectArray.length) {
            stringBuilder.append(" [");
            stringBuilder.append(objectArray[n4++]);
            while (n4 < objectArray.length) {
                stringBuilder.append(", ");
                stringBuilder.append(objectArray[n4++]);
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }
}

