/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bdlocation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.GnssStatus;
import android.location.GpsSatellite;
import android.location.GpsStatus;
import android.location.LocationManager;
import android.os.Build;
import android.os.Handler;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.bytedance.bdlocation.BDLocation;
import com.bytedance.bdlocation.ILocate;
import com.bytedance.bdlocation.ILocateCallback;
import com.bytedance.bdlocation.LocationUtil;
import com.bytedance.bdlocation.Util;
import com.bytedance.bdlocation.client.BDLocationClient;
import com.bytedance.bdlocation.client.BDLocationConfig;
import com.bytedance.bdlocation.client.BDLocationException;
import com.bytedance.bdlocation.client.BDPoint;
import com.bytedance.bdlocation.client.LocationOption;
import com.bytedance.bdlocation.service.QPSController;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import g.optional.location.a;
import g.optional.location.ae;
import g.optional.location.af;
import g.optional.location.ah;
import g.optional.location.am;
import g.optional.location.an;
import g.optional.location.aq;
import g.optional.location.as;
import g.optional.location.at;
import g.optional.location.av;
import g.optional.location.aw;
import g.optional.location.ay;
import g.optional.location.be;
import g.optional.location.bf;
import g.optional.location.bx;
import g.optional.location.cb;
import g.optional.location.cf;
import g.optional.location.ci;
import g.optional.location.cj;
import g.optional.location.co;
import g.optional.location.d;
import g.optional.location.e;
import g.optional.location.q;
import g.optional.location.t;
import g.optional.location.v;
import g.optional.location.x;
import g.optional.location.y;
import g.optional.location.z;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONObject;

public abstract class BaseLocate
implements ILocate,
ILocateCallback,
d {
    protected QPSController mController;
    protected Context mContext;
    protected ILocateCallback mLocateCb;
    private GpsStatus mLegacyStatus;
    private GpsStatus.Listener mLegacyStatusListener;
    private GnssStatus mGnssStatus;
    private GnssStatus.Callback mGnssStatusListener;
    private int mSvCount;
    private float mSnrCn0UsedAvg = 0.0f;
    private float mSnrCn0Avg = 0.0f;
    private float mLastSnrCn0Avg = 0.0f;
    private int mSvUsedCount = 0;
    private int mLastSvUsedCount = 0;
    private int mSatStatusChangeNum = 0;
    private LocationManager mLocationManager;
    private Handler mGnssHandler;
    private List<av> mSatellites;

    public BaseLocate(Context context, QPSController qPSController) {
        this.mContext = context;
        this.mController = qPSController;
        this.mLocationManager = (LocationManager)context.getSystemService("location");
    }

    public final void geocodeAndCallback(@Nullable BDLocation bDLocation, LocationOption locationOption, @NonNull BDLocationClient.Callback callback) {
        block10: {
            if (bDLocation != null) {
                cj.c(this.getLocateName() + " onLocationChanged: " + bDLocation.toString());
            }
            this.mController.callback(bDLocation);
            try {
                if (!LocationUtil.isEmpty(bDLocation)) {
                    long l2 = System.currentTimeMillis();
                    BDLocation bDLocation2 = null;
                    if (this.needGeocode(bDLocation, locationOption) && this.isNeedAddress(locationOption) && !LocationUtil.isEmpty(bDLocation)) {
                        BDPoint bDPoint = new BDPoint(bDLocation.getLatitude(), bDLocation.getLongitude(), bDLocation.getProvider());
                        bDLocation2 = ay.a().a(bDPoint, "wgs", locationOption.geocodeMode());
                    }
                    long l3 = System.currentTimeMillis();
                    locationOption.getTrace().a(l3 - l2);
                    BDLocation bDLocation3 = bDLocation2 == null ? bDLocation : bDLocation2;
                    this.startLocateUpload(this.mContext, bDLocation3);
                    if (this.isNeedAddress(locationOption) && !Util.isByteLocation(bDLocation3)) {
                        try {
                            bDLocation2 = BaseLocate.getGeocodeResult(bDLocation3);
                        }
                        catch (Exception exception) {
                            cj.e("geocode error:" + exception.getLocalizedMessage());
                            q.a("bd_location_geocode_error", null, null);
                        }
                    }
                    if (bDLocation2 != null) {
                        this.onLocationChanged(callback, LocationUtil.composeGeocodeLocation(bDLocation, bDLocation2));
                    } else {
                        this.onLocationChanged(callback, bDLocation);
                    }
                    break block10;
                }
                this.onError(callback, new BDLocationException("SDK callback null!", this.getLocateName(), "26"));
            }
            catch (Exception exception) {
                cj.e(this.getLocateName(), "", exception);
                this.onError(callback, new BDLocationException(exception, this.getLocateName(), "24"));
            }
        }
    }

    private void startLocateUpload(Context context, BDLocation bDLocation) {
        if (BDLocationConfig.isUpload() && BDLocationConfig.isLocateUpload()) {
            bx.a().c().execute(() -> {
                try {
                    if (BDLocationConfig.isRestrictedModeOn()) {
                        BaseLocate.uploadDeviceStatus(context);
                    } else if (Util.isByteLocation(bDLocation) && !Util.isByteLocationGPS(bDLocation)) {
                        cj.b("Submit: bytelocation " + bDLocation.getLocationType() + " should not submit location");
                    } else {
                        BaseLocate.uploadLocInfo(context, bDLocation);
                    }
                }
                catch (Exception exception) {
                    cj.a(this.getLocateName(), exception);
                }
            });
        }
    }

    private boolean isNeedAddress(LocationOption locationOption) {
        return locationOption == null || locationOption.geocodeMode() != 0;
    }

    private void onError(BDLocationClient.Callback callback, BDLocationException bDLocationException) {
        callback.onError(bDLocationException);
    }

    private void onLocationChanged(BDLocationClient.Callback callback, BDLocation bDLocation) {
        callback.onLocationChanged(bDLocation);
        this.onLocateChange(this.getLocateName(), bDLocation);
    }

    public void setLocateCallback(ILocateCallback iLocateCallback) {
        this.mLocateCb = iLocateCallback;
    }

    @Override
    public void onLocateStart(String string) {
        if (this.mLocateCb != null) {
            this.mLocateCb.onLocateStart(string);
        }
    }

    @Override
    public void onLocateStop(String string) {
        if (this.mLocateCb != null) {
            this.mLocateCb.onLocateStop(string);
        }
    }

    @Override
    public void onLocateChange(String string, BDLocation bDLocation) {
        if (this.mLocateCb != null) {
            this.mLocateCb.onLocateChange(string, bDLocation);
        }
    }

    @Override
    public void onLocateError(String string, BDLocationException bDLocationException) {
        if (this.mLocateCb != null) {
            this.mLocateCb.onLocateError(string, bDLocationException);
        }
    }

    protected abstract boolean needGeocode(BDLocation var1, LocationOption var2);

    public static void uploadLocInfo(Context context, BDLocation bDLocation) throws Exception {
        Object object;
        if (!BDLocationConfig.isUploadLocation() && !BDLocationConfig.isUploadMccAndSystemRegionInfo()) {
            return;
        }
        if (!cf.a()) {
            cj.b("The collection of data is allowed after user confirmed the privacy!");
            return;
        }
        ae ae2 = null;
        if (BDLocationConfig.isUploadLocation()) {
            ae2 = new ae();
            object = null;
            if (bDLocation != null) {
                object = new BDLocation(bDLocation);
            }
            x x2 = BaseLocate.getBaseStation(context);
            JsonArray jsonArray = BaseLocate.getWifiInfo(context);
            ae2.c = x2;
            ae2.d = jsonArray;
            List<aq> list = null;
            List<v> list2 = null;
            am am2 = null;
            am am3 = null;
            if (object != null) {
                if (BDLocationConfig.isUploadPoi()) {
                    list = BaseLocate.getPois((BDLocation)((Object)object));
                }
                if (BDLocationConfig.isUploadAoi()) {
                    list2 = BaseLocate.getAois((BDLocation)((Object)object));
                }
                if (BDLocationConfig.isChineseChannel() && ((BDLocation)((Object)object)).getGCJ02() == null) {
                    BDPoint bDPoint = ay.a().a(new BDPoint(((BDLocation)((Object)object)).getLatitude(), ((BDLocation)((Object)object)).getLongitude(), object.getProvider()));
                    if (bDPoint == null) {
                        ((BDLocation)((Object)object)).setLatitude(0.0);
                        ((BDLocation)((Object)object)).setLongitude(0.0);
                    } else {
                        ((BDLocation)((Object)object)).setLatitude(bDPoint.getLatitude());
                        ((BDLocation)((Object)object)).setLongitude(bDPoint.getLongitude());
                    }
                }
                if ("Android".equals(((BDLocation)((Object)object)).getLocationSDKName())) {
                    am2 = BaseLocate.bdLocationToLocationInfo((BDLocation)((Object)object), BDLocationConfig.isUploadGPS());
                } else {
                    am3 = BaseLocate.bdLocationToLocationInfo((BDLocation)((Object)object), BDLocationConfig.isUploadGPS());
                }
                ae2.e = list;
                ae2.f = list2;
                ae2.a = am2;
                ae2.b = am3;
            }
        }
        object = BaseLocate.getDeviceStatus(context);
        t.a(ae2, (af)object);
    }

    public static boolean uploadDeviceStatus(Context context) {
        boolean bl2 = false;
        if (BDLocationConfig.isUploadMccAndSystemRegionInfo()) {
            try {
                bl2 = t.a(context);
            }
            catch (Exception exception) {
                cj.c("upload device status error");
            }
        }
        return bl2;
    }

    public static af getDeviceStatus(Context context) {
        af af2 = null;
        if (BDLocationConfig.isUploadMccAndSystemRegionInfo()) {
            af2 = new af();
            af2.a = 2;
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String string = null;
            if (telephonyManager.getSimState() == 5) {
                string = telephonyManager.getSimOperator();
            }
            af2.b = string;
            Locale locale = BDLocationConfig.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            af2.d = locale.getLanguage();
            af2.c = locale.getCountry();
            af2.e = locale.toString();
            af2.f = Util.checkLocationPermissions(context);
            af2.g = BDLocationConfig.getRestrictedMode();
            af2.i = BDLocationConfig.isStrictRestrictedMode();
            af2.h = Util.getLocationMode(context);
        }
        return af2;
    }

    @Nullable
    public static x getBaseStation(Context context) {
        x x2 = null;
        try {
            if (BDLocationConfig.isUploadBaseSite()) {
                x2 = new cb(context).a();
            }
        }
        catch (Exception exception) {
            cj.a("", exception);
        }
        return x2;
    }

    public static JsonArray getWifiInfoByDetail(Context context) throws Exception {
        List<as> list = co.d(context);
        if (list == null) {
            return null;
        }
        Gson gson = new Gson();
        JsonElement jsonElement = gson.toJsonTree(list, new TypeToken<List<as>>(){}.getType());
        if (!jsonElement.isJsonArray()) {
            return null;
        }
        return jsonElement.getAsJsonArray();
    }

    private static ah bdLocationToGpsInfo(BDLocation bDLocation, boolean bl2) {
        if (bDLocation == null) {
            return null;
        }
        ah ah2 = new ah();
        ah2.a = bDLocation.getCountry();
        ah2.d = bDLocation.getDistrict();
        ah2.b = bDLocation.getAdministrativeArea();
        ah2.c = bDLocation.getCity();
        ah2.e = bDLocation.getAddress();
        if (bl2) {
            ah2.g = bDLocation.getLatitude();
            ah2.f = bDLocation.getLongitude();
        }
        ah2.h = bDLocation.getTime() / 1000L;
        ah2.i = bDLocation.getLocationType();
        ah2.j = bDLocation.getLocationSDKName();
        return ah2;
    }

    private static am bdLocationToLocationInfo(BDLocation bDLocation, boolean bl2) {
        if (bDLocation == null) {
            return null;
        }
        am am2 = new am();
        am2.a = bDLocation.getCountry();
        am2.d = bDLocation.getDistrict();
        am2.b = bDLocation.getAdministrativeArea();
        am2.c = bDLocation.getCity();
        am2.e = bDLocation.getAddress();
        if (bl2) {
            am2.g = bDLocation.getLatitude();
            am2.f = bDLocation.getLongitude();
        }
        am2.n = bDLocation.getTime() / 1000L;
        am2.m = bDLocation.getLocationType();
        am2.k = bDLocation.getLocationSDKName();
        am2.h = bDLocation.getAltitude();
        am2.i = bDLocation.getAccuracy();
        am2.l = bDLocation.getCoordinateSystem();
        if (Build.VERSION.SDK_INT >= 26) {
            am2.j = bDLocation.getVerticalAccuracyMeters();
        }
        return am2;
    }

    @Nullable
    private static List<aq> getPois(BDLocation bDLocation) {
        List<aq> list = bDLocation.getGCJ02() != null ? ay.a().a(bDLocation.getGCJ02(), "gcj") : ay.a().a(new BDPoint(bDLocation.getLatitude(), bDLocation.getLongitude(), bDLocation.getProvider()), "wgs");
        if (list != null && list.size() > BDLocationConfig.getPoiNum()) {
            list = list.subList(0, BDLocationConfig.getPoiNum() - 1);
        }
        return list;
    }

    @Nullable
    private static List<v> getAois(BDLocation bDLocation) {
        List<v> list = bDLocation.getGCJ02() != null ? ay.a().b(bDLocation.getGCJ02(), "gcj") : ay.a().b(new BDPoint(bDLocation.getLatitude(), bDLocation.getLongitude(), bDLocation.getProvider()), "wgs");
        if (list != null && list.size() > BDLocationConfig.getPoiNum()) {
            list = list.subList(0, BDLocationConfig.getPoiNum() - 1);
        }
        return list;
    }

    public static y getGisResult(double d2, double d3) throws Exception {
        String string = t.a(d2, d3);
        y y2 = (y)Util.sGson.fromJson(string, y.class);
        cj.c("GisResult:" + y2);
        return y2;
    }

    public static z getLocateResult() throws Exception {
        String string = t.a();
        JSONObject jSONObject = new JSONObject(string);
        String string2 = jSONObject.getString("data");
        z z2 = null;
        z2 = (z)Util.sGson.fromJson(t.a(string2), z.class);
        if (z2 != null) {
            int n2;
            if (z2.f != null && (n2 = z2.f.b) == 202) {
                throw new BDLocationException("Disputed area", "Unknown", "38");
            }
            if (!BDLocationConfig.isRestrictedModeOn()) {
                ay.a().d().a(z2);
            }
            cj.b(Util.sGson.toJson((Object)z2));
        }
        return z2;
    }

    public static BDLocation getGeocodeResult(BDLocation bDLocation) throws Exception {
        Object object;
        long l2 = System.currentTimeMillis();
        ah ah2 = null;
        ah ah3 = null;
        if (bDLocation != null) {
            if (BDLocationConfig.isChineseChannel() && bDLocation.getGCJ02() == null) {
                object = ay.a().a(new BDPoint(bDLocation.getLatitude(), bDLocation.getLongitude(), bDLocation.getProvider()));
                if (object == null) {
                    bDLocation.setLatitude(0.0);
                    bDLocation.setLongitude(0.0);
                } else {
                    bDLocation.setLatitude(((BDPoint)object).getLatitude());
                    bDLocation.setLongitude(((BDPoint)object).getLongitude());
                }
            }
            if ("Android".equals(bDLocation.getLocationSDKName())) {
                ah2 = BaseLocate.bdLocationToGpsInfo(bDLocation, BDLocationConfig.isUploadGPS());
            } else {
                ah3 = BaseLocate.bdLocationToGpsInfo(bDLocation, BDLocationConfig.isUploadGPS());
            }
        }
        if ((object = BDLocationConfig.getLocale()) == null) {
            object = Locale.getDefault();
        }
        String string = Util.languageTag((Locale)object);
        String string2 = BDLocationConfig.getWorldView();
        String string3 = t.a(ah2, ah3, string, string2);
        JSONObject jSONObject = new JSONObject(string3);
        String string4 = jSONObject.getString("data");
        an an2 = null;
        an2 = (an)Util.sGson.fromJson(t.a(string4), an.class);
        if (an2 != null) {
            bDLocation = LocationUtil.locationResultToBDLocation(bDLocation, an2);
        }
        cj.b(Util.sGson.toJson((Object)bDLocation));
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("get_geocode_result_cost", System.currentTimeMillis() - l2);
        q.a("bd_location_sdk_locate", jSONObject2, null);
        return bDLocation;
    }

    public static BDLocation getDownGradeLocation(LocationOption locationOption) {
        BDLocation bDLocation = null;
        try {
            be be2 = ay.a().d();
            bf bf2 = be2.a();
            if (bf2 == null) {
                return null;
            }
            bDLocation = bf2.c;
            if (bDLocation != null) {
                long l2 = bDLocation.getLocationMs();
                if (System.currentTimeMillis() - l2 < locationOption.getMaxCacheTimeForLocateFail()) {
                    bDLocation.setLocationType(5);
                }
            } else {
                bDLocation = BaseLocate.getGeocodeResult(null);
            }
            return bDLocation;
        }
        catch (Exception exception) {
            cj.c("cache or ip locate error:" + exception.getLocalizedMessage());
            return bDLocation;
        }
    }

    @Nullable
    private static JsonArray getWifiInfo(Context context) {
        JsonArray jsonArray = null;
        try {
            if (BDLocationConfig.isUploadWIFI()) {
                jsonArray = BaseLocate.getWifiInfoByDetail(context);
            }
        }
        catch (Exception exception) {
            cj.a("", exception);
        }
        return jsonArray;
    }

    @Override
    public void gnssHandler() {
        if (this.mGnssHandler == null) {
            return;
        }
        try {
            this.mGnssHandler.postDelayed(() -> {
                this.removeStatusListener();
                if (this.mLastSvUsedCount <= a.a().b() && this.mLastSnrCn0Avg <= (float)a.a().c() && a.a().h()) {
                    this.stopLocation();
                    cj.c("GNSS:current position is indoor. Signal Strength:" + this.mLastSnrCn0Avg + " used in fix num:" + this.mLastSvUsedCount + "\n");
                } else {
                    cj.c("GNSS:current position is outdoor. Signal Strength:" + this.mLastSnrCn0Avg + " used in fix num:" + this.mLastSvUsedCount + "\n");
                }
                aw aw2 = new aw();
                aw2.a = this.mSatellites;
                aw2.b = this.mLastSnrCn0Avg;
                aw2.c = this.mLastSvUsedCount;
                aw2.d = this.mSatStatusChangeNum;
                at at2 = new at();
                at2.a = aw2;
                be be2 = ay.a().d();
                int n2 = be2.i();
                if (this.mSatStatusChangeNum >= a.a().i() && n2 < a.a().e()) {
                    t.a(at2);
                    be2.d(++n2);
                }
            }, a.a().d());
        }
        catch (Exception exception) {
            cj.a("GNSS:gnss indoor outdoor error", exception);
        }
    }

    @Override
    public void addStatusListener() {
        try {
            cj.c("GNSS:addStatusListener");
            this.mSatellites = new ArrayList<av>();
            this.mSatStatusChangeNum = 0;
            a a2 = a.a();
            if (!a2.g() || !this.isGnssSpecialModel()) {
                cj.c("GNSS: monitor is not enabled");
                return;
            }
            if (e.a()) {
                this.addGnssStatusListener();
            } else {
                this.addLegacyStatusListener();
            }
            this.mGnssHandler = new Handler(ci.a());
            this.gnssHandler();
        }
        catch (Exception exception) {
            cj.a("GNSS:addStatusListener error", exception);
        }
    }

    private boolean isGnssSpecialModel() {
        String string = a.a().f();
        if (string == null || TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string2 = Util.getDeviceName();
        return !TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) && string.toLowerCase().contains(string2.toLowerCase());
    }

    @Override
    public void removeStatusListener() {
        try {
            cj.c("GNSS:removeStatusListener");
            if (this.mGnssHandler != null) {
                this.mGnssHandler.removeCallbacksAndMessages(null);
                this.mGnssHandler = null;
            }
            if (e.a()) {
                this.removeGnssStatusListener();
            } else {
                this.removeLegacyStatusListener();
            }
        }
        catch (Exception exception) {
            cj.a("GNSS:removeStatusListener error", exception);
        }
    }

    @Override
    public void updateLegacyStatus(GpsStatus gpsStatus) {
        Iterator iterator = gpsStatus.getSatellites().iterator();
        this.mSvCount = 0;
        int n2 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        this.mSvUsedCount = 0;
        this.mSnrCn0Avg = 0.0f;
        this.mSnrCn0UsedAvg = 0.0f;
        long l2 = Util.getCurrentTimeSeconds();
        while (iterator.hasNext()) {
            GpsSatellite gpsSatellite = (GpsSatellite)iterator.next();
            if (e.b(gpsSatellite.getPrn())) {
                if (gpsSatellite.getSnr() != 0.0f) {
                    ++n2;
                    f2 += gpsSatellite.getSnr();
                }
                if (gpsSatellite.usedInFix()) {
                    ++this.mSvUsedCount;
                    f3 += gpsSatellite.getSnr();
                }
            }
            cj.c("GNSS:GPSStatus index:" + this.mSvCount + " GnssConstellationType:" + (Object)((Object)e.c(gpsSatellite.getPrn())) + " usedInFix:" + gpsSatellite.usedInFix() + " Cn0DbHz:" + gpsSatellite.getSnr());
            av av2 = new av();
            av2.a = e.c(gpsSatellite.getPrn()).toString();
            av2.b = gpsSatellite.getSnr();
            av2.c = gpsSatellite.usedInFix();
            av2.d = l2;
            this.mSatellites.add(av2);
            ++this.mSvCount;
        }
        if (n2 > 0) {
            this.mSnrCn0Avg = f2 / (float)n2;
        }
        if (this.mSvUsedCount > 0) {
            this.mSnrCn0UsedAvg = f3 / (float)this.mSvUsedCount;
        }
        ++this.mSatStatusChangeNum;
        this.mLastSnrCn0Avg = this.mSnrCn0Avg;
        this.mLastSvUsedCount = this.mSvUsedCount;
        cj.c("GNSS:GPSStatus mSnrCn0Avg:" + this.mSnrCn0Avg + " mSnrCn0UsedAvg:" + this.mSnrCn0UsedAvg + " cn0Sum:" + f2 + " cn0UsedSum:" + f3 + " svCount:" + n2 + " svUsedCount:" + this.mSvUsedCount);
    }

    @Override
    @RequiresApi(api=24)
    public void updateGnssStatus(GnssStatus gnssStatus) {
        int n2 = gnssStatus.getSatelliteCount();
        this.mSvCount = 0;
        int n3 = 0;
        this.mSvUsedCount = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        this.mSnrCn0Avg = 0.0f;
        this.mSnrCn0UsedAvg = 0.0f;
        long l2 = Util.getCurrentTimeSeconds();
        while (this.mSvCount < n2) {
            if (e.a(gnssStatus.getConstellationType(this.mSvCount))) {
                if ((double)gnssStatus.getCn0DbHz(this.mSvCount) != 0.0) {
                    ++n3;
                    f2 = f3 + gnssStatus.getCn0DbHz(this.mSvCount);
                }
                if (gnssStatus.usedInFix(this.mSvCount)) {
                    ++this.mSvUsedCount;
                    f3 += gnssStatus.getCn0DbHz(this.mSvCount);
                }
            }
            cj.b("GNSS:GNSStatus index:" + this.mSvCount + " GnssConstellationType:" + (Object)((Object)e.d(gnssStatus.getConstellationType(this.mSvCount))) + " usedInFix:" + gnssStatus.usedInFix(this.mSvCount) + " Cn0DbHz:" + gnssStatus.getCn0DbHz(this.mSvCount));
            av av2 = new av();
            av2.a = e.d(gnssStatus.getConstellationType(this.mSvCount)).name();
            av2.b = gnssStatus.getCn0DbHz(this.mSvCount);
            av2.c = gnssStatus.usedInFix(this.mSvCount);
            av2.d = l2;
            this.mSatellites.add(av2);
            ++this.mSvCount;
        }
        if (n3 > 0) {
            this.mSnrCn0Avg = f2 / (float)n3;
        }
        if (this.mSvUsedCount > 0) {
            this.mSnrCn0UsedAvg = f3 / (float)this.mSvUsedCount;
        }
        ++this.mSatStatusChangeNum;
        this.mLastSnrCn0Avg = this.mSnrCn0Avg;
        this.mLastSvUsedCount = this.mSvUsedCount;
        cj.b("GNSS:GNSStatus mSnrCn0Avg:" + this.mSnrCn0Avg + " mSnrCn0UsedAvg:" + this.mSnrCn0UsedAvg + " cn0Sum:" + f2 + " cn0UsedSum:" + f3 + " svCount:" + n3 + " svUsedCount:" + this.mSvUsedCount);
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void addLegacyStatusListener() {
        this.mLegacyStatusListener = new GpsStatus.Listener(){

            public void onGpsStatusChanged(int n2) {
                BaseLocate.this.mLegacyStatus = BaseLocate.this.mLocationManager.getGpsStatus(BaseLocate.this.mLegacyStatus);
                switch (n2) {
                    case 1: {
                        cj.c("GNSS:GpsStatus.Listener GPS_EVENT_STARTED");
                        break;
                    }
                    case 2: {
                        cj.c("GNSS:GpsStatus.Listener GPS_EVENT_STOPPED");
                        break;
                    }
                    case 3: {
                        cj.c("GNSS:GpsStatus.Listener GPS_EVENT_FIRST_FIX");
                        break;
                    }
                    case 4: {
                        cj.c("GNSS:GpsStatus.Listener GPS_EVENT_SATELLITE_STATUS");
                        BaseLocate.this.updateLegacyStatus(BaseLocate.this.mLegacyStatus);
                    }
                }
            }
        };
        this.mLocationManager.addGpsStatusListener(this.mLegacyStatusListener);
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(api=24)
    public void addGnssStatusListener() {
        this.mGnssStatusListener = new GnssStatus.Callback(){

            public void onStarted() {
                super.onStarted();
                cj.c("GNSS:GnssStatus.Callback onStarted");
            }

            public void onStopped() {
                super.onStopped();
                cj.c("GNSS:GnssStatus.Callback onStopped");
            }

            public void onFirstFix(int n2) {
                super.onFirstFix(n2);
                cj.c("GNSS:GnssStatus.Callback onFirstFix");
            }

            public void onSatelliteStatusChanged(GnssStatus gnssStatus) {
                super.onSatelliteStatusChanged(gnssStatus);
                cj.c("GNSS:GnssStatus.Callback onSatelliteStatusChanged");
                BaseLocate.this.updateGnssStatus(gnssStatus);
            }
        };
        this.mLocationManager.registerGnssStatusCallback(this.mGnssStatusListener);
    }

    @Override
    @RequiresApi(api=24)
    public void removeGnssStatusListener() {
        if (this.mLocationManager != null && this.mGnssStatusListener != null) {
            this.mLocationManager.unregisterGnssStatusCallback(this.mGnssStatusListener);
        }
    }

    @Override
    public void removeLegacyStatusListener() {
        if (this.mLocationManager != null && this.mLegacyStatusListener != null) {
            this.mLocationManager.removeGpsStatusListener(this.mLegacyStatusListener);
        }
    }
}

