/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.AppWithState;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.DeviceWithState;
import com.bugsnag.android.Error;
import com.bugsnag.android.ErrorType;
import com.bugsnag.android.EventInternal;
import com.bugsnag.android.FeatureFlag;
import com.bugsnag.android.FeatureFlagAware;
import com.bugsnag.android.FeatureFlags;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Metadata;
import com.bugsnag.android.MetadataAware;
import com.bugsnag.android.Session;
import com.bugsnag.android.Severity;
import com.bugsnag.android.SeverityReason;
import com.bugsnag.android.Thread;
import com.bugsnag.android.TraceCorrelation;
import com.bugsnag.android.User;
import com.bugsnag.android.UserAware;
import com.bugsnag.android.internal.ImmutableConfig;
import com.bugsnag.android.internal.InternalMetrics;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public class Event
implements JsonStream.Streamable,
MetadataAware,
UserAware,
FeatureFlagAware {
    private final EventInternal impl;
    private final Logger logger;

    Event(@Nullable Throwable originalError, @NonNull ImmutableConfig config, @NonNull SeverityReason severityReason, @NonNull Logger logger) {
        this(originalError, config, severityReason, new Metadata(), new FeatureFlags(), logger);
    }

    Event(@Nullable Throwable originalError, @NonNull ImmutableConfig config, @NonNull SeverityReason severityReason, @NonNull Metadata metadata, @NonNull FeatureFlags featureFlags, @NonNull Logger logger) {
        this(new EventInternal(originalError, config, severityReason, metadata, featureFlags), logger);
    }

    Event(@NonNull EventInternal impl, @NonNull Logger logger) {
        this.impl = impl;
        this.logger = logger;
    }

    private void logNull(String property) {
        this.logger.e("Invalid null value supplied to config." + property + ", ignoring");
    }

    @Nullable
    public Throwable getOriginalError() {
        return this.impl.getOriginalError();
    }

    @NonNull
    public List<Error> getErrors() {
        return this.impl.getErrors();
    }

    @NonNull
    public Error addError(@NonNull Throwable error) {
        return this.impl.addError(error);
    }

    @NonNull
    public Error addError(@NonNull String errorClass, @Nullable String errorMessage) {
        return this.impl.addError(errorClass, errorMessage, ErrorType.ANDROID);
    }

    @NonNull
    public Error addError(@NonNull String errorClass, @Nullable String errorMessage, @NonNull ErrorType errorType) {
        return this.impl.addError(errorClass, errorMessage, errorType);
    }

    @NonNull
    public List<Thread> getThreads() {
        return this.impl.getThreads();
    }

    @NonNull
    public Thread addThread(@NonNull String id, @NonNull String name) {
        return this.impl.addThread(id, name, ErrorType.ANDROID, false, Thread.State.RUNNABLE.getDescriptor());
    }

    @NonNull
    public Thread addThread(long id, @NonNull String name) {
        return this.impl.addThread(Long.toString(id), name, ErrorType.ANDROID, false, Thread.State.RUNNABLE.getDescriptor());
    }

    @NonNull
    public List<Breadcrumb> getBreadcrumbs() {
        return this.impl.getBreadcrumbs();
    }

    @NonNull
    public Breadcrumb leaveBreadcrumb(@NonNull String message, @NonNull BreadcrumbType type, @Nullable Map<String, Object> metadata) {
        return this.impl.leaveBreadcrumb(message, type, metadata);
    }

    @NonNull
    public Breadcrumb leaveBreadcrumb(@NonNull String message) {
        return this.impl.leaveBreadcrumb(message, BreadcrumbType.MANUAL, null);
    }

    @NonNull
    public List<FeatureFlag> getFeatureFlags() {
        return this.impl.getFeatureFlags().toList();
    }

    @NonNull
    public AppWithState getApp() {
        return this.impl.getApp();
    }

    @NonNull
    public DeviceWithState getDevice() {
        return this.impl.getDevice();
    }

    public void setApiKey(@NonNull String apiKey) {
        if (apiKey != null) {
            this.impl.setApiKey(apiKey);
        } else {
            this.logNull("apiKey");
        }
    }

    @NonNull
    public String getApiKey() {
        return this.impl.getApiKey();
    }

    public void setSeverity(@NonNull Severity severity) {
        if (severity != null) {
            this.impl.setSeverity(severity);
        } else {
            this.logNull("severity");
        }
    }

    @NonNull
    public Severity getSeverity() {
        return this.impl.getSeverity();
    }

    public void setGroupingHash(@Nullable String groupingHash) {
        this.impl.setGroupingHash(groupingHash);
    }

    @Nullable
    public String getGroupingHash() {
        return this.impl.getGroupingHash();
    }

    public void setContext(@Nullable String context) {
        this.impl.setContext(context);
    }

    @Nullable
    public String getContext() {
        return this.impl.getContext();
    }

    @Nullable
    public String setGroupingDiscriminator(@Nullable String groupingDiscriminator) {
        String previousGroupingDiscriminator = this.impl.getGroupingDiscriminator();
        this.impl.setGroupingDiscriminator(groupingDiscriminator);
        return previousGroupingDiscriminator;
    }

    @Nullable
    public String getGroupingDiscriminator() {
        return this.impl.getGroupingDiscriminator();
    }

    @Override
    public void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        this.impl.setUser(id, email, name);
    }

    @Override
    @NonNull
    public User getUser() {
        return this.impl.getUser();
    }

    public void addMetadata(@NonNull String section, @NonNull Map<String, ?> value) {
        if (section != null && value != null) {
            this.impl.addMetadata(section, value);
        } else {
            this.logNull("addMetadata");
        }
    }

    @Override
    public void addMetadata(@NonNull String section, @NonNull String key, @Nullable Object value) {
        if (section != null && key != null) {
            this.impl.addMetadata(section, key, value);
        } else {
            this.logNull("addMetadata");
        }
    }

    @Override
    public void clearMetadata(@NonNull String section) {
        if (section != null) {
            this.impl.clearMetadata(section);
        } else {
            this.logNull("clearMetadata");
        }
    }

    @Override
    public void clearMetadata(@NonNull String section, @NonNull String key) {
        if (section != null && key != null) {
            this.impl.clearMetadata(section, key);
        } else {
            this.logNull("clearMetadata");
        }
    }

    @Override
    @Nullable
    public Map<String, Object> getMetadata(@NonNull String section) {
        if (section != null) {
            return this.impl.getMetadata(section);
        }
        this.logNull("getMetadata");
        return null;
    }

    @Override
    @Nullable
    public Object getMetadata(@NonNull String section, @NonNull String key) {
        if (section != null && key != null) {
            return this.impl.getMetadata(section, key);
        }
        this.logNull("getMetadata");
        return null;
    }

    @Override
    public void addFeatureFlag(@NonNull String name) {
        if (name != null) {
            this.impl.addFeatureFlag(name);
        } else {
            this.logNull("addFeatureFlag");
        }
    }

    @Override
    public void addFeatureFlag(@NonNull String name, @Nullable String variant) {
        if (name != null) {
            this.impl.addFeatureFlag(name, variant);
        } else {
            this.logNull("addFeatureFlag");
        }
    }

    @Override
    public void addFeatureFlags(@NonNull Iterable<FeatureFlag> featureFlags) {
        if (featureFlags != null) {
            this.impl.addFeatureFlags(featureFlags);
        } else {
            this.logNull("addFeatureFlags");
        }
    }

    @Override
    public void clearFeatureFlag(@NonNull String name) {
        if (name != null) {
            this.impl.clearFeatureFlag(name);
        } else {
            this.logNull("clearFeatureFlag");
        }
    }

    @Override
    public void clearFeatureFlags() {
        this.impl.clearFeatureFlags();
    }

    @Override
    public void toStream(@NonNull JsonStream stream) throws IOException {
        this.impl.toStream(stream);
    }

    public boolean isUnhandled() {
        return this.impl.getUnhandled();
    }

    public void setUnhandled(boolean unhandled) {
        this.impl.setUnhandled(unhandled);
    }

    public void setTraceCorrelation(@NonNull UUID traceId, long spanId) {
        if (traceId != null) {
            this.impl.setTraceCorrelation(new TraceCorrelation(traceId, spanId));
        } else {
            this.logNull("traceId");
        }
    }

    protected boolean shouldDiscardClass() {
        return this.impl.shouldDiscardClass();
    }

    protected void updateSeverityInternal(@NonNull Severity severity) {
        this.impl.updateSeverityInternal(severity);
    }

    protected void updateSeverityReason(@NonNull String reason) {
        this.impl.updateSeverityReason(reason);
    }

    void setApp(@NonNull AppWithState app) {
        this.impl.setApp(app);
    }

    void setDevice(@NonNull DeviceWithState device) {
        this.impl.setDevice(device);
    }

    void setBreadcrumbs(@NonNull List<Breadcrumb> breadcrumbs) {
        this.impl.setBreadcrumbs(breadcrumbs);
    }

    @Nullable
    Session getSession() {
        return this.impl.session;
    }

    void setSession(@Nullable Session session) {
        this.impl.session = session;
    }

    EventInternal getImpl() {
        return this.impl;
    }

    void setRedactedKeys(Collection<Pattern> redactedKeys) {
        this.impl.setRedactedKeys(redactedKeys);
    }

    void setInternalMetrics(InternalMetrics metrics) {
        this.impl.setInternalMetrics(metrics);
    }
}

