/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.internal;

import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.internal.BackgroundTaskServiceKt;
import com.bugsnag.android.internal.TaskType;
import com.bugsnag.android.internal.dag.RunnableProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001!B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J-\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0004\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0018H\u0086\bJ\u0006\u0010\u0019\u001a\u00020\u0010J\u001a\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0014J(\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001b\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fJ\f\u0010 \u001a\u00020\u0010*\u00020\u0003H\u0002R\u0016\u0010\u0007\u001a\u00020\u00038\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0002\u001a\u00020\u00038\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\u0006\u001a\u00020\u00038\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0016\u0010\u0005\u001a\u00020\u00038\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0016\u0010\u0004\u001a\u00020\u00038\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\""}, d2={"Lcom/bugsnag/android/internal/BackgroundTaskService;", "", "errorExecutor", "Ljava/util/concurrent/ExecutorService;", "sessionExecutor", "ioExecutor", "internalReportExecutor", "defaultExecutor", "(Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ExecutorService;)V", "getDefaultExecutor$bugsnag_android_core_release", "()Ljava/util/concurrent/ExecutorService;", "getErrorExecutor$bugsnag_android_core_release", "getInternalReportExecutor$bugsnag_android_core_release", "getIoExecutor$bugsnag_android_core_release", "getSessionExecutor$bugsnag_android_core_release", "execute", "", "taskType", "Lcom/bugsnag/android/internal/TaskType;", "task", "Ljava/lang/Runnable;", "provider", "Lcom/bugsnag/android/internal/dag/RunnableProvider;", "R", "Lkotlin/Function0;", "shutdown", "submitTask", "Ljava/util/concurrent/Future;", "runnable", "T", "callable", "Ljava/util/concurrent/Callable;", "awaitTerminationSafe", "SafeFuture", "bugsnag-android-core_release"})
public final class BackgroundTaskService {
    @NotNull
    private final ExecutorService errorExecutor;
    @NotNull
    private final ExecutorService sessionExecutor;
    @NotNull
    private final ExecutorService ioExecutor;
    @NotNull
    private final ExecutorService internalReportExecutor;
    @NotNull
    private final ExecutorService defaultExecutor;

    public BackgroundTaskService(@NotNull ExecutorService errorExecutor, @NotNull ExecutorService sessionExecutor, @NotNull ExecutorService ioExecutor, @NotNull ExecutorService internalReportExecutor, @NotNull ExecutorService defaultExecutor) {
        this.errorExecutor = errorExecutor;
        this.sessionExecutor = sessionExecutor;
        this.ioExecutor = ioExecutor;
        this.internalReportExecutor = internalReportExecutor;
        this.defaultExecutor = defaultExecutor;
    }

    public /* synthetic */ BackgroundTaskService(ExecutorService executorService, ExecutorService executorService2, ExecutorService executorService3, ExecutorService executorService4, ExecutorService executorService5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            executorService = BackgroundTaskServiceKt.createExecutor("Bugsnag Error thread", TaskType.ERROR_REQUEST, true);
        }
        if ((n & 2) != 0) {
            executorService2 = BackgroundTaskServiceKt.createExecutor("Bugsnag Session thread", TaskType.SESSION_REQUEST, true);
        }
        if ((n & 4) != 0) {
            executorService3 = BackgroundTaskServiceKt.createExecutor("Bugsnag IO thread", TaskType.IO, true);
        }
        if ((n & 8) != 0) {
            executorService4 = BackgroundTaskServiceKt.createExecutor("Bugsnag Internal Report thread", TaskType.INTERNAL_REPORT, false);
        }
        if ((n & 0x10) != 0) {
            executorService5 = BackgroundTaskServiceKt.createExecutor("Bugsnag Default thread", TaskType.DEFAULT, false);
        }
        this(executorService, executorService2, executorService3, executorService4, executorService5);
    }

    @VisibleForTesting
    @NotNull
    public final ExecutorService getErrorExecutor$bugsnag_android_core_release() {
        return this.errorExecutor;
    }

    @VisibleForTesting
    @NotNull
    public final ExecutorService getSessionExecutor$bugsnag_android_core_release() {
        return this.sessionExecutor;
    }

    @VisibleForTesting
    @NotNull
    public final ExecutorService getIoExecutor$bugsnag_android_core_release() {
        return this.ioExecutor;
    }

    @VisibleForTesting
    @NotNull
    public final ExecutorService getInternalReportExecutor$bugsnag_android_core_release() {
        return this.internalReportExecutor;
    }

    @VisibleForTesting
    @NotNull
    public final ExecutorService getDefaultExecutor$bugsnag_android_core_release() {
        return this.defaultExecutor;
    }

    @NotNull
    public final Future<?> submitTask(@NotNull TaskType taskType, @NotNull Runnable runnable) throws RejectedExecutionException {
        return this.submitTask(taskType, Executors.callable(runnable));
    }

    @NotNull
    public final <T> Future<T> submitTask(@NotNull TaskType taskType, @NotNull Callable<T> callable) throws RejectedExecutionException {
        FutureTask<T> task2 = new FutureTask<T>(callable);
        this.execute(taskType, task2);
        return new SafeFuture<T>(task2, taskType);
    }

    public final void execute(@NotNull TaskType taskType, @NotNull Runnable task2) {
        switch (WhenMappings.$EnumSwitchMapping$0[taskType.ordinal()]) {
            case 1: {
                this.errorExecutor.execute(task2);
                break;
            }
            case 2: {
                this.sessionExecutor.execute(task2);
                break;
            }
            case 3: {
                this.ioExecutor.execute(task2);
                break;
            }
            case 4: {
                this.internalReportExecutor.execute(task2);
                break;
            }
            case 5: {
                this.defaultExecutor.execute(task2);
            }
        }
    }

    public final void shutdown() {
        this.internalReportExecutor.shutdownNow();
        this.defaultExecutor.shutdownNow();
        this.errorExecutor.shutdown();
        this.sessionExecutor.shutdown();
        this.ioExecutor.shutdown();
        this.awaitTerminationSafe(this.errorExecutor);
        this.awaitTerminationSafe(this.sessionExecutor);
        this.awaitTerminationSafe(this.ioExecutor);
    }

    @NotNull
    public final <R> RunnableProvider<R> provider(@NotNull TaskType taskType, @NotNull Function0<? extends R> provider2) {
        boolean $i$f$provider = false;
        RunnableProvider task2 = new RunnableProvider<R>(provider2){
            final /* synthetic */ Function0<R> $provider;
            {
                this.$provider = $provider;
            }

            public R invoke() {
                return (R)this.$provider.invoke();
            }
        };
        this.execute(taskType, task2);
        return task2;
    }

    private final void awaitTerminationSafe(ExecutorService $this$awaitTerminationSafe) {
        try {
            $this$awaitTerminationSafe.awaitTermination(1500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public BackgroundTaskService() {
        this(null, null, null, null, null, 31, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0096\u0001J\b\u0010\u000b\u001a\u00020\fH\u0002J\r\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ \u0010\r\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\t\u0010\u0014\u001a\u00020\tH\u0096\u0001J\t\u0010\u0015\u001a\u00020\tH\u0096\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/bugsnag/android/internal/BackgroundTaskService$SafeFuture;", "V", "Ljava/util/concurrent/Future;", "delegate", "Ljava/util/concurrent/FutureTask;", "taskType", "Lcom/bugsnag/android/internal/TaskType;", "(Ljava/util/concurrent/FutureTask;Lcom/bugsnag/android/internal/TaskType;)V", "cancel", "", "p0", "ensureTaskGetSafe", "", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "isCancelled", "isDone", "bugsnag-android-core_release"})
    private static final class SafeFuture<V>
    implements Future<V> {
        @NotNull
        private final FutureTask<V> delegate;
        @NotNull
        private final TaskType taskType;

        public SafeFuture(@NotNull FutureTask<V> delegate, @NotNull TaskType taskType) {
            this.delegate = delegate;
            this.taskType = taskType;
        }

        @Override
        public boolean cancel(boolean p0) {
            return this.delegate.cancel(p0);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public V get() {
            this.ensureTaskGetSafe();
            return this.delegate.get();
        }

        @Override
        public V get(long timeout, @Nullable TimeUnit unit) {
            this.ensureTaskGetSafe();
            return this.delegate.get(timeout, unit);
        }

        private final void ensureTaskGetSafe() {
            if (!this.delegate.isDone() && BackgroundTaskServiceKt.getTaskType(Thread.currentThread()) == this.taskType) {
                this.delegate.run();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TaskType.values().length];
            nArray[TaskType.ERROR_REQUEST.ordinal()] = 1;
            nArray[TaskType.SESSION_REQUEST.ordinal()] = 2;
            nArray[TaskType.IO.ordinal()] = 3;
            nArray[TaskType.INTERNAL_REPORT.ordinal()] = 4;
            nArray[TaskType.DEFAULT.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

