/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.AppDataCollector;
import com.bugsnag.android.AppWithState;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Bugsnag;
import com.bugsnag.android.Client;
import com.bugsnag.android.DeviceDataCollector;
import com.bugsnag.android.DeviceWithState;
import com.bugsnag.android.Error;
import com.bugsnag.android.ErrorInternal;
import com.bugsnag.android.ErrorType;
import com.bugsnag.android.Event;
import com.bugsnag.android.EventInternal;
import com.bugsnag.android.EventStore;
import com.bugsnag.android.FeatureFlags;
import com.bugsnag.android.LastRunInfo;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Metadata;
import com.bugsnag.android.NativeStackframe;
import com.bugsnag.android.OnErrorCallback;
import com.bugsnag.android.Session;
import com.bugsnag.android.Severity;
import com.bugsnag.android.SeverityReason;
import com.bugsnag.android.Stackframe;
import com.bugsnag.android.Stacktrace;
import com.bugsnag.android.User;
import com.bugsnag.android.internal.ImmutableConfig;
import com.bugsnag.android.internal.JsonHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class NativeInterface {
    private static Charset UTF8Charset = Charset.defaultCharset();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Client client;

    @NonNull
    private static Client getClient() {
        if (client != null) {
            return client;
        }
        return Bugsnag.getClient();
    }

    @NonNull
    public static Event createEmptyEvent() {
        Client client = NativeInterface.getClient();
        return new Event(new EventInternal(null, client.getConfig(), SeverityReason.newInstance("handledException"), client.getMetadataState().getMetadata().copy()), client.getLogger());
    }

    public static void setClient(@NonNull Client client) {
        NativeInterface.client = client;
    }

    @Nullable
    public static String getContext() {
        return NativeInterface.getClient().getContext();
    }

    @NonNull
    public static File getNativeReportPath() {
        return NativeInterface.getNativeReportPath(NativeInterface.getPersistenceDirectory());
    }

    @NonNull
    private static File getNativeReportPath(@NonNull File persistenceDirectory) {
        return new File(persistenceDirectory, "bugsnag/native");
    }

    @NonNull
    private static File getPersistenceDirectory() {
        return (File)NativeInterface.getClient().getConfig().getPersistenceDirectory().getValue();
    }

    @NonNull
    public static Map<String, String> getUser() {
        HashMap<String, String> userData = new HashMap<String, String>();
        User user = NativeInterface.getClient().getUser();
        userData.put("id", user.getId());
        userData.put("name", user.getName());
        userData.put("email", user.getEmail());
        return userData;
    }

    @NonNull
    public static Map<String, Object> getApp() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        AppDataCollector source = NativeInterface.getClient().getAppDataCollector();
        AppWithState app = source.generateAppWithState();
        data.put("version", app.getVersion());
        data.put("releaseStage", app.getReleaseStage());
        data.put("id", app.getId());
        data.put("type", app.getType());
        data.put("buildUUID", app.getBuildUuid());
        data.put("duration", app.getDuration());
        data.put("durationInForeground", app.getDurationInForeground());
        data.put("versionCode", app.getVersionCode());
        data.put("inForeground", app.getInForeground());
        data.put("isLaunching", app.isLaunching());
        data.put("binaryArch", app.getBinaryArch());
        data.putAll(source.getAppDataMetadata());
        return data;
    }

    @NonNull
    public static Map<String, Object> getDevice() {
        DeviceDataCollector source = NativeInterface.getClient().getDeviceDataCollector();
        HashMap<String, Object> deviceData = new HashMap<String, Object>(source.getDeviceMetadata());
        DeviceWithState src = source.generateDeviceWithState(new Date().getTime());
        deviceData.put("freeDisk", src.getFreeDisk());
        deviceData.put("freeMemory", src.getFreeMemory());
        deviceData.put("orientation", src.getOrientation());
        deviceData.put("time", src.getTime());
        deviceData.put("cpuAbi", src.getCpuAbi());
        deviceData.put("jailbroken", src.getJailbroken());
        deviceData.put("id", src.getId());
        deviceData.put("locale", src.getLocale());
        deviceData.put("manufacturer", src.getManufacturer());
        deviceData.put("model", src.getModel());
        deviceData.put("osName", src.getOsName());
        deviceData.put("osVersion", src.getOsVersion());
        deviceData.put("runtimeVersions", src.getRuntimeVersions());
        deviceData.put("totalMemory", src.getTotalMemory());
        return deviceData;
    }

    @NonNull
    public static String[] getCpuAbi() {
        return NativeInterface.getClient().getDeviceDataCollector().getCpuAbi();
    }

    @NonNull
    public static Map<String, Object> getMetadata() {
        return NativeInterface.getClient().getMetadata();
    }

    @NonNull
    public static List<Breadcrumb> getBreadcrumbs() {
        return NativeInterface.getClient().getBreadcrumbs();
    }

    public static void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        Client client = NativeInterface.getClient();
        client.setUser(id, email, name);
    }

    public static void setUser(@Nullable byte[] idBytes, @Nullable byte[] emailBytes, @Nullable byte[] nameBytes) {
        String id = idBytes == null ? null : new String(idBytes, UTF8Charset);
        String email = emailBytes == null ? null : new String(emailBytes, UTF8Charset);
        String name = nameBytes == null ? null : new String(nameBytes, UTF8Charset);
        NativeInterface.setUser(id, email, name);
    }

    public static void leaveBreadcrumb(@NonNull String name, @NonNull BreadcrumbType type) {
        if (name == null) {
            return;
        }
        NativeInterface.getClient().leaveBreadcrumb(name, new HashMap<String, Object>(), type);
    }

    public static void leaveBreadcrumb(@NonNull byte[] nameBytes, @NonNull BreadcrumbType type) {
        if (nameBytes == null) {
            return;
        }
        String name = new String(nameBytes, UTF8Charset);
        NativeInterface.getClient().leaveBreadcrumb(name, new HashMap<String, Object>(), type);
    }

    public static void leaveBreadcrumb(@NonNull String message, @NonNull String type, @NonNull Map<String, Object> metadata) {
        String typeName = type.toUpperCase(Locale.US);
        NativeInterface.getClient().leaveBreadcrumb(message, metadata, BreadcrumbType.valueOf(typeName));
    }

    public static void clearMetadata(@NonNull String section, @Nullable String key) {
        if (key == null) {
            NativeInterface.getClient().clearMetadata(section);
        } else {
            NativeInterface.getClient().clearMetadata(section, key);
        }
    }

    public static void addMetadata(@NonNull String tab, @Nullable String key, @Nullable Object value) {
        NativeInterface.getClient().addMetadata(tab, key, value);
    }

    public static void addMetadata(@NonNull String tab, @NonNull Map<String, ?> metadata) {
        NativeInterface.getClient().addMetadata(tab, metadata);
    }

    @Nullable
    public static String getReleaseStage() {
        return NativeInterface.getClient().getConfig().getReleaseStage();
    }

    @NonNull
    public static String getSessionEndpoint() {
        return NativeInterface.getClient().getConfig().getEndpoints().getSessions();
    }

    @NonNull
    public static String getEndpoint() {
        return NativeInterface.getClient().getConfig().getEndpoints().getNotify();
    }

    public static void setContext(@Nullable String context) {
        NativeInterface.getClient().setContext(context);
    }

    public static void setBinaryArch(@NonNull String binaryArch) {
        NativeInterface.getClient().setBinaryArch(binaryArch);
    }

    @Nullable
    public static String getAppVersion() {
        return NativeInterface.getClient().getConfig().getAppVersion();
    }

    @Nullable
    public static Collection<String> getEnabledReleaseStages() {
        return NativeInterface.getClient().getConfig().getEnabledReleaseStages();
    }

    public static void registerSession(long startedAt, @Nullable String sessionId, int unhandledCount, int handledCount) {
        Client client = NativeInterface.getClient();
        User user = client.getUser();
        Date startDate = startedAt > 0L ? new Date(startedAt) : null;
        client.getSessionTracker().registerExistingSession(startDate, sessionId, user, unhandledCount, handledCount);
    }

    public static boolean isDiscardErrorClass(@NonNull String name) {
        Collection<Pattern> discardClasses = NativeInterface.getClient().getConfig().getDiscardClasses();
        if (discardClasses.isEmpty()) {
            return false;
        }
        for (Pattern pattern : discardClasses) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private static void deepMerge(Map<String, Object> src, Map<String, Object> dst) {
        for (Map.Entry<String, Object> entry : src.entrySet()) {
            String key = entry.getKey();
            Object srcValue = entry.getValue();
            Object dstValue = dst.get(key);
            if (srcValue instanceof Map && dstValue instanceof Map) {
                NativeInterface.deepMerge((Map)srcValue, (Map)dstValue);
                continue;
            }
            if (srcValue instanceof Collection && dstValue instanceof Collection) {
                ((Collection)dstValue).addAll((Collection)srcValue);
                continue;
            }
            dst.put(key, srcValue);
        }
    }

    public static void deliverReport(@Nullable byte[] releaseStageBytes, @NonNull byte[] payloadBytes, @Nullable byte[] staticDataBytes, @NonNull String apiKey, boolean isLaunching) {
        if (staticDataBytes != null) {
            Map<String, Object> payloadMap = JsonHelper.INSTANCE.deserialize(new ByteArrayInputStream(payloadBytes));
            Map<String, Object> staticDataMap = JsonHelper.INSTANCE.deserialize(new ByteArrayInputStream(staticDataBytes));
            NativeInterface.deepMerge(staticDataMap, payloadMap);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JsonHelper.INSTANCE.serialize(payloadMap, os);
            payloadBytes = os.toByteArray();
        }
        String payload = new String(payloadBytes, UTF8Charset);
        String releaseStage = releaseStageBytes == null ? null : new String(releaseStageBytes, UTF8Charset);
        Client client = NativeInterface.getClient();
        ImmutableConfig config = client.getConfig();
        if (releaseStage == null || releaseStage.length() == 0 || !config.shouldDiscardByReleaseStage()) {
            EventStore eventStore = client.getEventStore();
            String filename = eventStore.getNdkFilename(payload, apiKey);
            if (isLaunching) {
                filename = filename.replace(".json", "startupcrash.json");
            }
            eventStore.enqueueContentForDelivery(payload, filename);
        }
    }

    public static void deliverReport(@NonNull File reportFile) {
        EventStore eventStore = NativeInterface.getClient().eventStore;
        File eventFile = new File(eventStore.getStorageDir(), reportFile.getName());
        if (reportFile.renameTo(eventFile)) {
            eventStore.flushAsync();
        } else {
            reportFile.delete();
        }
    }

    public static void notify(@NonNull byte[] nameBytes, @NonNull byte[] messageBytes, @NonNull Severity severity, @NonNull StackTraceElement[] stacktrace) {
        if (nameBytes == null || messageBytes == null || stacktrace == null) {
            return;
        }
        String name = new String(nameBytes, UTF8Charset);
        String message = new String(messageBytes, UTF8Charset);
        NativeInterface.notify(name, message, severity, stacktrace);
    }

    public static void notify(final @NonNull String name, final @NonNull String message, final @NonNull Severity severity, @NonNull StackTraceElement[] stacktrace) {
        if (NativeInterface.getClient().getConfig().shouldDiscardError(name)) {
            return;
        }
        RuntimeException exc = new RuntimeException();
        exc.setStackTrace(stacktrace);
        NativeInterface.getClient().notify(exc, new OnErrorCallback(){

            @Override
            public boolean onError(@NonNull Event event) {
                event.updateSeverityInternal(severity);
                List<Error> errors = event.getErrors();
                Error error = event.getErrors().get(0);
                if (!errors.isEmpty()) {
                    error.setErrorClass(name);
                    error.setErrorMessage(message);
                    for (Error err : errors) {
                        err.setType(ErrorType.C);
                    }
                }
                return true;
            }
        });
    }

    public static void notify(@NonNull byte[] nameBytes, @NonNull byte[] messageBytes, @NonNull Severity severity, @NonNull NativeStackframe[] stacktrace) {
        if (nameBytes == null || messageBytes == null || stacktrace == null) {
            return;
        }
        String name = new String(nameBytes, UTF8Charset);
        String message = new String(messageBytes, UTF8Charset);
        NativeInterface.notify(name, message, severity, stacktrace);
    }

    public static void notify(@NonNull String name, @NonNull String message, @NonNull Severity severity, @NonNull NativeStackframe[] stacktrace) {
        Client client = NativeInterface.getClient();
        if (client.getConfig().shouldDiscardError(name)) {
            return;
        }
        Event event = NativeInterface.createEmptyEvent();
        event.updateSeverityInternal(severity);
        ArrayList<Stackframe> stackframes = new ArrayList<Stackframe>(stacktrace.length);
        for (NativeStackframe nativeStackframe : stacktrace) {
            stackframes.add(new Stackframe(nativeStackframe));
        }
        event.getErrors().add(new Error(new ErrorInternal(name, message, new Stacktrace(stackframes), ErrorType.C), client.getLogger()));
        NativeInterface.getClient().populateAndNotifyAndroidEvent(event, null);
    }

    @NonNull
    public static Event createEvent(@Nullable Throwable exc, @NonNull Client client, @NonNull SeverityReason severityReason) {
        Metadata metadata = client.getMetadataState().getMetadata();
        FeatureFlags featureFlags = client.getFeatureFlagState().getFeatureFlags();
        return new Event(exc, client.getConfig(), severityReason, metadata, featureFlags, client.logger);
    }

    @NonNull
    public static Logger getLogger() {
        return NativeInterface.getClient().getConfig().getLogger();
    }

    public static void setAutoNotify(boolean autoNotify) {
        NativeInterface.getClient().setAutoNotify(autoNotify);
    }

    public static void setAutoDetectAnrs(boolean autoDetectAnrs) {
        NativeInterface.getClient().setAutoDetectAnrs(autoDetectAnrs);
    }

    public static void startSession() {
        NativeInterface.getClient().startSession();
    }

    public static void pauseSession() {
        NativeInterface.getClient().pauseSession();
    }

    public static boolean resumeSession() {
        return NativeInterface.getClient().resumeSession();
    }

    @Nullable
    public static Session getCurrentSession() {
        return NativeInterface.getClient().sessionTracker.getCurrentSession();
    }

    public static void markLaunchCompleted() {
        NativeInterface.getClient().markLaunchCompleted();
    }

    @Nullable
    public static LastRunInfo getLastRunInfo() {
        return NativeInterface.getClient().getLastRunInfo();
    }
}

