/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.repackaged.dslplatform.json;

import androidx.annotation.Nullable;
import com.bugsnag.android.repackaged.dslplatform.json.Base64;
import com.bugsnag.android.repackaged.dslplatform.json.ConfigurationException;
import com.bugsnag.android.repackaged.dslplatform.json.JsonObject;
import com.bugsnag.android.repackaged.dslplatform.json.ParsingException;
import com.bugsnag.android.repackaged.dslplatform.json.SerializationException;
import com.bugsnag.android.repackaged.dslplatform.json.StringCache;
import com.bugsnag.android.repackaged.dslplatform.json.TypeLookup;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public final class JsonReader<TContext> {
    private static final boolean[] WHITESPACE = new boolean[256];
    private static final Charset utf8 = Charset.forName("UTF-8");
    private int tokenStart;
    private int nameEnd;
    private int currentIndex = 0;
    private long currentPosition = 0L;
    private byte last = (byte)32;
    private int length;
    private final char[] tmp;
    public final TContext context;
    protected byte[] buffer;
    protected char[] chars;
    private InputStream stream;
    private int readLimit;
    private int bufferLenWithExtraSpace;
    private final StringCache keyCache;
    private final StringCache valuesCache;
    private final TypeLookup typeLookup;
    private final byte[] originalBuffer;
    private final int originalBufferLenWithExtraSpace;
    protected final ErrorInfo errorInfo;
    protected final DoublePrecision doublePrecision;
    protected final int doubleLengthLimit;
    protected final UnknownNumberParsing unknownNumbers;
    protected final int maxNumberDigits;
    private final int maxStringBuffer;
    private static final EOFException eof;
    private final StringBuilder error = new StringBuilder(0);
    private final Formatter errorFormatter = new Formatter(this.error);
    private int lastNameLen;

    private JsonReader(char[] tmp, byte[] buffer, int length, @Nullable TContext context, @Nullable StringCache keyCache, @Nullable StringCache valuesCache, @Nullable TypeLookup typeLookup, ErrorInfo errorInfo, DoublePrecision doublePrecision, UnknownNumberParsing unknownNumbers, int maxNumberDigits, int maxStringBuffer) {
        this.tmp = tmp;
        this.buffer = buffer;
        this.length = length;
        this.bufferLenWithExtraSpace = buffer.length - 38;
        this.context = context;
        this.chars = tmp;
        this.keyCache = keyCache;
        this.valuesCache = valuesCache;
        this.typeLookup = typeLookup;
        this.errorInfo = errorInfo;
        this.doublePrecision = doublePrecision;
        this.unknownNumbers = unknownNumbers;
        this.maxNumberDigits = maxNumberDigits;
        this.maxStringBuffer = maxStringBuffer;
        this.doubleLengthLimit = 15 + doublePrecision.level;
        this.originalBuffer = buffer;
        this.originalBufferLenWithExtraSpace = this.bufferLenWithExtraSpace;
    }

    @Deprecated
    public JsonReader(byte[] buffer, @Nullable TContext context) {
        this(buffer, context, null, null);
    }

    @Deprecated
    public JsonReader(byte[] buffer, @Nullable TContext context, @Nullable StringCache keyCache, @Nullable StringCache valuesCache) {
        this(buffer, buffer.length, context, new char[64], keyCache, valuesCache);
    }

    @Deprecated
    public JsonReader(byte[] buffer, TContext context, char[] tmp) {
        this(buffer, buffer.length, context, tmp);
        if (tmp == null) {
            throw new IllegalArgumentException("tmp buffer provided as null.");
        }
    }

    @Deprecated
    public JsonReader(byte[] buffer, int length, TContext context) {
        this(buffer, length, context, new char[64]);
    }

    @Deprecated
    public JsonReader(byte[] buffer, int length, TContext context, char[] tmp) {
        this(buffer, length, context, tmp, null, null);
    }

    @Deprecated
    public JsonReader(byte[] buffer, int length, @Nullable TContext context, char[] tmp, @Nullable StringCache keyCache, @Nullable StringCache valuesCache) {
        this(tmp, buffer, length, context, keyCache, valuesCache, null, ErrorInfo.WITH_STACK_TRACE, DoublePrecision.DEFAULT, UnknownNumberParsing.LONG_AND_BIGDECIMAL, 512, 0x10000000);
        if (tmp == null) {
            throw new IllegalArgumentException("tmp buffer provided as null.");
        }
        if (length > buffer.length) {
            throw new IllegalArgumentException("length can't be longer than buffer.length");
        }
        if (length < buffer.length) {
            buffer[length] = 0;
        }
    }

    JsonReader(byte[] buffer, int length, @Nullable TContext context, char[] tmp, @Nullable StringCache keyCache, @Nullable StringCache valuesCache, @Nullable TypeLookup typeLookup, ErrorInfo errorInfo, DoublePrecision doublePrecision, UnknownNumberParsing unknownNumbers, int maxNumberDigits, int maxStringBuffer) {
        this(tmp, buffer, length, context, keyCache, valuesCache, typeLookup, errorInfo, doublePrecision, unknownNumbers, maxNumberDigits, maxStringBuffer);
        if (tmp == null) {
            throw new IllegalArgumentException("tmp buffer provided as null.");
        }
        if (length > buffer.length) {
            throw new IllegalArgumentException("length can't be longer than buffer.length");
        }
        if (length < buffer.length) {
            buffer[length] = 0;
        }
    }

    @Deprecated
    public final void reset(InputStream stream) throws IOException {
        this.process(stream);
    }

    @Deprecated
    final void reset(int size) {
        this.process(null, size);
    }

    final void reset() {
        this.buffer = this.originalBuffer;
        this.bufferLenWithExtraSpace = this.originalBufferLenWithExtraSpace;
        this.currentIndex = 0;
        this.length = 0;
        this.readLimit = 0;
        this.stream = null;
    }

    public final JsonReader<TContext> process(@Nullable InputStream stream) throws IOException {
        this.currentPosition = 0L;
        this.currentIndex = 0;
        this.stream = stream;
        if (stream != null) {
            this.readLimit = this.length < this.bufferLenWithExtraSpace ? this.length : this.bufferLenWithExtraSpace;
            int available = JsonReader.readFully(this.buffer, stream, 0);
            this.readLimit = available < this.bufferLenWithExtraSpace ? available : this.bufferLenWithExtraSpace;
            this.length = available;
        }
        return this;
    }

    public final JsonReader<TContext> process(@Nullable byte[] newBuffer, int newLength) {
        if (newBuffer != null) {
            this.buffer = newBuffer;
            this.bufferLenWithExtraSpace = this.buffer.length - 38;
        }
        if (newLength > this.buffer.length) {
            throw new IllegalArgumentException("length can't be longer than buffer.length");
        }
        this.currentIndex = 0;
        this.length = newLength;
        this.stream = null;
        this.readLimit = newLength;
        return this;
    }

    public final int length() {
        return this.length;
    }

    public String toString() {
        return new String(this.buffer, 0, this.length, utf8);
    }

    private static int readFully(byte[] buffer, InputStream stream, int offset) throws IOException {
        int position;
        int read;
        for (position = offset; position < buffer.length && (read = stream.read(buffer, position, buffer.length - position)) != -1; position += read) {
        }
        return position;
    }

    boolean withStackTrace() {
        return this.errorInfo == ErrorInfo.WITH_STACK_TRACE;
    }

    public final byte read() throws IOException {
        if (this.stream != null && this.currentIndex > this.readLimit) {
            this.prepareNextBlock();
        }
        if (this.currentIndex >= this.length) {
            throw ParsingException.create("Unexpected end of JSON input", eof, this.withStackTrace());
        }
        this.last = this.buffer[this.currentIndex++];
        return this.last;
    }

    private int prepareNextBlock() throws IOException {
        int len = this.length - this.currentIndex;
        System.arraycopy(this.buffer, this.currentIndex, this.buffer, 0, len);
        int available = JsonReader.readFully(this.buffer, this.stream, len);
        this.currentPosition += (long)this.currentIndex;
        if (available == len) {
            this.length = this.readLimit = this.length - this.currentIndex;
            this.currentIndex = 0;
        } else {
            this.readLimit = available < this.bufferLenWithExtraSpace ? available : this.bufferLenWithExtraSpace;
            this.length = available;
            this.currentIndex = 0;
        }
        return available;
    }

    final boolean isEndOfStream() throws IOException {
        if (this.stream == null) {
            return this.length == this.currentIndex;
        }
        if (this.length != this.currentIndex) {
            return false;
        }
        return this.prepareNextBlock() == 0;
    }

    public final byte last() {
        return this.last;
    }

    public String positionDescription() {
        return this.positionDescription(0);
    }

    public String positionDescription(int offset) {
        StringBuilder error = new StringBuilder(60);
        this.positionDescription(offset, error);
        return error.toString();
    }

    private void positionDescription(int offset, StringBuilder error) {
        int maxLen2;
        error.append("at position: ").append(this.positionInStream(offset));
        if (this.currentIndex > offset) {
            try {
                maxLen2 = Math.min(this.currentIndex - offset, 20);
                String prefix = new String(this.buffer, this.currentIndex - offset - maxLen2, maxLen2, utf8);
                error.append(", following: `");
                error.append(prefix);
                error.append('`');
            }
            catch (Exception maxLen2) {
                // empty catch block
            }
        }
        if (this.currentIndex - offset < this.readLimit) {
            try {
                maxLen2 = Math.min(this.readLimit - this.currentIndex + offset, 20);
                String suffix = new String(this.buffer, this.currentIndex - offset, maxLen2, utf8);
                error.append(", before: `");
                error.append(suffix);
                error.append('`');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final ParsingException newParseError(String description) {
        return this.newParseError(description, 0);
    }

    public final ParsingException newParseError(String description, int positionOffset) {
        if (this.errorInfo == ErrorInfo.MINIMAL) {
            return ParsingException.create(description, false);
        }
        this.error.setLength(0);
        this.error.append(description);
        this.error.append(". Found ");
        this.error.append((char)this.last);
        if (this.errorInfo == ErrorInfo.DESCRIPTION_ONLY) {
            return ParsingException.create(this.error.toString(), false);
        }
        this.error.append(" ");
        this.positionDescription(positionOffset, this.error);
        return ParsingException.create(this.error.toString(), this.withStackTrace());
    }

    public final ParsingException newParseErrorAt(String description, int positionOffset) {
        if (this.errorInfo == ErrorInfo.MINIMAL || this.errorInfo == ErrorInfo.DESCRIPTION_ONLY) {
            return ParsingException.create(description, false);
        }
        this.error.setLength(0);
        this.error.append(description);
        this.error.append(" ");
        this.positionDescription(positionOffset, this.error);
        return ParsingException.create(this.error.toString(), this.withStackTrace());
    }

    public final ParsingException newParseErrorAt(String description, int positionOffset, Exception cause) {
        if (cause == null) {
            throw new IllegalArgumentException("cause can't be null");
        }
        if (this.errorInfo == ErrorInfo.MINIMAL) {
            return ParsingException.create(description, cause, false);
        }
        this.error.setLength(0);
        String msg = cause.getMessage();
        if (msg != null && msg.length() > 0) {
            this.error.append(msg);
            if (!msg.endsWith(".")) {
                this.error.append(".");
            }
            this.error.append(" ");
        }
        this.error.append(description);
        if (this.errorInfo == ErrorInfo.DESCRIPTION_ONLY) {
            return ParsingException.create(this.error.toString(), cause, false);
        }
        this.error.append(" ");
        this.positionDescription(positionOffset, this.error);
        return ParsingException.create(this.error.toString(), this.withStackTrace());
    }

    public final ParsingException newParseErrorFormat(String shortDescription, int positionOffset, String longDescriptionFormat, Object ... arguments) {
        if (this.errorInfo == ErrorInfo.MINIMAL) {
            return ParsingException.create(shortDescription, false);
        }
        this.error.setLength(0);
        this.errorFormatter.format(longDescriptionFormat, arguments);
        if (this.errorInfo == ErrorInfo.DESCRIPTION_ONLY) {
            return ParsingException.create(this.error.toString(), false);
        }
        this.error.append(" ");
        this.positionDescription(positionOffset, this.error);
        return ParsingException.create(this.error.toString(), this.withStackTrace());
    }

    public final ParsingException newParseErrorWith(String description, @Nullable Object argument) {
        return this.newParseErrorWith(description, 0, "", description, argument, "");
    }

    public final ParsingException newParseErrorWith(String shortDescription, int positionOffset, String longDescriptionPrefix, String longDescriptionMessage, @Nullable Object argument, String longDescriptionSuffix) {
        if (this.errorInfo == ErrorInfo.MINIMAL) {
            return ParsingException.create(shortDescription, false);
        }
        this.error.setLength(0);
        this.error.append(longDescriptionPrefix);
        this.error.append(longDescriptionMessage);
        if (argument != null) {
            this.error.append(": '");
            this.error.append(argument.toString());
            this.error.append("'");
        }
        this.error.append(longDescriptionSuffix);
        if (this.errorInfo == ErrorInfo.DESCRIPTION_ONLY) {
            return ParsingException.create(this.error.toString(), false);
        }
        this.error.append(" ");
        this.positionDescription(positionOffset, this.error);
        return ParsingException.create(this.error.toString(), this.withStackTrace());
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    public final int getCurrentIndex() {
        return this.currentIndex;
    }

    @Deprecated
    public final char[] readNumber() {
        this.tokenStart = this.currentIndex - 1;
        this.tmp[0] = (char)this.last;
        int i = 1;
        int ci = this.currentIndex;
        byte bb = this.last;
        while (i < this.tmp.length && ci < this.length && (bb = this.buffer[ci++]) != 44 && bb != 125 && bb != 93) {
            this.tmp[i++] = (char)bb;
        }
        this.currentIndex += i - 1;
        this.last = bb;
        return this.tmp;
    }

    public final int scanNumber() {
        this.tokenStart = this.currentIndex - 1;
        int i = 1;
        int ci = this.currentIndex;
        byte bb = this.last;
        while (ci < this.length && (bb = this.buffer[ci++]) != 44 && bb != 125 && bb != 93) {
            ++i;
        }
        this.currentIndex += i - 1;
        this.last = bb;
        return this.tokenStart;
    }

    final char[] prepareBuffer(int start, int len) throws ParsingException {
        if (len > this.maxNumberDigits) {
            throw this.newParseErrorWith("Too many digits detected in number", len, "", "Too many digits detected in number", len, "");
        }
        while (this.chars.length < len) {
            this.chars = Arrays.copyOf(this.chars, this.chars.length * 2);
        }
        char[] _tmp = this.chars;
        byte[] _buf = this.buffer;
        for (int i = 0; i < len; ++i) {
            _tmp[i] = (char)_buf[start + i];
        }
        return _tmp;
    }

    final boolean allWhitespace(int start, int end) {
        byte[] _buf = this.buffer;
        for (int i = start; i < end; ++i) {
            if (WHITESPACE[_buf[i] + 128]) continue;
            return false;
        }
        return true;
    }

    final int findNonWhitespace(int end) {
        byte[] _buf = this.buffer;
        for (int i = end - 1; i > 0; --i) {
            if (WHITESPACE[_buf[i] + 128]) continue;
            return i + 1;
        }
        return 0;
    }

    public final String readSimpleString() throws ParsingException {
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for string start");
        }
        int i = 0;
        int ci = this.currentIndex;
        try {
            byte bb;
            while (i < this.tmp.length && (bb = this.buffer[ci++]) != 34) {
                this.tmp[i++] = (char)bb;
            }
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            throw this.newParseErrorAt("JSON string was not closed with a double quote", 0);
        }
        if (ci > this.length) {
            throw this.newParseErrorAt("JSON string was not closed with a double quote", 0);
        }
        this.currentIndex = ci;
        return new String(this.tmp, 0, i);
    }

    public final char[] readSimpleQuote() throws ParsingException {
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for string start");
        }
        int ci = this.tokenStart = this.currentIndex;
        try {
            byte bb;
            for (int i = 0; i < this.tmp.length && (bb = this.buffer[ci++]) != 34; ++i) {
                this.tmp[i] = (char)bb;
            }
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            throw this.newParseErrorAt("JSON string was not closed with a double quote", 0);
        }
        if (ci > this.length) {
            throw this.newParseErrorAt("JSON string was not closed with a double quote", 0);
        }
        this.currentIndex = ci;
        return this.tmp;
    }

    public final String readString() throws IOException {
        int len = this.parseString();
        return this.valuesCache == null ? new String(this.chars, 0, len) : this.valuesCache.get(this.chars, len);
    }

    public final StringBuilder appendString(StringBuilder builder) throws IOException {
        int len = this.parseString();
        builder.append(this.chars, 0, len);
        return builder;
    }

    public final StringBuffer appendString(StringBuffer buffer) throws IOException {
        int len = this.parseString();
        buffer.append(this.chars, 0, len);
        return buffer;
    }

    final int parseString() throws IOException {
        int startIndex = this.currentIndex;
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for string start");
        }
        if (this.currentIndex == this.length) {
            throw this.newParseErrorAt("Premature end of JSON string", 0);
        }
        int ci = this.currentIndex;
        char[] _tmp = this.chars;
        int remaining = this.length - this.currentIndex;
        int _tmpLen = _tmp.length < remaining ? _tmp.length : remaining;
        int i = 0;
        while (i < _tmpLen) {
            byte bb;
            if ((bb = this.buffer[ci++]) == 34) {
                this.currentIndex = ci;
                return i;
            }
            if ((bb ^ 0x5C) < 1) break;
            _tmp[i++] = (char)bb;
        }
        if (i == _tmp.length) {
            int newSize = this.chars.length * 2;
            if (newSize > this.maxStringBuffer) {
                throw this.newParseErrorWith("Maximum string buffer limit exceeded", this.maxStringBuffer);
            }
            _tmp = this.chars = Arrays.copyOf(this.chars, newSize);
        }
        _tmpLen = _tmp.length;
        this.currentIndex = ci;
        int soFar = --this.currentIndex - startIndex;
        while (!this.isEndOfStream()) {
            int bc;
            block33: {
                int newSize;
                block32: {
                    bc = this.read();
                    if (bc == 34) {
                        return soFar;
                    }
                    if (bc != 92) break block32;
                    if (soFar >= _tmpLen - 6) {
                        newSize = this.chars.length * 2;
                        if (newSize > this.maxStringBuffer) {
                            throw this.newParseErrorWith("Maximum string buffer limit exceeded", this.maxStringBuffer);
                        }
                        _tmp = this.chars = Arrays.copyOf(this.chars, newSize);
                        _tmpLen = _tmp.length;
                    }
                    bc = this.buffer[this.currentIndex++];
                    switch (bc) {
                        case 98: {
                            bc = 8;
                            break block33;
                        }
                        case 116: {
                            bc = 9;
                            break block33;
                        }
                        case 110: {
                            bc = 10;
                            break block33;
                        }
                        case 102: {
                            bc = 12;
                            break block33;
                        }
                        case 114: {
                            bc = 13;
                            break block33;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            break block33;
                        }
                        case 117: {
                            bc = (this.hexToInt(this.buffer[this.currentIndex++]) << 12) + (this.hexToInt(this.buffer[this.currentIndex++]) << 8) + (this.hexToInt(this.buffer[this.currentIndex++]) << 4) + this.hexToInt(this.buffer[this.currentIndex++]);
                            break block33;
                        }
                        default: {
                            throw this.newParseErrorWith("Invalid escape combination detected", bc);
                        }
                    }
                }
                if ((bc & 0x80) != 0) {
                    if (soFar >= _tmpLen - 4) {
                        newSize = this.chars.length * 2;
                        if (newSize > this.maxStringBuffer) {
                            throw this.newParseErrorWith("Maximum string buffer limit exceeded", this.maxStringBuffer);
                        }
                        _tmp = this.chars = Arrays.copyOf(this.chars, newSize);
                        _tmpLen = _tmp.length;
                    }
                    byte u2 = this.buffer[this.currentIndex++];
                    if ((bc & 0xE0) == 192) {
                        bc = ((bc & 0x1F) << 6) + (u2 & 0x3F);
                    } else {
                        byte u3 = this.buffer[this.currentIndex++];
                        if ((bc & 0xF0) == 224) {
                            bc = ((bc & 0xF) << 12) + ((u2 & 0x3F) << 6) + (u3 & 0x3F);
                        } else {
                            byte u4 = this.buffer[this.currentIndex++];
                            if ((bc & 0xF8) != 240) {
                                throw this.newParseErrorAt("Invalid unicode character detected", 0);
                            }
                            bc = ((bc & 7) << 18) + ((u2 & 0x3F) << 12) + ((u3 & 0x3F) << 6) + (u4 & 0x3F);
                            if (bc >= 65536) {
                                if (bc >= 0x110000) {
                                    throw this.newParseErrorAt("Invalid unicode character detected", 0);
                                }
                                int sup = bc - 65536;
                                _tmp[soFar++] = (char)((sup >>> 10) + 55296);
                                _tmp[soFar++] = (char)((sup & 0x3FF) + 56320);
                                continue;
                            }
                        }
                    }
                } else if (soFar >= _tmpLen) {
                    newSize = this.chars.length * 2;
                    if (newSize > this.maxStringBuffer) {
                        throw this.newParseErrorWith("Maximum string buffer limit exceeded", this.maxStringBuffer);
                    }
                    _tmp = this.chars = Arrays.copyOf(this.chars, newSize);
                    _tmpLen = _tmp.length;
                }
            }
            _tmp[soFar++] = (char)bc;
        }
        throw this.newParseErrorAt("JSON string was not closed with a double quote", 0);
    }

    private int hexToInt(byte value) throws ParsingException {
        if (value >= 48 && value <= 57) {
            return value - 48;
        }
        if (value >= 65 && value <= 70) {
            return value - 55;
        }
        if (value >= 97 && value <= 102) {
            return value - 87;
        }
        throw this.newParseErrorWith("Could not parse unicode escape, expected a hexadecimal digit", value);
    }

    private boolean wasWhiteSpace() {
        switch (this.last) {
            case -96: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
            case -31: {
                if (this.currentIndex + 1 < this.length && this.buffer[this.currentIndex] == -102 && this.buffer[this.currentIndex + 1] == -128) {
                    this.currentIndex += 2;
                    this.last = (byte)32;
                    return true;
                }
                return false;
            }
            case -30: {
                if (this.currentIndex + 1 < this.length) {
                    byte b1 = this.buffer[this.currentIndex];
                    byte b2 = this.buffer[this.currentIndex + 1];
                    if (b1 == -127 && b2 == -97) {
                        this.currentIndex += 2;
                        this.last = (byte)32;
                        return true;
                    }
                    if (b1 != -128) {
                        return false;
                    }
                    switch (b2) {
                        case -128: 
                        case -127: 
                        case -126: 
                        case -125: 
                        case -124: 
                        case -123: 
                        case -122: 
                        case -121: 
                        case -120: 
                        case -119: 
                        case -118: 
                        case -88: 
                        case -87: 
                        case -81: {
                            this.currentIndex += 2;
                            this.last = (byte)32;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case -29: {
                if (this.currentIndex + 1 < this.length && this.buffer[this.currentIndex] == -128 && this.buffer[this.currentIndex + 1] == -128) {
                    this.currentIndex += 2;
                    this.last = (byte)32;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public final byte getNextToken() throws IOException {
        this.read();
        if (WHITESPACE[this.last + 128]) {
            while (this.wasWhiteSpace()) {
                this.read();
            }
        }
        return this.last;
    }

    public final long positionInStream() {
        return this.currentPosition + (long)this.currentIndex;
    }

    public final long positionInStream(int offset) {
        return this.currentPosition + (long)this.currentIndex - (long)offset;
    }

    public final int fillName() throws IOException {
        int hash = this.calcHash();
        if (!(this.read() == 58 || this.wasWhiteSpace() && this.getNextToken() == 58)) {
            throw this.newParseError("Expecting ':' after attribute name");
        }
        return hash;
    }

    public final int fillNameWeakHash() throws IOException {
        int hash = this.calcWeakHash();
        if (!(this.read() == 58 || this.wasWhiteSpace() && this.getNextToken() == 58)) {
            throw this.newParseError("Expecting ':' after attribute name");
        }
        return hash;
    }

    public final int calcHash() throws IOException {
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for attribute name start");
        }
        this.tokenStart = this.currentIndex;
        int ci = this.currentIndex;
        long hash = -2128831035L;
        if (this.stream != null) {
            while (ci < this.readLimit) {
                byte b = this.buffer[ci];
                if (b == 92) {
                    if (ci == this.readLimit - 1) {
                        return this.calcHashAndCopyName(hash, ci);
                    }
                    b = this.buffer[++ci];
                } else if (b == 34) break;
                ++ci;
                hash ^= (long)b;
                hash *= 16777619L;
            }
            if (ci >= this.readLimit) {
                return this.calcHashAndCopyName(hash, ci);
            }
            this.nameEnd = this.currentIndex = ci + 1;
        } else {
            while (ci < this.buffer.length) {
                byte b;
                if ((b = this.buffer[ci++]) == 92) {
                    if (ci == this.buffer.length) {
                        throw this.newParseError("Expecting '\"' for attribute name end");
                    }
                    b = this.buffer[ci++];
                } else if (b == 34) break;
                hash ^= (long)b;
                hash *= 16777619L;
            }
            this.nameEnd = this.currentIndex = ci;
        }
        return (int)hash;
    }

    public final int calcWeakHash() throws IOException {
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for attribute name start");
        }
        this.tokenStart = this.currentIndex;
        int ci = this.currentIndex;
        int hash = 0;
        if (this.stream != null) {
            while (ci < this.readLimit) {
                byte b = this.buffer[ci];
                if (b == 92) {
                    if (ci == this.readLimit - 1) {
                        return this.calcWeakHashAndCopyName(hash, ci);
                    }
                    b = this.buffer[++ci];
                } else if (b == 34) break;
                ++ci;
                hash += b;
            }
            if (ci >= this.readLimit) {
                return this.calcWeakHashAndCopyName(hash, ci);
            }
            this.nameEnd = this.currentIndex = ci + 1;
        } else {
            while (ci < this.buffer.length) {
                byte b;
                if ((b = this.buffer[ci++]) == 92) {
                    if (ci == this.buffer.length) {
                        throw this.newParseError("Expecting '\"' for attribute name end");
                    }
                    b = this.buffer[ci++];
                } else if (b == 34) break;
                hash += b;
            }
            this.nameEnd = this.currentIndex = ci;
        }
        return hash;
    }

    public final int getLastHash() {
        long hash = -2128831035L;
        if (this.stream != null && this.nameEnd == -1) {
            int i = 0;
            while (i < this.lastNameLen) {
                byte b = (byte)this.chars[i++];
                hash ^= (long)b;
                hash *= 16777619L;
            }
        } else {
            int i = this.tokenStart;
            int end = this.nameEnd - 1;
            while (i < end) {
                byte b = this.buffer[i++];
                hash ^= (long)b;
                hash *= 16777619L;
            }
        }
        return (int)hash;
    }

    private int calcHashAndCopyName(long hash, int ci) throws IOException {
        int i;
        int soFar = ci - this.tokenStart;
        long startPosition = this.currentPosition - (long)soFar;
        while (this.chars.length < soFar) {
            this.chars = Arrays.copyOf(this.chars, this.chars.length * 2);
        }
        for (i = 0; i < soFar; ++i) {
            this.chars[i] = (char)this.buffer[i + this.tokenStart];
        }
        this.currentIndex = ci;
        do {
            byte b;
            if ((b = this.read()) == 92) {
                b = this.read();
            } else if (b == 34) {
                this.nameEnd = -1;
                this.lastNameLen = i;
                return (int)hash;
            }
            if (i == this.chars.length) {
                this.chars = Arrays.copyOf(this.chars, this.chars.length * 2);
            }
            this.chars[i++] = (char)b;
            hash ^= (long)b;
            hash *= 16777619L;
        } while (!this.isEndOfStream());
        throw this.newParseErrorAt("JSON string was not closed with a double quote", (int)startPosition);
    }

    private int calcWeakHashAndCopyName(int hash, int ci) throws IOException {
        int i;
        int soFar = ci - this.tokenStart;
        long startPosition = this.currentPosition - (long)soFar;
        while (this.chars.length < soFar) {
            this.chars = Arrays.copyOf(this.chars, this.chars.length * 2);
        }
        for (i = 0; i < soFar; ++i) {
            this.chars[i] = (char)this.buffer[i + this.tokenStart];
        }
        this.currentIndex = ci;
        do {
            byte b;
            if ((b = this.read()) == 92) {
                b = this.read();
            } else if (b == 34) {
                this.nameEnd = -1;
                this.lastNameLen = i;
                return hash;
            }
            if (i == this.chars.length) {
                this.chars = Arrays.copyOf(this.chars, this.chars.length * 2);
            }
            this.chars[i++] = (char)b;
            hash += b;
        } while (!this.isEndOfStream());
        throw this.newParseErrorAt("JSON string was not closed with a double quote", (int)startPosition);
    }

    public final boolean wasLastName(String name) {
        if (this.stream != null && this.nameEnd == -1) {
            if (name.length() != this.lastNameLen) {
                return false;
            }
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) == this.chars[i]) continue;
                return false;
            }
            return true;
        }
        if (name.length() != this.nameEnd - this.tokenStart - 1) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == this.buffer[this.tokenStart + i]) continue;
            return false;
        }
        return true;
    }

    public final boolean wasLastName(byte[] name) {
        if (this.stream != null && this.nameEnd == -1) {
            if (name.length != this.lastNameLen) {
                return false;
            }
            for (int i = 0; i < name.length; ++i) {
                if (name[i] == this.chars[i]) continue;
                return false;
            }
            return true;
        }
        if (name.length != this.nameEnd - this.tokenStart - 1) {
            return false;
        }
        for (int i = 0; i < name.length; ++i) {
            if (name[i] == this.buffer[this.tokenStart + i]) continue;
            return false;
        }
        return true;
    }

    public final String getLastName() throws IOException {
        if (this.stream != null && this.nameEnd == -1) {
            return new String(this.chars, 0, this.lastNameLen);
        }
        return new String(this.buffer, this.tokenStart, this.nameEnd - this.tokenStart - 1, "UTF-8");
    }

    private byte skipString() throws IOException {
        byte c = this.read();
        boolean inEscape = false;
        while (c != 34 || inEscape) {
            inEscape = !inEscape && c == 92;
            c = this.read();
        }
        return this.getNextToken();
    }

    public final byte skip() throws IOException {
        if (this.last == 34) {
            return this.skipString();
        }
        if (this.last == 123) {
            byte nextToken = this.getNextToken();
            if (nextToken == 125) {
                return this.getNextToken();
            }
            if (nextToken != 34) {
                throw this.newParseError("Expecting '\"' for attribute name");
            }
            nextToken = this.skipString();
            if (nextToken != 58) {
                throw this.newParseError("Expecting ':' after attribute name");
            }
            this.getNextToken();
            nextToken = this.skip();
            while (nextToken == 44) {
                nextToken = this.getNextToken();
                if (nextToken != 34) {
                    throw this.newParseError("Expecting '\"' for attribute name");
                }
                nextToken = this.skipString();
                if (nextToken != 58) {
                    throw this.newParseError("Expecting ':' after attribute name");
                }
                this.getNextToken();
                nextToken = this.skip();
            }
            if (nextToken != 125) {
                throw this.newParseError("Expecting '}' for object end");
            }
            return this.getNextToken();
        }
        if (this.last == 91) {
            this.getNextToken();
            byte nextToken = this.skip();
            while (nextToken == 44) {
                this.getNextToken();
                nextToken = this.skip();
            }
            if (nextToken != 93) {
                throw this.newParseError("Expecting ']' for array end");
            }
            return this.getNextToken();
        }
        if (this.last == 110) {
            if (!this.wasNull()) {
                throw this.newParseErrorAt("Expecting 'null' for null constant", 0);
            }
            return this.getNextToken();
        }
        if (this.last == 116) {
            if (!this.wasTrue()) {
                throw this.newParseErrorAt("Expecting 'true' for true constant", 0);
            }
            return this.getNextToken();
        }
        if (this.last == 102) {
            if (!this.wasFalse()) {
                throw this.newParseErrorAt("Expecting 'false' for false constant", 0);
            }
            return this.getNextToken();
        }
        while (this.last != 44 && this.last != 125 && this.last != 93) {
            this.read();
        }
        return this.last;
    }

    @Deprecated
    public String readNext() throws IOException {
        int start = this.currentIndex - 1;
        this.skip();
        return new String(this.buffer, start, this.currentIndex - start - 1, "UTF-8");
    }

    public final byte[] readBase64() throws IOException {
        if (this.stream != null && Base64.findEnd(this.buffer, this.currentIndex) == this.buffer.length) {
            int len = this.parseString();
            byte[] input = new byte[len];
            for (int i = 0; i < input.length; ++i) {
                input[i] = (byte)this.chars[i];
            }
            return Base64.decodeFast(input, 0, len);
        }
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for base64 start");
        }
        int start = this.currentIndex;
        this.currentIndex = Base64.findEnd(this.buffer, start);
        this.last = this.buffer[this.currentIndex++];
        if (this.last != 34) {
            throw this.newParseError("Expecting '\"' for base64 end");
        }
        return Base64.decodeFast(this.buffer, start, this.currentIndex - 1);
    }

    public final String readKey() throws IOException {
        String key;
        int len = this.parseString();
        String string = key = this.keyCache != null ? this.keyCache.get(this.chars, len) : new String(this.chars, 0, len);
        if (this.getNextToken() != 58) {
            throw this.newParseError("Expecting ':' after attribute name");
        }
        this.getNextToken();
        return key;
    }

    public final boolean wasNull() throws ParsingException {
        if (this.last == 110) {
            if (this.currentIndex + 2 < this.length && this.buffer[this.currentIndex] == 117 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 108) {
                this.currentIndex += 3;
                this.last = (byte)108;
                return true;
            }
            throw this.newParseErrorAt("Invalid null constant found", 0);
        }
        return false;
    }

    public final boolean wasTrue() throws ParsingException {
        if (this.last == 116) {
            if (this.currentIndex + 2 < this.length && this.buffer[this.currentIndex] == 114 && this.buffer[this.currentIndex + 1] == 117 && this.buffer[this.currentIndex + 2] == 101) {
                this.currentIndex += 3;
                this.last = (byte)101;
                return true;
            }
            throw this.newParseErrorAt("Invalid true constant found", 0);
        }
        return false;
    }

    public final boolean wasFalse() throws ParsingException {
        if (this.last == 102) {
            if (this.currentIndex + 3 < this.length && this.buffer[this.currentIndex] == 97 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 115 && this.buffer[this.currentIndex + 3] == 101) {
                this.currentIndex += 4;
                this.last = (byte)101;
                return true;
            }
            throw this.newParseErrorAt("Invalid false constant found", 0);
        }
        return false;
    }

    public final void comma() throws IOException {
        if (this.getNextToken() != 44) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end in JSON", 0, eof);
            }
            throw this.newParseError("Expecting ','");
        }
    }

    public final void semicolon() throws IOException {
        if (this.getNextToken() != 58) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end in JSON", 0, eof);
            }
            throw this.newParseError("Expecting ':'");
        }
    }

    public final void startArray() throws IOException {
        if (this.getNextToken() != 91) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end in JSON", 0, eof);
            }
            throw this.newParseError("Expecting '[' as array start");
        }
    }

    public final void endArray() throws IOException {
        if (this.getNextToken() != 93) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end in JSON", 0, eof);
            }
            throw this.newParseError("Expecting ']' as array end");
        }
    }

    public final void startObject() throws IOException {
        if (this.getNextToken() != 123) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end in JSON", 0, eof);
            }
            throw this.newParseError("Expecting '{' as object start");
        }
    }

    public final void endObject() throws IOException {
        if (this.getNextToken() != 125) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end in JSON", 0, eof);
            }
            throw this.newParseError("Expecting '}' as object end");
        }
    }

    public final void startAttribute(String name) throws IOException {
        do {
            if (this.getNextToken() != 34) {
                throw this.newParseError("Expecting '\"' as attribute start");
            }
            this.fillNameWeakHash();
            if (this.wasLastName(name)) {
                return;
            }
            this.getNextToken();
        } while (this.skip() == 44);
        throw this.newParseErrorWith("Unable to find attribute", name);
    }

    public final void checkArrayEnd() throws IOException {
        if (this.last != 93) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end of JSON in collection", 0, eof);
            }
            throw this.newParseError("Expecting ']' as array end");
        }
    }

    public final void checkObjectEnd() throws IOException {
        if (this.last != 125) {
            if (this.currentIndex >= this.length) {
                throw this.newParseErrorAt("Unexpected end of JSON in object", 0, eof);
            }
            throw this.newParseError("Expecting '}' as object end");
        }
    }

    @Nullable
    private Object readNull(Class<?> manifest) throws IOException {
        if (!this.wasNull()) {
            throw this.newParseErrorAt("Expecting 'null' as null constant", 0);
        }
        if (manifest.isPrimitive()) {
            if (manifest == Integer.TYPE) {
                return 0;
            }
            if (manifest == Long.TYPE) {
                return 0L;
            }
            if (manifest == Short.TYPE) {
                return (short)0;
            }
            if (manifest == Byte.TYPE) {
                return (byte)0;
            }
            if (manifest == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (manifest == Double.TYPE) {
                return 0.0;
            }
            if (manifest == Boolean.TYPE) {
                return false;
            }
            if (manifest == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
        }
        return null;
    }

    @Nullable
    public final <T> T next(Class<T> manifest) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (this.typeLookup == null) {
            throw new ConfigurationException("typeLookup is not defined for this JsonReader. Unable to lookup specified type " + manifest);
        }
        if (this.getNextToken() == 110) {
            return (T)this.readNull(manifest);
        }
        ReadObject<T> reader = this.typeLookup.tryFindReader(manifest);
        if (reader == null) {
            throw new ConfigurationException("Reader not found for " + manifest + ". Check if reader was registered");
        }
        return reader.read(this);
    }

    @Nullable
    public final <T> T next(ReadObject<T> reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader can't be null");
        }
        if (this.getNextToken() == 110) {
            if (!this.wasNull()) {
                throw this.newParseErrorAt("Expecting 'null' as null constant", 0);
            }
            return null;
        }
        return reader.read(this);
    }

    @Nullable
    public final <T> T next(Class<T> manifest, T instance) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance can't be null");
        }
        if (this.typeLookup == null) {
            throw new ConfigurationException("typeLookup is not defined for this JsonReader. Unable to lookup specified type " + manifest);
        }
        if (this.getNextToken() == 110) {
            return (T)this.readNull(manifest);
        }
        BindObject<T> binder = this.typeLookup.tryFindBinder(manifest);
        if (binder == null) {
            throw new ConfigurationException("Binder not found for " + manifest + ". Check if binder was registered");
        }
        return binder.bind(this, instance);
    }

    @Nullable
    public final <T> T next(BindObject<T> binder, T instance) throws IOException {
        if (binder == null) {
            throw new IllegalArgumentException("binder can't be null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance can't be null");
        }
        if (this.getNextToken() == 110) {
            if (!this.wasNull()) {
                throw this.newParseErrorAt("Expecting 'null' as null constant", 0);
            }
            return null;
        }
        return binder.bind(this, instance);
    }

    @Nullable
    public final <T> ArrayList<T> readCollection(ReadObject<T> readObject) throws IOException {
        if (this.wasNull()) {
            return null;
        }
        if (this.last != 91) {
            throw this.newParseError("Expecting '[' as collection start");
        }
        if (this.getNextToken() == 93) {
            return new ArrayList(0);
        }
        ArrayList<T> res = new ArrayList<T>(4);
        res.add(readObject.read(this));
        while (this.getNextToken() == 44) {
            this.getNextToken();
            res.add(readObject.read(this));
        }
        this.checkArrayEnd();
        return res;
    }

    @Nullable
    public final <T> LinkedHashSet<T> readSet(ReadObject<T> readObject) throws IOException {
        if (this.wasNull()) {
            return null;
        }
        if (this.last != 91) {
            throw this.newParseError("Expecting '[' as set start");
        }
        if (this.getNextToken() == 93) {
            return new LinkedHashSet(0);
        }
        LinkedHashSet<T> res = new LinkedHashSet<T>(4);
        res.add(readObject.read(this));
        while (this.getNextToken() == 44) {
            this.getNextToken();
            res.add(readObject.read(this));
        }
        this.checkArrayEnd();
        return res;
    }

    @Nullable
    public final <K, V> LinkedHashMap<K, V> readMap(ReadObject<K> readKey, ReadObject<V> readValue) throws IOException {
        if (this.wasNull()) {
            return null;
        }
        if (this.last != 123) {
            throw this.newParseError("Expecting '{' as map start");
        }
        if (this.getNextToken() == 125) {
            return new LinkedHashMap(0);
        }
        LinkedHashMap<K, V> res = new LinkedHashMap<K, V>(4);
        K key = readKey.read(this);
        if (key == null) {
            throw this.newParseErrorAt("Null detected as key", 0);
        }
        if (this.getNextToken() != 58) {
            throw this.newParseError("Expecting ':' after key attribute");
        }
        this.getNextToken();
        V value = readValue.read(this);
        res.put(key, value);
        while (this.getNextToken() == 44) {
            this.getNextToken();
            key = readKey.read(this);
            if (key == null) {
                throw this.newParseErrorAt("Null detected as key", 0);
            }
            if (this.getNextToken() != 58) {
                throw this.newParseError("Expecting ':' after key attribute");
            }
            this.getNextToken();
            value = readValue.read(this);
            res.put(key, value);
        }
        this.checkObjectEnd();
        return res;
    }

    @Nullable
    public final <T> T[] readArray(ReadObject<T> readObject, T[] emptyArray) throws IOException {
        if (this.wasNull()) {
            return null;
        }
        if (this.last != 91) {
            throw this.newParseError("Expecting '[' as array start");
        }
        if (this.getNextToken() == 93) {
            return emptyArray;
        }
        ArrayList<T> res = new ArrayList<T>(4);
        res.add(readObject.read(this));
        while (this.getNextToken() == 44) {
            this.getNextToken();
            res.add(readObject.read(this));
        }
        this.checkArrayEnd();
        return res.toArray(emptyArray);
    }

    public final <T, S extends T> ArrayList<T> deserializeCollectionCustom(ReadObject<S> readObject) throws IOException {
        ArrayList res = new ArrayList(4);
        this.deserializeCollection(readObject, res);
        return res;
    }

    public final <T, S extends T> void deserializeCollection(ReadObject<S> readObject, Collection<T> res) throws IOException {
        res.add(readObject.read(this));
        while (this.getNextToken() == 44) {
            this.getNextToken();
            res.add(readObject.read(this));
        }
        this.checkArrayEnd();
    }

    public final <T, S extends T> ArrayList<T> deserializeNullableCollectionCustom(ReadObject<S> readObject) throws IOException {
        ArrayList res = new ArrayList(4);
        this.deserializeNullableCollection(readObject, res);
        return res;
    }

    public final <T, S extends T> void deserializeNullableCollection(ReadObject<S> readObject, Collection<T> res) throws IOException {
        if (this.wasNull()) {
            res.add(null);
        } else {
            res.add(readObject.read(this));
        }
        while (this.getNextToken() == 44) {
            this.getNextToken();
            if (this.wasNull()) {
                res.add(null);
                continue;
            }
            res.add(readObject.read(this));
        }
        this.checkArrayEnd();
    }

    public final <T extends JsonObject> ArrayList<T> deserializeCollection(ReadJsonObject<T> readObject) throws IOException {
        ArrayList res = new ArrayList(4);
        this.deserializeCollection(readObject, res);
        return res;
    }

    public final <T extends JsonObject> void deserializeCollection(ReadJsonObject<T> readObject, Collection<T> res) throws IOException {
        if (this.last == 123) {
            this.getNextToken();
            res.add(readObject.deserialize(this));
        } else {
            throw this.newParseError("Expecting '{' as collection start");
        }
        while (this.getNextToken() == 44) {
            if (this.getNextToken() == 123) {
                this.getNextToken();
                res.add(readObject.deserialize(this));
                continue;
            }
            throw this.newParseError("Expecting '{' as object start within a collection");
        }
        this.checkArrayEnd();
    }

    public final <T extends JsonObject> ArrayList<T> deserializeNullableCollection(ReadJsonObject<T> readObject) throws IOException {
        ArrayList res = new ArrayList(4);
        this.deserializeNullableCollection(readObject, res);
        return res;
    }

    public final <T extends JsonObject> void deserializeNullableCollection(ReadJsonObject<T> readObject, Collection<T> res) throws IOException {
        if (this.last == 123) {
            this.getNextToken();
            res.add(readObject.deserialize(this));
        } else if (this.wasNull()) {
            res.add(null);
        } else {
            throw this.newParseError("Expecting '{' as collection start");
        }
        while (this.getNextToken() == 44) {
            if (this.getNextToken() == 123) {
                this.getNextToken();
                res.add(readObject.deserialize(this));
                continue;
            }
            if (this.wasNull()) {
                res.add(null);
                continue;
            }
            throw this.newParseError("Expecting '{' as object start within a collection");
        }
        this.checkArrayEnd();
    }

    public final <T> Iterator<T> iterateOverCustom(ReadObject<T> reader) {
        return new WithReader<T>(reader, this);
    }

    public final <T extends JsonObject> Iterator<T> iterateOver(ReadJsonObject<T> reader) {
        return new WithObjectReader<T>(reader, this);
    }

    static {
        JsonReader.WHITESPACE[137] = true;
        JsonReader.WHITESPACE[138] = true;
        JsonReader.WHITESPACE[139] = true;
        JsonReader.WHITESPACE[140] = true;
        JsonReader.WHITESPACE[141] = true;
        JsonReader.WHITESPACE[160] = true;
        JsonReader.WHITESPACE[32] = true;
        JsonReader.WHITESPACE[97] = true;
        JsonReader.WHITESPACE[98] = true;
        JsonReader.WHITESPACE[99] = true;
        eof = new EmptyEOFException();
    }

    private static class WithObjectReader<T extends JsonObject>
    implements Iterator<T> {
        private final ReadJsonObject<T> reader;
        private final JsonReader json;
        private boolean hasNext;

        WithObjectReader(ReadJsonObject<T> reader, JsonReader json) {
            this.reader = reader;
            this.json = json;
            this.hasNext = true;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public void remove() {
        }

        @Override
        @Nullable
        public T next() {
            try {
                T instance;
                byte nextToken = this.json.last();
                if (nextToken == 110) {
                    if (!this.json.wasNull()) {
                        throw this.json.newParseErrorAt("Expecting 'null' as null constant", 0);
                    }
                    instance = null;
                } else if (nextToken == 123) {
                    this.json.getNextToken();
                    instance = this.reader.deserialize(this.json);
                } else {
                    throw this.json.newParseError("Expecting '{' for object start in iteration");
                }
                boolean bl = this.hasNext = this.json.getNextToken() == 44;
                if (this.hasNext) {
                    this.json.getNextToken();
                } else if (this.json.last() != 93) {
                    throw this.json.newParseError("Expecting ']' for iteration end");
                }
                return instance;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    private static class WithReader<T>
    implements Iterator<T> {
        private final ReadObject<T> reader;
        private final JsonReader json;
        private boolean hasNext;

        WithReader(ReadObject<T> reader, JsonReader json) {
            this.reader = reader;
            this.json = json;
            this.hasNext = true;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public void remove() {
        }

        @Override
        @Nullable
        public T next() {
            try {
                T instance;
                byte nextToken = this.json.last();
                if (nextToken == 110) {
                    if (!this.json.wasNull()) {
                        throw this.json.newParseErrorAt("Expecting 'null' as null constant", 0);
                    }
                    instance = null;
                } else {
                    instance = this.reader.read(this.json);
                }
                boolean bl = this.hasNext = this.json.getNextToken() == 44;
                if (this.hasNext) {
                    this.json.getNextToken();
                } else if (this.json.last() != 93) {
                    throw this.json.newParseError("Expecting ']' for iteration end");
                }
                return instance;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    public static interface ReadJsonObject<T extends JsonObject> {
        @Nullable
        public T deserialize(JsonReader var1) throws IOException;
    }

    public static interface BindObject<T> {
        public T bind(JsonReader var1, T var2) throws IOException;
    }

    public static interface ReadObject<T> {
        @Nullable
        public T read(JsonReader var1) throws IOException;
    }

    private static class EmptyEOFException
    extends EOFException {
        private EmptyEOFException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static enum UnknownNumberParsing {
        LONG_AND_BIGDECIMAL,
        LONG_AND_DOUBLE,
        BIGDECIMAL,
        DOUBLE;

    }

    public static enum DoublePrecision {
        EXACT(0),
        HIGH(1),
        DEFAULT(3),
        LOW(4);

        final int level;

        private DoublePrecision(int level) {
            this.level = level;
        }
    }

    public static enum ErrorInfo {
        WITH_STACK_TRACE,
        DESCRIPTION_AND_POSITION,
        DESCRIPTION_ONLY,
        MINIMAL;

    }
}

