/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.util.JsonReader;
import com.bugsnag.android.DeviceId;
import com.bugsnag.android.DeviceIdPersistence;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.SynchronizedStreamableStore;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bugsnag/android/DeviceIdFilePersistence;", "Lcom/bugsnag/android/DeviceIdPersistence;", "file", "Ljava/io/File;", "deviceIdGenerator", "Lkotlin/Function0;", "Ljava/util/UUID;", "logger", "Lcom/bugsnag/android/Logger;", "(Ljava/io/File;Lkotlin/jvm/functions/Function0;Lcom/bugsnag/android/Logger;)V", "synchronizedStreamableStore", "Lcom/bugsnag/android/SynchronizedStreamableStore;", "Lcom/bugsnag/android/DeviceId;", "loadDeviceId", "", "requestCreateIfDoesNotExist", "", "loadDeviceIdInternal", "persistNewDeviceIdWithLock", "channel", "Ljava/nio/channels/FileChannel;", "uuid", "persistNewDeviceUuid", "waitForFileLock", "Ljava/nio/channels/FileLock;", "Companion", "bugsnag-android-core_release"})
public final class DeviceIdFilePersistence
implements DeviceIdPersistence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private final Function0<UUID> deviceIdGenerator;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SynchronizedStreamableStore<DeviceId> synchronizedStreamableStore;
    private static final int MAX_FILE_LOCK_ATTEMPTS = 20;
    private static final long FILE_LOCK_WAIT_MS = 25L;

    public DeviceIdFilePersistence(@NotNull File file, @NotNull Function0<UUID> deviceIdGenerator, @NotNull Logger logger) {
        this.file = file;
        this.deviceIdGenerator = deviceIdGenerator;
        this.logger = logger;
        try {
            this.file.createNewFile();
        }
        catch (Throwable exc) {
            this.logger.w("Failed to created device ID file", exc);
        }
        this.synchronizedStreamableStore = new SynchronizedStreamableStore(this.file);
    }

    @Override
    @Nullable
    public String loadDeviceId(boolean requestCreateIfDoesNotExist) {
        String string;
        try {
            DeviceId deviceId;
            DeviceId deviceId2 = deviceId = this.loadDeviceIdInternal();
            if ((deviceId2 == null ? null : deviceId2.getId()) == null) {
                return requestCreateIfDoesNotExist ? this.persistNewDeviceUuid((UUID)this.deviceIdGenerator.invoke()) : null;
            }
            string = deviceId.getId();
        }
        catch (Throwable exc) {
            this.logger.w("Failed to load device ID", exc);
            string = null;
        }
        return string;
    }

    private final DeviceId loadDeviceIdInternal() {
        if (this.file.length() > 0L) {
            try {
                return this.synchronizedStreamableStore.load((Function1<JsonReader, DeviceId>)((Function1)new Function1<JsonReader, DeviceId>(DeviceId.Companion){

                    @NotNull
                    public final DeviceId invoke(@NotNull JsonReader p0) {
                        return ((DeviceId.Companion)this.receiver).fromReader(p0);
                    }
                }));
            }
            catch (Throwable exc) {
                this.logger.w("Failed to load device ID", exc);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String persistNewDeviceUuid(UUID uuid) {
        Object object;
        try {
            String string;
            object = this.file;
            boolean bl = false;
            object = new FileOutputStream((File)object).getChannel();
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileChannel channel = (FileChannel)object;
                boolean bl3 = false;
                string = this.persistNewDeviceIdWithLock(channel, uuid);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = string;
        }
        catch (IOException exc) {
            this.logger.w("Failed to persist device ID", exc);
            object = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String persistNewDeviceIdWithLock(FileChannel channel, UUID uuid) {
        Object object = this.waitForFileLock(channel);
        if (object == null) {
            return null;
        }
        FileLock lock = object;
        try {
            String string;
            DeviceId deviceId;
            DeviceId deviceId2 = deviceId = this.loadDeviceIdInternal();
            if ((deviceId2 == null ? null : deviceId2.getId()) != null) {
                string = deviceId.getId();
            } else {
                DeviceId newId = new DeviceId(uuid.toString());
                this.synchronizedStreamableStore.persist((DeviceId)((JsonStream.Streamable)newId));
                string = newId.getId();
            }
            object = string;
        }
        finally {
            lock.release();
        }
        return object;
    }

    private final FileLock waitForFileLock(FileChannel channel) {
        int n = 20;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            try {
                return channel.tryLock();
            }
            catch (OverlappingFileLockException exc) {
                Thread.sleep(25L);
            }
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/bugsnag/android/DeviceIdFilePersistence$Companion;", "", "()V", "FILE_LOCK_WAIT_MS", "", "MAX_FILE_LOCK_ATTEMPTS", "", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

