/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import com.brunomnsilva.smartgraph.graph.Edge;
import com.brunomnsilva.smartgraph.graphview.SmartArrow;
import com.brunomnsilva.smartgraph.graphview.SmartGraphEdgeBase;
import com.brunomnsilva.smartgraph.graphview.SmartGraphVertexNode;
import com.brunomnsilva.smartgraph.graphview.SmartLabel;
import com.brunomnsilva.smartgraph.graphview.SmartStylableNode;
import com.brunomnsilva.smartgraph.graphview.SmartStyleProxy;
import com.brunomnsilva.smartgraph.graphview.UtilitiesBindings;
import com.brunomnsilva.smartgraph.graphview.UtilitiesPoint2D;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.geometry.Point2D;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Translate;

public class SmartGraphEdgeCurve<E, V>
extends CubicCurve
implements SmartGraphEdgeBase<E, V> {
    private static final double MAX_EDGE_CURVE_ANGLE = 45.0;
    private static final double MIN_EDGE_CURVE_ANGLE = 3.0;
    public static final int DISTANCE_THRESHOLD = 400;
    public static final int LOOP_RADIUS_FACTOR = 4;
    private final Edge<E, V> underlyingEdge;
    private final SmartGraphVertexNode<V> inbound;
    private final SmartGraphVertexNode<V> outbound;
    private SmartLabel attachedLabel = null;
    private SmartArrow attachedArrow = null;
    private double randomAngleFactor;
    private final SmartStyleProxy styleProxy;

    public SmartGraphEdgeCurve(Edge<E, V> edge, SmartGraphVertexNode<V> inbound, SmartGraphVertexNode<V> outbound) {
        this(edge, inbound, outbound, 0);
    }

    public SmartGraphEdgeCurve(Edge<E, V> edge, SmartGraphVertexNode<V> inbound, SmartGraphVertexNode<V> outbound, int edgeIndex) {
        this.inbound = inbound;
        this.outbound = outbound;
        this.underlyingEdge = edge;
        this.styleProxy = new SmartStyleProxy((Shape)this);
        this.styleProxy.addStyleClass("edge");
        this.startXProperty().bind((ObservableValue)outbound.centerXProperty());
        this.startYProperty().bind((ObservableValue)outbound.centerYProperty());
        this.endXProperty().bind((ObservableValue)inbound.centerXProperty());
        this.endYProperty().bind((ObservableValue)inbound.centerYProperty());
        this.randomAngleFactor = edgeIndex == 0 ? 0.0 : 1.0 / (double)edgeIndex;
        this.enableListeners();
        this.propagateHoverEffectToArrow();
    }

    @Override
    public void setStyleInline(String css) {
        this.styleProxy.setStyleInline(css);
        if (this.attachedArrow != null) {
            this.attachedArrow.setStyleInline(css);
        }
    }

    @Override
    public void setStyleClass(String cssClass) {
        this.styleProxy.setStyleClass(cssClass);
        if (this.attachedArrow != null) {
            this.attachedArrow.setStyleClass(cssClass);
        }
    }

    @Override
    public void addStyleClass(String cssClass) {
        this.styleProxy.addStyleClass(cssClass);
        if (this.attachedArrow != null) {
            this.attachedArrow.addStyleClass(cssClass);
        }
    }

    @Override
    public boolean removeStyleClass(String cssClass) {
        boolean result = this.styleProxy.removeStyleClass(cssClass);
        if (this.attachedArrow != null) {
            this.attachedArrow.removeStyleClass(cssClass);
        }
        return result;
    }

    private void update() {
        if (this.inbound == this.outbound) {
            double midpointX1 = this.outbound.getCenterX() - this.inbound.getRadius() * 4.0;
            double midpointY1 = this.outbound.getCenterY() - this.inbound.getRadius() * 4.0;
            double midpointX2 = this.outbound.getCenterX() + this.inbound.getRadius() * 4.0;
            double midpointY2 = this.outbound.getCenterY() - this.inbound.getRadius() * 4.0;
            this.setControlX1(midpointX1);
            this.setControlY1(midpointY1);
            this.setControlX2(midpointX2);
            this.setControlY2(midpointY2);
        } else {
            Point2D startpoint = new Point2D(this.inbound.getCenterX(), this.inbound.getCenterY());
            Point2D endpoint = new Point2D(this.outbound.getCenterX(), this.outbound.getCenterY());
            double distance = startpoint.distance(endpoint);
            double angle = SmartGraphEdgeCurve.linearDecay(45.0, 3.0, distance, 400.0);
            Point2D midpoint = UtilitiesPoint2D.calculateTriangleBetween(startpoint, endpoint, -angle + this.randomAngleFactor * 2.0 * angle);
            this.setControlX1(midpoint.getX());
            this.setControlY1(midpoint.getY());
            this.setControlX2(midpoint.getX());
            this.setControlY2(midpoint.getY());
        }
    }

    private static double linearDecay(double initialValue, double finalValue, double distance, double distanceThreshold) {
        if (distance >= distanceThreshold) {
            return finalValue;
        }
        return initialValue + (finalValue - initialValue) * distance / distanceThreshold;
    }

    private void enableListeners() {
        this.startXProperty().addListener((ov, oldValue, newValue) -> this.update());
        this.startYProperty().addListener((ov, oldValue, newValue) -> this.update());
        this.endXProperty().addListener((ov, oldValue, newValue) -> this.update());
        this.endYProperty().addListener((ov, oldValue, newValue) -> this.update());
    }

    @Override
    public void attachLabel(SmartLabel label) {
        this.attachedLabel = label;
        label.xProperty().bind((ObservableValue)this.controlX1Property().add((ObservableNumberValue)this.controlX2Property()).divide(2).subtract((ObservableNumberValue)Bindings.divide((ObservableNumberValue)label.layoutWidthProperty(), (int)2)));
        label.yProperty().bind((ObservableValue)this.controlY1Property().add((ObservableNumberValue)this.controlY2Property()).divide(2).add((ObservableNumberValue)Bindings.divide((ObservableNumberValue)label.layoutHeightProperty(), (int)2)));
    }

    @Override
    public SmartLabel getAttachedLabel() {
        return this.attachedLabel;
    }

    @Override
    public Edge<E, V> getUnderlyingEdge() {
        return this.underlyingEdge;
    }

    @Override
    public void attachArrow(SmartArrow arrow) {
        this.attachedArrow = arrow;
        arrow.translateXProperty().bind((ObservableValue)this.endXProperty());
        arrow.translateYProperty().bind((ObservableValue)this.endYProperty());
        Rotate rotation = new Rotate();
        rotation.pivotXProperty().bind((ObservableValue)this.translateXProperty());
        rotation.pivotYProperty().bind((ObservableValue)this.translateYProperty());
        rotation.angleProperty().bind((ObservableValue)UtilitiesBindings.toDegrees((ObservableDoubleValue)UtilitiesBindings.atan2((ObservableDoubleValue)this.endYProperty().subtract((ObservableNumberValue)this.controlY2Property()), (ObservableDoubleValue)this.endXProperty().subtract((ObservableNumberValue)this.controlX2Property()))));
        arrow.getTransforms().add((Object)rotation);
        Translate t = new Translate(0.0, 0.0);
        t.xProperty().bind((ObservableValue)this.inbound.radiusProperty().negate());
        arrow.getTransforms().add((Object)t);
    }

    @Override
    public SmartArrow getAttachedArrow() {
        return this.attachedArrow;
    }

    @Override
    public SmartStylableNode getStylableArrow() {
        return this.attachedArrow;
    }

    @Override
    public SmartStylableNode getStylableLabel() {
        return this.attachedLabel;
    }

    private void propagateHoverEffectToArrow() {
        this.hoverProperty().addListener((observable, oldValue, newValue) -> {
            if (this.attachedArrow != null && newValue.booleanValue()) {
                this.attachedArrow.fireEvent((Event)new MouseEvent(MouseEvent.MOUSE_ENTERED, 0.0, 0.0, 0.0, 0.0, MouseButton.NONE, 0, true, true, true, true, true, true, true, true, true, true, null));
            } else if (this.attachedArrow != null) {
                this.attachedArrow.fireEvent((Event)new MouseEvent(MouseEvent.MOUSE_EXITED, 0.0, 0.0, 0.0, 0.0, MouseButton.NONE, 0, true, true, true, true, true, true, true, true, true, true, null));
            }
        });
    }
}

