/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.containers;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.shape.Rectangle;

public class ContentZoomPane
extends BorderPane {
    public static final double MIN_SCALE = 1.0;
    public static final double MAX_SCALE = 5.0;
    public static final double SCROLL_DELTA = 0.25;
    private final Node content;
    private final DoubleProperty scaleFactorProperty;
    private final double minScaleFactor;
    private final double maxScaleFactor;
    private final double deltaScaleFactor;

    public ContentZoomPane(Node content) {
        this(content, 1.0, 5.0, 0.25);
    }

    public ContentZoomPane(Node content, double minScaleFactor, double maxScaleFactor, double deltaScaleFactor) {
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null.");
        }
        if (minScaleFactor <= 0.0 || maxScaleFactor <= 0.0 || deltaScaleFactor <= 0.0) {
            throw new IllegalArgumentException("Scale factors must be >= 0.");
        }
        if (minScaleFactor >= maxScaleFactor) {
            throw new IllegalArgumentException("Requirement: minScaleFactor < maxScaleFactor.");
        }
        content.toFront();
        this.minScaleFactor = minScaleFactor;
        this.maxScaleFactor = maxScaleFactor;
        this.deltaScaleFactor = deltaScaleFactor;
        this.scaleFactorProperty = new ReadOnlyDoubleWrapper(minScaleFactor);
        this.content = content;
        this.setCenter(this.content);
        this.enablePanAndZoom();
        this.enableClipping();
    }

    public DoubleProperty scaleFactorProperty() {
        return this.scaleFactorProperty;
    }

    public double getMinScaleFactor() {
        return this.minScaleFactor;
    }

    public double getMaxScaleFactor() {
        return this.maxScaleFactor;
    }

    public double getDeltaScaleFactor() {
        return this.deltaScaleFactor;
    }

    private void enablePanAndZoom() {
        this.setOnScroll(event -> {
            double direction = event.getDeltaY() >= 0.0 ? 1.0 : -1.0;
            double currentScale = this.scaleFactorProperty.getValue();
            double computedScale = currentScale + direction * this.deltaScaleFactor;
            this.scaleContent(event.getX(), event.getY(), computedScale);
            event.consume();
        });
        DragContext sceneDragContext = new DragContext();
        this.setOnMousePressed(event -> {
            if (event.isSecondaryButtonDown()) {
                this.getScene().setCursor(Cursor.MOVE);
                sceneDragContext.mouseAnchorX = event.getX();
                sceneDragContext.mouseAnchorY = event.getY();
                sceneDragContext.translateAnchorX = this.content.getTranslateX();
                sceneDragContext.translateAnchorY = this.content.getTranslateY();
            }
        });
        this.setOnMouseReleased(event -> this.getScene().setCursor(Cursor.DEFAULT));
        this.setOnMouseDragged(event -> {
            if (event.isSecondaryButtonDown()) {
                double translateX = sceneDragContext.translateAnchorX + event.getX() - sceneDragContext.mouseAnchorX;
                double translateY = sceneDragContext.translateAnchorY + event.getY() - sceneDragContext.mouseAnchorY;
                this.translateContent(translateX, translateY);
            }
        });
    }

    private void scaleContent(double pivotX, double pivotY, double scaleFactor) {
        double computedScale;
        double currentScale = this.content.getScaleX();
        if (currentScale != (computedScale = ContentZoomPane.boundValue(scaleFactor, this.minScaleFactor, this.maxScaleFactor))) {
            if (computedScale == 1.0) {
                this.translateContent(0.0, 0.0);
                this.content.setScaleX(1.0);
                this.content.setScaleY(1.0);
            } else {
                this.content.setScaleX(computedScale);
                this.content.setScaleY(computedScale);
                Bounds bounds = this.content.getBoundsInParent();
                double f = computedScale / currentScale - 1.0;
                if (bounds.getMinX() > 0.0) {
                    pivotX = 0.0;
                }
                double dx = pivotX - (bounds.getWidth() / 2.0 + bounds.getMinX());
                double dy = pivotY - (bounds.getHeight() / 2.0 + bounds.getMinY());
                this.translateContent(this.content.getTranslateX() - f * dx, this.content.getTranslateY() - f * dy);
                System.out.println(this.content.getBoundsInParent());
            }
            this.scaleFactorProperty.setValue((Number)computedScale);
        }
    }

    private void translateContent(double translateX, double translateY) {
        if (this.content.getScaleX() == 1.0) {
            return;
        }
        this.content.setTranslateX(translateX);
        this.content.setTranslateY(translateY);
    }

    private void enableClipping() {
        Rectangle region = new Rectangle();
        this.widthProperty().addListener((observableValue, oldValue, newValue) -> {
            region.setWidth(newValue.doubleValue());
            this.setClip((Node)region);
        });
        this.heightProperty().addListener((observableValue, oldValue, newValue) -> {
            region.setHeight(newValue.doubleValue());
            this.setClip((Node)region);
        });
    }

    private static double boundValue(double value, double min, double max) {
        if (Double.compare(value, min) < 0) {
            return min;
        }
        if (Double.compare(value, max) > 0) {
            return max;
        }
        return value;
    }

    private static class DragContext {
        double mouseAnchorX;
        double mouseAnchorY;
        double translateAnchorX;
        double translateAnchorY;

        private DragContext() {
        }
    }
}

