/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.util;

import com.browserup.bup.mitm.exception.UncheckedIOException;
import com.google.common.io.CharStreams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class ClasspathResourceUtil {
    public static String classpathResourceToString(String resource, Charset charset) throws UncheckedIOException {
        String string;
        block11: {
            if (resource == null) {
                throw new IllegalArgumentException("Classpath resource to load cannot be null");
            }
            if (charset == null) {
                throw new IllegalArgumentException("Character set cannot be null");
            }
            InputStream resourceAsStream = ClasspathResourceUtil.class.getResourceAsStream(resource);
            try {
                if (resourceAsStream == null) {
                    throw new UncheckedIOException(new FileNotFoundException("Unable to locate classpath resource: " + resource));
                }
                InputStreamReader resourceReader = new InputStreamReader(resourceAsStream, charset);
                string = CharStreams.toString((Readable)resourceReader);
                if (resourceAsStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error occurred while reading classpath resource", e);
                }
            }
            resourceAsStream.close();
        }
        return string;
    }
}

