/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitm.trustmanager;

import io.netty.util.internal.EmptyArrays;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsecureExtendedTrustManager
extends X509ExtendedTrustManager {
    private static final Logger log = LoggerFactory.getLogger(InsecureExtendedTrustManager.class);
    private static final X509ExtendedTrustManager NOOP_EXTENDED_TRUST_MANAGER = new X509ExtendedTrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EmptyArrays.EMPTY_X509_CERTIFICATES;
        }
    };
    protected static final X509ExtendedTrustManager DEFAULT_EXTENDED_TRUST_MANAGER = InsecureExtendedTrustManager.getDefaultExtendedTrustManager();

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        try {
            DEFAULT_EXTENDED_TRUST_MANAGER.checkClientTrusted(x509Certificates, s, socket);
        }
        catch (CertificateException e) {
            log.debug("Accepting an untrusted client certificate: {}", (Object)x509Certificates[0].getSubjectDN(), (Object)e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        try {
            DEFAULT_EXTENDED_TRUST_MANAGER.checkServerTrusted(x509Certificates, s, socket);
        }
        catch (CertificateException e) {
            log.debug("Accepting an untrusted server certificate: {}", (Object)x509Certificates[0].getSubjectDN(), (Object)e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        try {
            DEFAULT_EXTENDED_TRUST_MANAGER.checkClientTrusted(x509Certificates, s, sslEngine);
        }
        catch (CertificateException e) {
            log.debug("Accepting an untrusted client certificate: {}", (Object)x509Certificates[0].getSubjectDN(), (Object)e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        try {
            DEFAULT_EXTENDED_TRUST_MANAGER.checkServerTrusted(x509Certificates, s, sslEngine);
        }
        catch (CertificateException e) {
            log.debug("Accepting an untrusted server certificate: {}", (Object)x509Certificates[0].getSubjectDN(), (Object)e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        try {
            DEFAULT_EXTENDED_TRUST_MANAGER.checkClientTrusted(x509Certificates, s);
        }
        catch (CertificateException e) {
            log.debug("Accepting an untrusted client certificate: {}", (Object)x509Certificates[0].getSubjectDN(), (Object)e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        try {
            DEFAULT_EXTENDED_TRUST_MANAGER.checkServerTrusted(x509Certificates, s);
        }
        catch (CertificateException e) {
            log.debug("Accepting an untrusted server certificate: {}", (Object)x509Certificates[0].getSubjectDN(), (Object)e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return EmptyArrays.EMPTY_X509_CERTIFICATES;
    }

    private static X509ExtendedTrustManager getDefaultExtendedTrustManager() {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            log.debug("Unable to initialize default TrustManagerFactory. Using no-op X509ExtendedTrustManager.", (Throwable)e);
            return NOOP_EXTENDED_TRUST_MANAGER;
        }
        for (TrustManager tm : trustManagerFactory.getTrustManagers()) {
            if (!(tm instanceof X509ExtendedTrustManager)) continue;
            return (X509ExtendedTrustManager)tm;
        }
        log.debug("No default X509ExtendedTrustManager found. Using no-op.");
        return NOOP_EXTENDED_TRUST_MANAGER;
    }
}

