/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.filters;

import com.browserup.bup.filters.HttpsAwareFiltersAdapter;
import com.browserup.bup.proxy.RewriteRule;
import com.browserup.bup.util.BrowserUpHttpUtil;
import com.browserup.bup.util.HttpUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteUrlFilter
extends HttpsAwareFiltersAdapter {
    private static final Logger log = LoggerFactory.getLogger(RewriteUrlFilter.class);
    private final Collection<RewriteRule> rewriteRules;

    public RewriteUrlFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, Collection<RewriteRule> rewriteRules) {
        super(originalRequest, ctx);
        this.rewriteRules = rewriteRules != null ? rewriteRules : Collections.emptyList();
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (httpObject instanceof HttpRequest) {
            String originalUrl;
            HttpRequest httpRequest = (HttpRequest)httpObject;
            if (ProxyUtils.isCONNECT((HttpObject)httpRequest)) {
                return null;
            }
            String rewrittenUrl = originalUrl = this.getFullUrl(httpRequest);
            boolean rewroteUri = false;
            for (RewriteRule rule : this.rewriteRules) {
                Matcher matcher = rule.getPattern().matcher(rewrittenUrl);
                if (!matcher.matches()) continue;
                rewrittenUrl = matcher.replaceAll(rule.getReplace());
                rewroteUri = true;
            }
            if (rewroteUri) {
                String uriFromRequest = httpRequest.uri();
                if (HttpUtil.startsWithHttpOrHttps((String)uriFromRequest)) {
                    httpRequest.setUri(rewrittenUrl);
                } else {
                    try {
                        String resource = BrowserUpHttpUtil.getRawPathAndParamsFromUri(rewrittenUrl);
                        httpRequest.setUri(resource);
                    }
                    catch (URISyntaxException e) {
                        log.warn("Unable to determine path from rewritten URL. Request URL will be set to the full rewritten URL instead of the resource's path.\n\tOriginal URL: {}\n\tRewritten URL: {}", new Object[]{originalUrl, rewrittenUrl, e});
                        httpRequest.setUri(rewrittenUrl);
                    }
                }
                String originalHostAndPort = null;
                try {
                    originalHostAndPort = HttpUtil.getHostAndPortFromUri((String)originalUrl);
                }
                catch (URISyntaxException e) {
                    log.warn("Unable to determine host and port from original URL. Host header will be set to rewritten URL's host and port.\n\tOriginal URL: {}\n\tRewritten URL: {}", new Object[]{originalUrl, rewrittenUrl, e});
                }
                String modifiedHostAndPort = null;
                try {
                    modifiedHostAndPort = HttpUtil.getHostAndPortFromUri((String)rewrittenUrl);
                }
                catch (URISyntaxException e) {
                    log.warn("Unable to determine host and port from rewritten URL. Host header will not be updated.\n\tOriginal URL: {}\n\tRewritten URL: {}", new Object[]{originalUrl, rewrittenUrl, e});
                }
                if (modifiedHostAndPort != null && !modifiedHostAndPort.equals(originalHostAndPort)) {
                    if (this.isHttps()) {
                        log.warn("Cannot rewrite the host or port of an HTTPS connection.\n\tHost and port from original request: {}\n\tRewritten host and port: {}", (Object)originalHostAndPort, (Object)modifiedHostAndPort);
                    } else if (httpRequest.headers().contains((CharSequence)HttpHeaderNames.HOST)) {
                        HttpHeaders.setHost((HttpMessage)httpRequest, (String)modifiedHostAndPort);
                    }
                }
            }
        }
        return null;
    }
}

