/*
 * Decompiled with CFR 0.152.
 */
package com.brianfromoregon;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.text.DecimalFormat;

public enum SubSecond {
    ns(1.0, "ns"),
    \u03bcs(0.001, "\u03bcs"),
    ms(1.0E-6, "ms"),
    s(1.0E-9, "s");

    public final double scalar;
    public final String name;

    private SubSecond(double scalar, String name) {
        this.scalar = scalar;
        this.name = name;
    }

    public double fromNanos(Number nanos) {
        return nanos.doubleValue() * this.scalar;
    }

    public String format(Number nanos, DecimalFormat fmt) {
        return fmt.format(this.fromNanos(nanos)) + this.name;
    }

    public String format(Number nanos) {
        return this.format(nanos, new DecimalFormat("0.0"));
    }

    public static SubSecond finestFor(Number nanos) {
        int n;
        double step = nanos.doubleValue();
        for (n = 0; step >= 1000.0 && n < 3; step /= 1000.0, ++n) {
        }
        switch (n) {
            case 0: {
                return ns;
            }
            case 1: {
                return \u03bcs;
            }
            case 2: {
                return ms;
            }
        }
        return s;
    }

    public static SubSecond finestFor(Iterable<? extends Number> nanos) {
        return (SubSecond)((Object)Ordering.natural().min(Iterables.transform(nanos, (Function)new Function<Number, SubSecond>(){

            public SubSecond apply(Number num) {
                return SubSecond.finestFor(num);
            }
        })));
    }
}

