/*
 * Decompiled with CFR 0.152.
 */
package com.brianfromoregon;

import com.google.caliper.Json;
import com.google.caliper.Result;
import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;

public class ResultUploader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String postResults(Result result, String postUrl, String apiKey, String proxyHostPort) {
        try {
            URL url = new URL(postUrl + apiKey + "/" + result.getRun().getBenchmarkName());
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection(this.getProxy(proxyHostPort));
            urlConnection.setDoOutput(true);
            String resultJson = Json.getGsonInstance().toJson((Object)result);
            urlConnection.getOutputStream().write(resultJson.getBytes());
            if (urlConnection.getResponseCode() == 200) {
                BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                try {
                    String string = in.readLine();
                    return string;
                }
                finally {
                    in.close();
                }
            }
            StringBuilder err = new StringBuilder();
            err.append("Posting to ").append(postUrl).append(" failed: ").append(urlConnection.getResponseMessage());
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    err.append("\n").append(line);
                }
                return err.toString();
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            return "Posting to " + postUrl + " failed.\n" + Throwables.getStackTraceAsString((Throwable)e);
        }
    }

    private Proxy getProxy(String proxyHostPort) {
        if (proxyHostPort == null || proxyHostPort.isEmpty()) {
            return Proxy.NO_PROXY;
        }
        String[] proxyHostAndPort = proxyHostPort.trim().split(":");
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostAndPort[0], Integer.parseInt(proxyHostAndPort[1])));
    }
}

