/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.widget;

import android.content.Context;
import android.widget.ImageView;
import android.widget.TextView;
import com.braze.models.cards.CaptionedImageCard;
import com.braze.models.cards.Card;
import com.braze.support.BrazeLogger;
import com.braze.ui.R;
import com.braze.ui.actions.IAction;
import com.braze.ui.feed.view.BaseFeedCardView;

public class CaptionedImageCardView
extends BaseFeedCardView<CaptionedImageCard> {
    private static final String TAG = BrazeLogger.getBrazeLogTag(CaptionedImageCardView.class);
    private final ImageView mImage = (ImageView)this.getProperViewFromInflatedStub(R.id.com_braze_captioned_image_card_imageview_stub);
    private final TextView mTitle;
    private final TextView mDescription;
    private final TextView mDomain;
    private IAction mCardAction;
    private float mAspectRatio = 1.3333334f;

    public CaptionedImageCardView(Context context) {
        this(context, null);
    }

    public CaptionedImageCardView(Context context, CaptionedImageCard card) {
        super(context);
        this.mImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mImage.setAdjustViewBounds(true);
        this.mTitle = (TextView)this.findViewById(R.id.com_braze_captioned_image_title);
        this.mDescription = (TextView)this.findViewById(R.id.com_braze_captioned_image_description);
        this.mDomain = (TextView)this.findViewById(R.id.com_braze_captioned_image_card_domain);
        if (card != null) {
            this.setCard(card);
        }
        this.setBackground(this.getResources().getDrawable(R.drawable.com_braze_card_background, null));
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.com_braze_captioned_image_card;
    }

    @Override
    public void onSetCard(CaptionedImageCard card) {
        this.mTitle.setText((CharSequence)card.getTitle());
        this.mDescription.setText((CharSequence)card.getDescription());
        this.setOptionalTextView(this.mDomain, card.getDomain());
        this.mCardAction = CaptionedImageCardView.getUriActionForCard((Card)card);
        this.setOnClickListener(view -> this.handleCardClick(this.applicationContext, (Card)card, this.mCardAction));
        this.mAspectRatio = card.getAspectRatio();
        this.setImageViewToUrl(this.mImage, card.getImageUrl(), this.mAspectRatio, (Card)card);
    }
}

