/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.listeners;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;

public class SwipeDismissTouchListener
implements View.OnTouchListener {
    private final int mSlop;
    private final int mMinFlingVelocity;
    private final int mMaxFlingVelocity;
    private final long mAnimationTime;
    private final View mView;
    private final DismissCallbacks mCallbacks;
    private int mViewWidth = 1;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private int mSwipingSlop;
    private final Object mToken;
    private VelocityTracker mVelocityTracker;
    private float mTranslationX;

    public SwipeDismissTouchListener(View view, Object token, DismissCallbacks callbacks) {
        ViewConfiguration vc = ViewConfiguration.get((Context)view.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity() * 16;
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = view.getContext().getResources().getInteger(0x10E0000);
        this.mView = view;
        this.mToken = token;
        this.mCallbacks = callbacks;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        motionEvent.offsetLocation(this.mTranslationX, 0.0f);
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mView.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.mDownX = motionEvent.getRawX();
                this.mDownY = motionEvent.getRawY();
                if (this.mCallbacks.canDismiss(this.mToken)) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(motionEvent);
                }
                return false;
            }
            case 1: {
                if (this.mVelocityTracker == null) break;
                float deltaX = motionEvent.getRawX() - this.mDownX;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float velocityX = this.mVelocityTracker.getXVelocity();
                float absVelocityX = Math.abs(velocityX);
                float absVelocityY = Math.abs(this.mVelocityTracker.getYVelocity());
                boolean dismiss = false;
                boolean dismissRight = false;
                if (Math.abs(deltaX) > (float)(this.mViewWidth / 2) && this.mSwiping) {
                    dismiss = true;
                    dismissRight = deltaX > 0.0f;
                } else if ((float)this.mMinFlingVelocity <= absVelocityX && absVelocityX <= (float)this.mMaxFlingVelocity && absVelocityY < absVelocityX && this.mSwiping) {
                    dismiss = velocityX < 0.0f == deltaX < 0.0f;
                    boolean bl = dismissRight = this.mVelocityTracker.getXVelocity() > 0.0f;
                }
                if (dismiss) {
                    this.mView.animate().translationX(dismissRight ? (float)this.mViewWidth : (float)(-this.mViewWidth)).alpha(0.0f).setDuration(this.mAnimationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SwipeDismissTouchListener.this.performDismiss();
                        }
                    });
                } else if (this.mSwiping) {
                    this.mView.animate().translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mTranslationX = 0.0f;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mSwiping = false;
                break;
            }
            case 3: {
                if (this.mVelocityTracker == null) break;
                this.mView.animate().translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mTranslationX = 0.0f;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mSwiping = false;
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.addMovement(motionEvent);
                float deltaX = motionEvent.getRawX() - this.mDownX;
                float deltaY = motionEvent.getRawY() - this.mDownY;
                if (Math.abs(deltaX) > (float)this.mSlop && Math.abs(deltaY) < Math.abs(deltaX) / 2.0f) {
                    this.mSwiping = true;
                    this.mSwipingSlop = deltaX > 0.0f ? this.mSlop : -this.mSlop;
                    this.mView.getParent().requestDisallowInterceptTouchEvent(true);
                    MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                    cancelEvent.setAction(3 | motionEvent.getActionIndex() << 8);
                    this.mView.onTouchEvent(cancelEvent);
                    cancelEvent.recycle();
                }
                if (!this.mSwiping) break;
                this.mTranslationX = deltaX;
                this.mView.setTranslationX(deltaX - (float)this.mSwipingSlop);
                return true;
            }
        }
        return false;
    }

    @TargetApi(value=12)
    public void performDismiss() {
        final ViewGroup.LayoutParams lp = this.mView.getLayoutParams();
        final int originalHeight = this.mView.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{originalHeight, 1}).setDuration(this.mAnimationTime);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SwipeDismissTouchListener.this.mCallbacks.onDismiss(SwipeDismissTouchListener.this.mView, SwipeDismissTouchListener.this.mToken);
                SwipeDismissTouchListener.this.mView.setAlpha(1.0f);
                SwipeDismissTouchListener.this.mView.setTranslationX(0.0f);
                lp.height = originalHeight;
                SwipeDismissTouchListener.this.mView.setLayoutParams(lp);
            }
        });
        animator.addUpdateListener(valueAnimator -> {
            lp.height = (Integer)valueAnimator.getAnimatedValue();
            this.mView.setLayoutParams(lp);
        });
        animator.start();
    }

    public static interface DismissCallbacks {
        public boolean canDismiss(Object var1);

        public void onDismiss(View var1, Object var2);
    }
}

