/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.WebhookNotification;
import com.braintreegateway.org.apache.commons.codec.binary.Base64;
import com.braintreegateway.util.Sha1Hasher;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

public class WebhookTestingGateway {
    private Configuration configuration;
    private String[][] TYPE_DATE = new String[][]{{"type", "date"}};
    private String[][] TYPE_DATE_TIME = new String[][]{{"type", "datetime"}};
    private String[][] TYPE_ARRAY = new String[][]{{"type", "array"}};
    private String[][] TYPE_SYMBOL = new String[][]{{"type", "symbol"}};
    private String[][] TYPE_BOOLEAN = new String[][]{{"type", "boolean"}};
    private String[][] NIL_TRUE = new String[][]{{"nil", "true"}};

    public WebhookTestingGateway(Configuration configuration) {
        this.configuration = configuration;
    }

    private String buildPayload(WebhookNotification.Kind kind, String id, String sourceMerchantId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String timestamp = dateFormat.format(new Date());
        String payload = "<notification>";
        payload = payload + "<timestamp type=\"datetime\">" + timestamp + "</timestamp>";
        payload = payload + "<kind>" + (Object)((Object)kind) + "</kind>";
        if (sourceMerchantId != null) {
            payload = payload + "<source-merchant-id>" + sourceMerchantId + "</source-merchant-id>";
        }
        payload = payload + "<subject>" + this.subjectXml(kind, id) + "</subject>";
        payload = payload + "</notification>";
        return Base64.encodeBase64String(payload.getBytes()).replace("\r", "");
    }

    private String publicKeySignaturePair(String stringToSign) {
        return String.format("%s|%s", this.configuration.getPublicKey(), new Sha1Hasher().hmacHash(this.configuration.getPrivateKey(), stringToSign));
    }

    public HashMap<String, String> sampleNotification(WebhookNotification.Kind kind, String id) {
        return this.sampleNotification(kind, id, null);
    }

    public HashMap<String, String> sampleNotification(WebhookNotification.Kind kind, String id, String sourceMerchantId) {
        HashMap<String, String> response = new HashMap<String, String>();
        String payload = this.buildPayload(kind, id, sourceMerchantId);
        response.put("bt_payload", payload);
        response.put("bt_signature", this.publicKeySignaturePair(payload));
        return response;
    }

    private String subjectXml(WebhookNotification.Kind kind, String id) {
        switch (kind) {
            case CHECK: {
                return this.checkXml();
            }
            case SUB_MERCHANT_ACCOUNT_APPROVED: {
                return this.merchantAccountXmlActive(id);
            }
            case SUB_MERCHANT_ACCOUNT_DECLINED: {
                return this.merchantAccountXmlDeclined(id);
            }
            case TRANSACTION_DISBURSED: {
                return this.transactionXml(id);
            }
            case TRANSACTION_SETTLED: {
                return this.transactionSettledXml(id);
            }
            case TRANSACTION_SETTLEMENT_DECLINED: {
                return this.transactionSettlementDeclinedXml(id);
            }
            case DISBURSEMENT: {
                return this.disbursementXml(id);
            }
            case DISPUTE_OPENED: {
                return this.disputeOpenedXml(id);
            }
            case DISPUTE_LOST: {
                return this.disputeLostXml(id);
            }
            case DISPUTE_WON: {
                return this.disputeWonXml(id);
            }
            case DISPUTE_ACCEPTED: {
                return this.disputeAcceptedXml(id);
            }
            case DISPUTE_DISPUTED: {
                return this.disputeDisputedXml(id);
            }
            case DISPUTE_EXPIRED: {
                return this.disputeExpiredXml(id);
            }
            case DISBURSEMENT_EXCEPTION: {
                return this.disbursementExceptionXml(id);
            }
            case PARTNER_MERCHANT_CONNECTED: {
                return this.partnerMerchantConnectedXml(id);
            }
            case PARTNER_MERCHANT_DISCONNECTED: {
                return this.partnerMerchantDisconnectedXml(id);
            }
            case PARTNER_MERCHANT_DECLINED: {
                return this.partnerMerchantDeclinedXml(id);
            }
            case OAUTH_ACCESS_REVOKED: {
                return this.oauthAccessRevokedXml(id);
            }
            case CONNECTED_MERCHANT_STATUS_TRANSITIONED: {
                return this.connectedMerchantStatusTransitionedXml(id);
            }
            case CONNECTED_MERCHANT_PAYPAL_STATUS_CHANGED: {
                return this.connectedMerchantPayPalStatusChangedXml(id);
            }
            case SUBSCRIPTION_CHARGED_SUCCESSFULLY: {
                return this.subscriptionChargedSuccessfullyXml(id);
            }
            case SUBSCRIPTION_CHARGED_UNSUCCESSFULLY: {
                return this.subscriptionChargedUnsuccessfullyXml(id);
            }
            case ACCOUNT_UPDATER_DAILY_REPORT: {
                return this.accountUpdaterDailyReportXml(id);
            }
            case GRANTOR_UPDATED_GRANTED_PAYMENT_METHOD: {
                return this.grantedPaymentInstrumentUpdateXml();
            }
            case RECIPIENT_UPDATED_GRANTED_PAYMENT_METHOD: {
                return this.grantedPaymentInstrumentUpdateXml();
            }
            case PAYMENT_METHOD_REVOKED_BY_CUSTOMER: {
                return this.paymentMethodRevokedByCustomerXml(id);
            }
            case LOCAL_PAYMENT_COMPLETED: {
                return this.localPaymentCompletedXml();
            }
        }
        return this.subscriptionXml(id);
    }

    private String merchantAccountXmlDeclined(String id) {
        return WebhookTestingGateway.node("api-error-response", WebhookTestingGateway.node("message", "Credit score is too low"), WebhookTestingGateway.node("errors", this.TYPE_ARRAY, WebhookTestingGateway.node("merchant-account", WebhookTestingGateway.node("errors", this.TYPE_ARRAY, WebhookTestingGateway.node("error", WebhookTestingGateway.node("code", "82621"), WebhookTestingGateway.node("message", "Credit score is too low"), WebhookTestingGateway.node("attribute", this.TYPE_SYMBOL, "base"))))), WebhookTestingGateway.node("merchant-account", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("status", "suspended"), WebhookTestingGateway.node("master-merchant-account", WebhookTestingGateway.node("id", "master_ma_for_" + id), WebhookTestingGateway.node("status", "suspended"))));
    }

    private String merchantAccountXmlActive(String id) {
        return WebhookTestingGateway.node("merchant-account", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("master-merchant-account", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("status", "active")), WebhookTestingGateway.node("status", "active"));
    }

    private String subscriptionXml(String id) {
        return WebhookTestingGateway.node("subscription", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("transactions", this.TYPE_ARRAY, new String[0]), WebhookTestingGateway.node("add_ons", this.TYPE_ARRAY, new String[0]), WebhookTestingGateway.node("discounts", this.TYPE_ARRAY, new String[0]));
    }

    private String subscriptionChargedSuccessfullyXml(String id) {
        return WebhookTestingGateway.node("subscription", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("add_ons", this.TYPE_ARRAY, new String[0]), WebhookTestingGateway.node("transactions", WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", "1"), WebhookTestingGateway.node("status", "submitted_for_settlement"), WebhookTestingGateway.node("amount", "49.99"), WebhookTestingGateway.node("billing", new String[0]), WebhookTestingGateway.node("credit-card", new String[0]), WebhookTestingGateway.node("customer", new String[0]), WebhookTestingGateway.node("descriptor", new String[0]), WebhookTestingGateway.node("shipping", new String[0]), WebhookTestingGateway.node("disbursement-details", this.TYPE_ARRAY, new String[0]), WebhookTestingGateway.node("subscription", new String[0]))), WebhookTestingGateway.node("discounts", this.TYPE_ARRAY, new String[0]));
    }

    private String subscriptionChargedUnsuccessfullyXml(String id) {
        return WebhookTestingGateway.node("subscription", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("add_ons", this.TYPE_ARRAY, new String[0]), WebhookTestingGateway.node("transactions", WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", "1"), WebhookTestingGateway.node("status", "failed"), WebhookTestingGateway.node("amount", "49.99"), WebhookTestingGateway.node("billing", new String[0]), WebhookTestingGateway.node("credit-card", new String[0]), WebhookTestingGateway.node("customer", new String[0]), WebhookTestingGateway.node("descriptor", new String[0]), WebhookTestingGateway.node("shipping", new String[0]), WebhookTestingGateway.node("disbursement-details", this.TYPE_ARRAY, new String[0]), WebhookTestingGateway.node("subscription", new String[0]))), WebhookTestingGateway.node("discounts", this.TYPE_ARRAY, new String[0]));
    }

    private String transactionXml(String id) {
        return WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "100"), WebhookTestingGateway.node("disbursement-details", WebhookTestingGateway.node("disbursement-date", this.TYPE_DATE, "2013-07-09")), WebhookTestingGateway.node("billing", new String[0]), WebhookTestingGateway.node("credit-card", new String[0]), WebhookTestingGateway.node("customer", new String[0]), WebhookTestingGateway.node("descriptor", new String[0]), WebhookTestingGateway.node("shipping", new String[0]), WebhookTestingGateway.node("subscription", new String[0]));
    }

    private String transactionSettledXml(String id) {
        return WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("status", "settled"), WebhookTestingGateway.node("amount", "100"), WebhookTestingGateway.node("us-bank-account", WebhookTestingGateway.node("routing-number", "123456789"), WebhookTestingGateway.node("last-4", "1234"), WebhookTestingGateway.node("account-type", "checking"), WebhookTestingGateway.node("account-holder-name", "Dan Schulman"), WebhookTestingGateway.node("ach-mandate", WebhookTestingGateway.node("text", "Sample ACH Mandate Text"), WebhookTestingGateway.node("accepted-at", "2017-01-17"))), WebhookTestingGateway.node("disbursement-details", new String[0]), WebhookTestingGateway.node("billing", new String[0]), WebhookTestingGateway.node("credit-card", new String[0]), WebhookTestingGateway.node("customer", new String[0]), WebhookTestingGateway.node("descriptor", new String[0]), WebhookTestingGateway.node("shipping", new String[0]), WebhookTestingGateway.node("subscription", new String[0]));
    }

    private String transactionSettlementDeclinedXml(String id) {
        return WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("status", "settlement_declined"), WebhookTestingGateway.node("amount", "100"), WebhookTestingGateway.node("us-bank-account", WebhookTestingGateway.node("routing-number", "123456789"), WebhookTestingGateway.node("last-4", "1234"), WebhookTestingGateway.node("account-type", "checking"), WebhookTestingGateway.node("account-holder-name", "Dan Schulman"), WebhookTestingGateway.node("ach-mandate", WebhookTestingGateway.node("text", "Sample ACH Mandate Text"), WebhookTestingGateway.node("accepted-at", "2017-01-17"))), WebhookTestingGateway.node("disbursement-details", new String[0]), WebhookTestingGateway.node("billing", new String[0]), WebhookTestingGateway.node("credit-card", new String[0]), WebhookTestingGateway.node("customer", new String[0]), WebhookTestingGateway.node("descriptor", new String[0]), WebhookTestingGateway.node("shipping", new String[0]), WebhookTestingGateway.node("subscription", new String[0]));
    }

    private String disputeOpenedXml(String id) {
        return WebhookTestingGateway.node("dispute", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00"), WebhookTestingGateway.node("amount-dispuated", "250.00"), WebhookTestingGateway.node("amount-won", "245.00"), WebhookTestingGateway.node("received-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("reply-by-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("date-opened", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("kind", "chargeback"), WebhookTestingGateway.node("currency-iso-code", "USD"), WebhookTestingGateway.node("status", "open"), WebhookTestingGateway.node("reason", "fraud"), WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00")));
    }

    private String disputeLostXml(String id) {
        return WebhookTestingGateway.node("dispute", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00"), WebhookTestingGateway.node("amount-dispuated", "250.00"), WebhookTestingGateway.node("amount-won", "245.00"), WebhookTestingGateway.node("received-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("reply-by-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("date-opened", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("kind", "chargeback"), WebhookTestingGateway.node("currency-iso-code", "USD"), WebhookTestingGateway.node("status", "lost"), WebhookTestingGateway.node("reason", "fraud"), WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00")));
    }

    private String disputeWonXml(String id) {
        return WebhookTestingGateway.node("dispute", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00"), WebhookTestingGateway.node("amount-dispuated", "250.00"), WebhookTestingGateway.node("amount-won", "245.00"), WebhookTestingGateway.node("received-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("reply-by-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("date-opened", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("date-won", this.TYPE_DATE, "2014-03-22"), WebhookTestingGateway.node("kind", "chargeback"), WebhookTestingGateway.node("currency-iso-code", "USD"), WebhookTestingGateway.node("status", "won"), WebhookTestingGateway.node("reason", "fraud"), WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00")));
    }

    private String disputeAcceptedXml(String id) {
        return WebhookTestingGateway.node("dispute", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00"), WebhookTestingGateway.node("amount-dispuated", "250.00"), WebhookTestingGateway.node("amount-won", "245.00"), WebhookTestingGateway.node("received-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("reply-by-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("date-opened", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("kind", "chargeback"), WebhookTestingGateway.node("currency-iso-code", "USD"), WebhookTestingGateway.node("status", "accepted"), WebhookTestingGateway.node("reason", "fraud"), WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00")));
    }

    private String disputeDisputedXml(String id) {
        return WebhookTestingGateway.node("dispute", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00"), WebhookTestingGateway.node("amount-dispuated", "250.00"), WebhookTestingGateway.node("amount-won", "245.00"), WebhookTestingGateway.node("received-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("reply-by-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("date-opened", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("kind", "chargeback"), WebhookTestingGateway.node("currency-iso-code", "USD"), WebhookTestingGateway.node("status", "disputed"), WebhookTestingGateway.node("reason", "fraud"), WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00")));
    }

    private String disputeExpiredXml(String id) {
        return WebhookTestingGateway.node("dispute", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00"), WebhookTestingGateway.node("amount-dispuated", "250.00"), WebhookTestingGateway.node("amount-won", "245.00"), WebhookTestingGateway.node("received-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("reply-by-date", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("date-opened", this.TYPE_DATE, "2014-03-21"), WebhookTestingGateway.node("kind", "chargeback"), WebhookTestingGateway.node("currency-iso-code", "USD"), WebhookTestingGateway.node("status", "expired"), WebhookTestingGateway.node("reason", "fraud"), WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "250.00")));
    }

    private String disbursementXml(String id) {
        return WebhookTestingGateway.node("disbursement", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("transaction-ids", this.TYPE_ARRAY, WebhookTestingGateway.node("item", "asdf"), WebhookTestingGateway.node("item", "qwer")), WebhookTestingGateway.node("success", this.TYPE_BOOLEAN, "true"), WebhookTestingGateway.node("retry", this.TYPE_BOOLEAN, "false"), WebhookTestingGateway.node("exception-message", this.NIL_TRUE, new String[0]), WebhookTestingGateway.node("amount", "100.00"), WebhookTestingGateway.node("disbursement-date", this.TYPE_DATE, "2014-02-10"), WebhookTestingGateway.node("follow-up-action", this.NIL_TRUE, new String[0]), WebhookTestingGateway.node("merchant-account", WebhookTestingGateway.node("id", "merchant_account_token"), WebhookTestingGateway.node("currency-iso-code", "USD"), WebhookTestingGateway.node("sub-merchant-account", this.TYPE_BOOLEAN, "false"), WebhookTestingGateway.node("status", "active")));
    }

    private String disbursementExceptionXml(String id) {
        return WebhookTestingGateway.node("disbursement", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("transaction-ids", this.TYPE_ARRAY, WebhookTestingGateway.node("item", "asdf"), WebhookTestingGateway.node("item", "qwer")), WebhookTestingGateway.node("success", this.TYPE_BOOLEAN, "false"), WebhookTestingGateway.node("retry", this.TYPE_BOOLEAN, "false"), WebhookTestingGateway.node("exception-message", "bank_rejected"), WebhookTestingGateway.node("amount", "100.00"), WebhookTestingGateway.node("disbursement-date", this.TYPE_DATE, "2014-02-10"), WebhookTestingGateway.node("follow-up-action", "update_account_information"), WebhookTestingGateway.node("merchant-account", WebhookTestingGateway.node("id", "merchant_account_token"), WebhookTestingGateway.node("currency-iso-code", "USD"), WebhookTestingGateway.node("sub-merchant-account", this.TYPE_BOOLEAN, "false"), WebhookTestingGateway.node("status", "active")));
    }

    private String partnerMerchantConnectedXml(String id) {
        return WebhookTestingGateway.node("partner-merchant", WebhookTestingGateway.node("partner-merchant-id", "abc123"), WebhookTestingGateway.node("merchant-public-id", "public_id"), WebhookTestingGateway.node("public-key", "public_key"), WebhookTestingGateway.node("private-key", "private_key"), WebhookTestingGateway.node("client-side-encryption-key", "cse_key"));
    }

    private String partnerMerchantDisconnectedXml(String id) {
        return WebhookTestingGateway.node("partner-merchant", WebhookTestingGateway.node("partner-merchant-id", "abc123"));
    }

    private String partnerMerchantDeclinedXml(String id) {
        return WebhookTestingGateway.node("partner-merchant", WebhookTestingGateway.node("partner-merchant-id", "abc123"));
    }

    private String oauthAccessRevokedXml(String id) {
        return WebhookTestingGateway.node("oauth-application-revocation", WebhookTestingGateway.node("merchant-id", id), WebhookTestingGateway.node("oauth-application-client-id", "oauth_application_client_id"));
    }

    private String connectedMerchantStatusTransitionedXml(String id) {
        return WebhookTestingGateway.node("connected-merchant-status-transitioned", WebhookTestingGateway.node("oauth-application-client-id", "oauth_application_client_id"), WebhookTestingGateway.node("merchant-public-id", id), WebhookTestingGateway.node("status", "new_status"));
    }

    private String connectedMerchantPayPalStatusChangedXml(String id) {
        return WebhookTestingGateway.node("connected-merchant-paypal-status-changed", WebhookTestingGateway.node("oauth-application-client-id", "oauth_application_client_id"), WebhookTestingGateway.node("merchant-public-id", id), WebhookTestingGateway.node("action", "link"));
    }

    private String accountUpdaterDailyReportXml(String id) {
        return WebhookTestingGateway.node("account-updater-daily-report", WebhookTestingGateway.node("report-url", "link-to-csv-report"), WebhookTestingGateway.node("report-date", this.TYPE_DATE, "2016-01-14"));
    }

    private String grantedPaymentInstrumentUpdateXml() {
        return WebhookTestingGateway.node("granted-payment-instrument-update", WebhookTestingGateway.node("grant-owner-merchant-id", "vczo7jqrpwrsi2px"), WebhookTestingGateway.node("grant-recipient-merchant-id", "cf0i8wgarszuy6hc"), WebhookTestingGateway.node("payment-method-nonce", WebhookTestingGateway.node("nonce", "ee257d98-de40-47e8-96b3-a6954ea7a9a4"), WebhookTestingGateway.node("consumed", this.TYPE_BOOLEAN, "false"), WebhookTestingGateway.node("locked", this.TYPE_BOOLEAN, "false")), WebhookTestingGateway.node("token", "abc123z"), WebhookTestingGateway.node("updated-fields", this.TYPE_ARRAY, WebhookTestingGateway.node("item", "expiration-month"), WebhookTestingGateway.node("item", "expiration-year")));
    }

    private String paymentMethodRevokedByCustomerXml(String id) {
        return WebhookTestingGateway.node("paypal-account", WebhookTestingGateway.node("billing-agreement-id", "a-billing-agreement-id"), WebhookTestingGateway.node("created-at", this.TYPE_DATE_TIME, "2019-01-01T12:00:00Z"), WebhookTestingGateway.node("customer-id", "a-customer-id"), WebhookTestingGateway.node("default", this.TYPE_BOOLEAN, "true"), WebhookTestingGateway.node("email", "name@email.com"), WebhookTestingGateway.node("global-id", "cGF5bWVudG1ldGhvZF9jaDZieXNz"), WebhookTestingGateway.node("image-url", "https://assets.braintreegateway.com/payment_method_logo/paypal.png?environment=test"), WebhookTestingGateway.node("token", id), WebhookTestingGateway.node("updated-at", this.TYPE_DATE_TIME, "2019-01-02T12:00:00Z"), WebhookTestingGateway.node("is-channel-initiated", this.NIL_TRUE, ""), WebhookTestingGateway.node("payer-id", "a-payer-id"), WebhookTestingGateway.node("payer-info", this.NIL_TRUE, ""), WebhookTestingGateway.node("limited-use-order-id", this.NIL_TRUE, ""), WebhookTestingGateway.node("revoked-at", this.TYPE_DATE_TIME, "2019-01-02T12:00:00Z"));
    }

    private String localPaymentCompletedXml() {
        return WebhookTestingGateway.node("local-payment", WebhookTestingGateway.node("payment-id", "a-payment-id"), WebhookTestingGateway.node("payer-id", "a-payer-id"), WebhookTestingGateway.node("payment-method-nonce", "ee257d98-de40-47e8-96b3-a6954ea7a9a4"), WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", "1"), WebhookTestingGateway.node("status", "authorizing"), WebhookTestingGateway.node("amount", "10.00"), WebhookTestingGateway.node("order-id", "order1234")));
    }

    private String checkXml() {
        return WebhookTestingGateway.node("check", this.TYPE_BOOLEAN, "true");
    }

    private static String node(String name, String ... contents) {
        return WebhookTestingGateway.node(name, (String[][])null, contents);
    }

    private static String node(String name, String[][] attributes, String ... contents) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('<').append(name);
        if (attributes != null) {
            for (String[] stringArray : attributes) {
                buffer.append(" ");
                buffer.append(stringArray[0]).append("=\"").append(stringArray[1]).append("\"");
            }
        }
        buffer.append('>');
        for (String[] stringArray : contents) {
            buffer.append((String)stringArray);
        }
        buffer.append("</").append(name).append('>');
        return buffer.toString();
    }
}

