/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.Request;
import com.braintreegateway.ThreeDSecureLookupAdditionalInformation;
import com.braintreegateway.exceptions.UnexpectedException;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ThreeDSecureLookupRequest
extends Request {
    private ThreeDSecureLookupAdditionalInformation additionalInformation;
    private String amount;
    private String nonce;
    private String authorizationFingerprint;
    private String dfReferenceId;
    private String braintreeLibraryVersion;
    private Map clientMetadata;
    private Boolean challengeRequested;

    public ThreeDSecureLookupRequest additionalInformation(ThreeDSecureLookupAdditionalInformation additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    public ThreeDSecureLookupRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    public ThreeDSecureLookupRequest clientData(String clientData) {
        Map jsonMap;
        try {
            jsonMap = JSON.std.mapFrom((Object)clientData);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.nonce = (String)jsonMap.get("nonce");
        this.authorizationFingerprint = (String)jsonMap.get("authorizationFingerprint");
        this.braintreeLibraryVersion = (String)jsonMap.get("braintreeLibraryVersion");
        this.dfReferenceId = (String)jsonMap.get("dfReferenceId");
        this.clientMetadata = (Map)jsonMap.get("clientMetadata");
        return this;
    }

    public ThreeDSecureLookupRequest challengeRequested(Boolean challengeRequested) {
        this.challengeRequested = challengeRequested;
        return this;
    }

    private ThreeDSecureLookupAdditionalInformation getAdditionalInformation() {
        return this.additionalInformation;
    }

    public String getNonce() {
        return this.nonce;
    }

    private String getAuthorizationFingerprint() {
        return this.authorizationFingerprint;
    }

    private String getBraintreeLibraryVersion() {
        return this.braintreeLibraryVersion;
    }

    private String getDfReferenceId() {
        return this.dfReferenceId;
    }

    public String getAmount() {
        return this.amount;
    }

    private Map getClientMetadata() {
        return this.clientMetadata;
    }

    private Boolean getChallengeRequested() {
        return this.challengeRequested;
    }

    public String toJSON() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        HashMap<String, String> metaMap = new HashMap<String, String>();
        Map<String, Object> additionalInfo = this.additionalInformation != null ? this.additionalInformation.toMap() : new HashMap<String, Object>();
        try {
            metaMap.put("platform", "java");
            metaMap.put("sdkVersion", Configuration.VERSION);
            metaMap.put("source", "http");
            jsonMap.put("authorizationFingerprint", this.getAuthorizationFingerprint());
            jsonMap.put("amount", this.getAmount());
            jsonMap.put("braintreeLibraryVersion", this.getBraintreeLibraryVersion());
            jsonMap.put("df_reference_id", this.getDfReferenceId());
            jsonMap.put("additional_info", additionalInfo);
            jsonMap.put("clientMetadata", this.getClientMetadata());
            jsonMap.put("_meta", metaMap);
            jsonMap.put("challengeRequested", this.getChallengeRequested());
            return JSON.std.asString(jsonMap);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }
}

