/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Address;
import com.braintreegateway.CreditCardVerification;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditCard
implements PaymentMethod {
    public static final String VALUE_YES = "Yes";
    public static final String VALUE_NO = "No";
    public static final String VALUE_UNKNOWN = "Unknown";
    private Address billingAddress;
    private String bin;
    private String cardholderName;
    private String cardType;
    private Calendar createdAt;
    private String customerId;
    private String customerLocation;
    private String expirationMonth;
    private String expirationYear;
    private boolean isDefault;
    private boolean isVenmoSdk;
    private boolean isExpired;
    private String imageUrl;
    private String last4;
    private String commercial;
    private String debit;
    private String durbinRegulated;
    private String healthcare;
    private String payroll;
    private String prepaid;
    private String productId;
    private String countryOfIssuance;
    private String issuingBank;
    private String uniqueNumberIdentifier;
    private List<Subscription> subscriptions;
    private String token;
    private Calendar updatedAt;
    private CreditCardVerification verification;

    public CreditCard(NodeWrapper node) {
        this.token = node.findString("token");
        this.createdAt = node.findDateTime("created-at");
        this.updatedAt = node.findDateTime("updated-at");
        this.bin = node.findString("bin");
        this.cardType = node.findString("card-type");
        this.cardholderName = node.findString("cardholder-name");
        this.customerId = node.findString("customer-id");
        this.customerLocation = node.findString("customer-location");
        this.expirationMonth = node.findString("expiration-month");
        this.expirationYear = node.findString("expiration-year");
        this.imageUrl = node.findString("image-url");
        this.isDefault = node.findBoolean("default");
        this.isVenmoSdk = node.findBoolean("venmo-sdk");
        this.isExpired = node.findBoolean("expired");
        this.last4 = node.findString("last-4");
        this.commercial = node.findString("commercial");
        this.debit = node.findString("debit");
        this.durbinRegulated = node.findString("durbin-regulated");
        this.healthcare = node.findString("healthcare");
        this.payroll = node.findString("payroll");
        this.prepaid = node.findString("prepaid");
        this.productId = node.findString("product-id");
        this.countryOfIssuance = node.findString("country-of-issuance");
        this.issuingBank = node.findString("issuing-bank");
        this.uniqueNumberIdentifier = node.findString("unique-number-identifier");
        NodeWrapper billingAddressResponse = node.findFirst("billing-address");
        if (billingAddressResponse != null) {
            this.billingAddress = new Address(billingAddressResponse);
        }
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
        List<NodeWrapper> verificationNodes = node.findAll("verifications/verification");
        this.verification = this.findNewestVerification(verificationNodes);
    }

    private CreditCardVerification findNewestVerification(List<NodeWrapper> verificationNodes) {
        if (verificationNodes.size() > 0) {
            Collections.sort(verificationNodes, new Comparator<NodeWrapper>(){

                @Override
                public int compare(NodeWrapper node1, NodeWrapper node2) {
                    Calendar createdAt1 = node1.findDateTime("created-at");
                    Calendar createdAt2 = node2.findDateTime("created-at");
                    return createdAt2.compareTo(createdAt1);
                }
            });
            return new CreditCardVerification(verificationNodes.get(0));
        }
        return null;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public String getBin() {
        return this.bin;
    }

    public String getCardholderName() {
        return this.cardholderName;
    }

    public String getCardType() {
        return this.cardType;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    public String getCustomerLocation() {
        return this.customerLocation;
    }

    public String getExpirationDate() {
        return this.expirationMonth + "/" + this.expirationYear;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getMaskedNumber() {
        return this.getBin() + "******" + this.getLast4();
    }

    public Commercial getCommercial() {
        if (this.commercial.equals(Commercial.YES.toString())) {
            return Commercial.YES;
        }
        if (this.commercial.equals(Commercial.NO.toString())) {
            return Commercial.NO;
        }
        return Commercial.UNKNOWN;
    }

    public Debit getDebit() {
        if (this.debit.equals(Debit.YES.toString())) {
            return Debit.YES;
        }
        if (this.debit.equals(Debit.NO.toString())) {
            return Debit.NO;
        }
        return Debit.UNKNOWN;
    }

    public DurbinRegulated getDurbinRegulated() {
        if (this.durbinRegulated.equals(DurbinRegulated.YES.toString())) {
            return DurbinRegulated.YES;
        }
        if (this.durbinRegulated.equals(DurbinRegulated.NO.toString())) {
            return DurbinRegulated.NO;
        }
        return DurbinRegulated.UNKNOWN;
    }

    public Healthcare getHealthcare() {
        if (this.healthcare.equals(Healthcare.YES.toString())) {
            return Healthcare.YES;
        }
        if (this.healthcare.equals(Healthcare.NO.toString())) {
            return Healthcare.NO;
        }
        return Healthcare.UNKNOWN;
    }

    public Payroll getPayroll() {
        if (this.payroll.equals(Payroll.YES.toString())) {
            return Payroll.YES;
        }
        if (this.payroll.equals(Payroll.NO.toString())) {
            return Payroll.NO;
        }
        return Payroll.UNKNOWN;
    }

    public Prepaid getPrepaid() {
        if (this.prepaid.equals(Prepaid.YES.toString())) {
            return Prepaid.YES;
        }
        if (this.prepaid.equals(Prepaid.NO.toString())) {
            return Prepaid.NO;
        }
        return Prepaid.UNKNOWN;
    }

    public String getProductId() {
        if (this.productId.equals("")) {
            return VALUE_UNKNOWN;
        }
        return this.productId;
    }

    public String getCountryOfIssuance() {
        if (this.countryOfIssuance.equals("")) {
            return VALUE_UNKNOWN;
        }
        return this.countryOfIssuance;
    }

    public String getIssuingBank() {
        if (this.issuingBank.equals("")) {
            return VALUE_UNKNOWN;
        }
        return this.issuingBank;
    }

    public String getUniqueNumberIdentifier() {
        return this.uniqueNumberIdentifier;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isVenmoSdk() {
        return this.isVenmoSdk;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public CreditCardVerification getVerification() {
        return this.verification;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Prepaid {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private Prepaid(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Payroll {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private Payroll(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Healthcare {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private Healthcare(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DurbinRegulated {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private DurbinRegulated(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Debit {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private Debit(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Commercial {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private Commercial(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CustomerLocation {
        INTERNATIONAL("international"),
        US("us");

        private final String name;

        private CustomerLocation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CardType {
        AMEX("American Express"),
        CARTE_BLANCHE("Carte Blanche"),
        CHINA_UNION_PAY("China UnionPay"),
        DINERS_CLUB_INTERNATIONAL("Diners Club"),
        DISCOVER("Discover"),
        JCB("JCB"),
        LASER("Laser"),
        UK_MAESTRO("UK Maestro"),
        MAESTRO("Maestro"),
        MASTER_CARD("MasterCard"),
        SOLO("Solo"),
        SWITCH("Switch"),
        VISA("Visa");

        private final String name;

        private CardType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

