/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.CreditCardAddressRequest;
import com.braintreegateway.CreditCardOptionsRequest;
import com.braintreegateway.CustomerRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.TransparentRedirectGateway;

public class CreditCardRequest
extends Request {
    private CreditCardAddressRequest billingAddressRequest;
    private String billingAddressId;
    private String deviceData;
    private String cardholderName;
    private String customerId;
    private String cvv;
    private String deviceSessionId;
    private String expirationDate;
    private String expirationMonth;
    private String expirationYear;
    private String number;
    private CreditCardOptionsRequest optionsRequest;
    private CustomerRequest parent;
    private String token;
    private String paymentMethodToken;
    private String venmoSdkPaymentMethodCode;

    public CreditCardRequest() {
    }

    public CreditCardRequest(CustomerRequest parent) {
        this.parent = parent;
    }

    public CreditCardAddressRequest billingAddress() {
        this.billingAddressRequest = new CreditCardAddressRequest(this);
        return this.billingAddressRequest;
    }

    public CreditCardRequest billingAddressId(String billingAddressId) {
        this.billingAddressId = billingAddressId;
        return this;
    }

    public CreditCardRequest deviceData(String deviceData) {
        this.deviceData = deviceData;
        return this;
    }

    public CreditCardRequest cardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
        return this;
    }

    public CreditCardRequest customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public CreditCardRequest cvv(String cvv) {
        this.cvv = cvv;
        return this;
    }

    public CreditCardRequest deviceSessionId(String deviceSessionId) {
        this.deviceSessionId = deviceSessionId;
        return this;
    }

    public CustomerRequest done() {
        return this.parent;
    }

    public CreditCardRequest expirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    public CreditCardRequest expirationMonth(String expirationMonth) {
        this.expirationMonth = expirationMonth;
        return this;
    }

    public CreditCardRequest expirationYear(String expirationYear) {
        this.expirationYear = expirationYear;
        return this;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getKind() {
        if (this.paymentMethodToken == null) {
            return TransparentRedirectGateway.CREATE_PAYMENT_METHOD;
        }
        return TransparentRedirectGateway.UPDATE_PAYMENT_METHOD;
    }

    public String getToken() {
        return this.token;
    }

    public CreditCardRequest number(String number) {
        this.number = number;
        return this;
    }

    public CreditCardRequest venmoSdkPaymentMethodCode(String venmoSdkPaymentMethodCode) {
        this.venmoSdkPaymentMethodCode = venmoSdkPaymentMethodCode;
        return this;
    }

    public CreditCardOptionsRequest options() {
        this.optionsRequest = new CreditCardOptionsRequest(this);
        return this.optionsRequest;
    }

    public CreditCardRequest paymentMethodToken(String paymentMethodToken) {
        this.paymentMethodToken = paymentMethodToken;
        return this;
    }

    public CreditCardRequest token(String token) {
        this.token = token;
        return this;
    }

    public String toXML() {
        return this.buildRequest("creditCard").toXML();
    }

    public String toQueryString() {
        return this.toQueryString("creditCard");
    }

    public String toQueryString(String root) {
        return this.buildRequest(root).addTopLevelElement("paymentMethodToken", this.paymentMethodToken).toQueryString();
    }

    protected RequestBuilder buildRequest(String root) {
        return new RequestBuilder(root).addElement("billingAddress", this.billingAddressRequest).addElement("billingAddressId", this.billingAddressId).addElement("deviceData", this.deviceData).addElement("options", this.optionsRequest).addElement("customerId", this.customerId).addElement("cardholderName", this.cardholderName).addElement("cvv", this.cvv).addElement("number", this.number).addElement("deviceSessionId", this.deviceSessionId).addElement("expirationDate", this.expirationDate).addElement("expirationMonth", this.expirationMonth).addElement("expirationYear", this.expirationYear).addElement("token", this.token).addElement("venmoSdkPaymentMethodCode", this.venmoSdkPaymentMethodCode);
    }
}

