/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AddOnGateway;
import com.braintreegateway.AddressGateway;
import com.braintreegateway.Configuration;
import com.braintreegateway.CreditCardGateway;
import com.braintreegateway.CreditCardVerificationGateway;
import com.braintreegateway.CustomerGateway;
import com.braintreegateway.DiscountGateway;
import com.braintreegateway.Environment;
import com.braintreegateway.PlanGateway;
import com.braintreegateway.Request;
import com.braintreegateway.SettlementBatchSummaryGateway;
import com.braintreegateway.SubscriptionGateway;
import com.braintreegateway.TransactionGateway;
import com.braintreegateway.TransparentRedirectGateway;
import com.braintreegateway.WebhookNotificationGateway;
import com.braintreegateway.WebhookTestingGateway;
import com.braintreegateway.org.apache.commons.codec.binary.Base64;
import com.braintreegateway.util.ClientLibraryProperties;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.TrUtil;

public class BraintreeGateway {
    public static final String VERSION = new ClientLibraryProperties().version();
    private Configuration configuration;
    private Environment environment;
    private Http http;
    private String merchantId;
    private String privateKey;
    private String publicKey;

    public BraintreeGateway(Environment environment, String merchantId, String publicKey, String privateKey) {
        this.environment = environment;
        this.merchantId = merchantId;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.configuration = new Configuration(this.baseMerchantURL(), publicKey, privateKey);
        this.http = new Http(this.getAuthorizationHeader(), this.baseMerchantURL(), environment.certificateFilenames, VERSION);
    }

    public AddOnGateway addOn() {
        return new AddOnGateway(this.http);
    }

    public AddressGateway address() {
        return new AddressGateway(this.http);
    }

    public String baseMerchantURL() {
        return this.environment.baseURL + "/merchants/" + this.merchantId;
    }

    public CreditCardGateway creditCard() {
        return new CreditCardGateway(this.http, this.configuration);
    }

    public CreditCardVerificationGateway creditCardVerification() {
        return new CreditCardVerificationGateway(this.http, this.configuration);
    }

    public CustomerGateway customer() {
        return new CustomerGateway(this.http, this.configuration);
    }

    public DiscountGateway discount() {
        return new DiscountGateway(this.http);
    }

    public String getAuthorizationHeader() {
        return "Basic " + Base64.encodeBase64String((this.publicKey + ":" + this.privateKey).getBytes()).trim();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public PlanGateway plan() {
        return new PlanGateway(this.http);
    }

    public SettlementBatchSummaryGateway settlementBatchSummary() {
        return new SettlementBatchSummaryGateway(this.http);
    }

    public SubscriptionGateway subscription() {
        return new SubscriptionGateway(this.http);
    }

    public TransactionGateway transaction() {
        return new TransactionGateway(this.http, this.configuration);
    }

    public TransparentRedirectGateway transparentRedirect() {
        return new TransparentRedirectGateway(this.http, this.configuration);
    }

    public String trData(Request trData, String redirectURL) {
        return new TrUtil(this.configuration).buildTrData(trData, redirectURL);
    }

    public WebhookNotificationGateway webhookNotification() {
        return new WebhookNotificationGateway(this.configuration);
    }

    public WebhookTestingGateway webhookTesting() {
        return new WebhookTestingGateway(this.configuration);
    }
}

