/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.models.BinData;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.braintreepayments.api.models.VisaCheckoutAddress;
import com.braintreepayments.api.models.VisaCheckoutUserData;
import org.json.JSONException;
import org.json.JSONObject;

public class VisaCheckoutNonce
extends PaymentMethodNonce
implements Parcelable {
    protected static final String TYPE = "VisaCheckoutCard";
    protected static final String API_RESOURCE_KEY = "visaCheckoutCards";
    private static final String CARD_DETAILS_KEY = "details";
    private static final String CARD_TYPE_KEY = "cardType";
    private static final String LAST_TWO_KEY = "lastTwo";
    private static final String BILLING_ADDRESS_KEY = "billingAddress";
    private static final String SHIPPING_ADDRESS_KEY = "shippingAddress";
    private static final String USER_DATA_KEY = "userData";
    private static final String CALL_ID_KEY = "callId";
    private String mLastTwo;
    private String mCardType;
    private VisaCheckoutAddress mBillingAddress;
    private VisaCheckoutAddress mShippingAddress;
    private VisaCheckoutUserData mUserData;
    private String mCallId;
    private BinData mBinData;
    public static final Parcelable.Creator<VisaCheckoutNonce> CREATOR = new Parcelable.Creator<VisaCheckoutNonce>(){

        public VisaCheckoutNonce createFromParcel(Parcel in) {
            return new VisaCheckoutNonce(in);
        }

        public VisaCheckoutNonce[] newArray(int size) {
            return new VisaCheckoutNonce[size];
        }
    };

    public static VisaCheckoutNonce fromJson(String json) throws JSONException {
        VisaCheckoutNonce visaCheckoutNonce = new VisaCheckoutNonce();
        visaCheckoutNonce.fromJson(PaymentMethodNonce.getJsonObjectForType(API_RESOURCE_KEY, new JSONObject(json)));
        return visaCheckoutNonce;
    }

    @Override
    protected void fromJson(JSONObject json) throws JSONException {
        super.fromJson(json);
        JSONObject details = json.getJSONObject(CARD_DETAILS_KEY);
        this.mLastTwo = details.getString(LAST_TWO_KEY);
        this.mCardType = details.getString(CARD_TYPE_KEY);
        this.mBillingAddress = VisaCheckoutAddress.fromJson(json.optJSONObject(BILLING_ADDRESS_KEY));
        this.mShippingAddress = VisaCheckoutAddress.fromJson(json.optJSONObject(SHIPPING_ADDRESS_KEY));
        this.mUserData = VisaCheckoutUserData.fromJson(json.optJSONObject(USER_DATA_KEY));
        this.mCallId = Json.optString((JSONObject)json, (String)CALL_ID_KEY, (String)"");
        this.mBinData = BinData.fromJson(json.optJSONObject("binData"));
    }

    public String getLastTwo() {
        return this.mLastTwo;
    }

    public String getCardType() {
        return this.mCardType;
    }

    public VisaCheckoutAddress getBillingAddress() {
        return this.mBillingAddress;
    }

    public VisaCheckoutAddress getShippingAddress() {
        return this.mShippingAddress;
    }

    public VisaCheckoutUserData getUserData() {
        return this.mUserData;
    }

    public String getCallId() {
        return this.mCallId;
    }

    @Override
    public String getTypeLabel() {
        return "Visa Checkout";
    }

    public BinData getBinData() {
        return this.mBinData;
    }

    public VisaCheckoutNonce() {
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mLastTwo);
        dest.writeString(this.mCardType);
        dest.writeParcelable((Parcelable)this.mBillingAddress, flags);
        dest.writeParcelable((Parcelable)this.mShippingAddress, flags);
        dest.writeParcelable((Parcelable)this.mUserData, flags);
        dest.writeString(this.mCallId);
        dest.writeParcelable((Parcelable)this.mBinData, flags);
    }

    protected VisaCheckoutNonce(Parcel in) {
        super(in);
        this.mLastTwo = in.readString();
        this.mCardType = in.readString();
        this.mBillingAddress = (VisaCheckoutAddress)in.readParcelable(VisaCheckoutAddress.class.getClassLoader());
        this.mShippingAddress = (VisaCheckoutAddress)in.readParcelable(VisaCheckoutAddress.class.getClassLoader());
        this.mUserData = (VisaCheckoutUserData)in.readParcelable(VisaCheckoutUserData.class.getClassLoader());
        this.mCallId = in.readString();
        this.mBinData = (BinData)in.readParcelable(BinData.class.getClassLoader());
    }
}

