/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.content.Context;
import android.text.TextUtils;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.Venmo;
import org.json.JSONObject;

public class VenmoConfiguration {
    private static final String ACCESS_TOKEN_KEY = "accessToken";
    private static final String ENVIRONMENT_KEY = "environment";
    private static final String MERCHANT_ID_KEY = "merchantId";
    private String mAccessToken;
    private String mEnvironment;
    private String mMerchantId;

    static VenmoConfiguration fromJson(JSONObject json) {
        if (json == null) {
            json = new JSONObject();
        }
        VenmoConfiguration venmoConfiguration = new VenmoConfiguration();
        venmoConfiguration.mAccessToken = Json.optString((JSONObject)json, (String)ACCESS_TOKEN_KEY, (String)"");
        venmoConfiguration.mEnvironment = Json.optString((JSONObject)json, (String)ENVIRONMENT_KEY, (String)"");
        venmoConfiguration.mMerchantId = Json.optString((JSONObject)json, (String)MERCHANT_ID_KEY, (String)"");
        return venmoConfiguration;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public String getMerchantId() {
        return this.mMerchantId;
    }

    public String getEnvironment() {
        return this.mEnvironment;
    }

    public boolean isEnabled(Context context) {
        return this.isAccessTokenValid() && Venmo.isVenmoInstalled(context);
    }

    public boolean isAccessTokenValid() {
        return !TextUtils.isEmpty((CharSequence)this.mAccessToken);
    }
}

