/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.braintreepayments.api.models.PaymentMethodNonce;
import org.json.JSONException;
import org.json.JSONObject;

public class VenmoAccountNonce
extends PaymentMethodNonce
implements Parcelable {
    protected static final String TYPE = "VenmoAccount";
    protected static final String API_RESOURCE_KEY = "venmoAccounts";
    private static final String VENMO_DETAILS_KEY = "details";
    private static final String VENMO_USERNAME_KEY = "username";
    private String mUsername;
    public static final Parcelable.Creator<VenmoAccountNonce> CREATOR = new Parcelable.Creator<VenmoAccountNonce>(){

        public VenmoAccountNonce createFromParcel(Parcel in) {
            return new VenmoAccountNonce(in);
        }

        public VenmoAccountNonce[] newArray(int size) {
            return new VenmoAccountNonce[size];
        }
    };

    public VenmoAccountNonce(String nonce, String description, String username) {
        this.mNonce = nonce;
        this.mDescription = description;
        this.mUsername = username;
    }

    public static VenmoAccountNonce fromJson(String json) throws JSONException {
        VenmoAccountNonce venmoAccountNonce = new VenmoAccountNonce();
        venmoAccountNonce.fromJson(VenmoAccountNonce.getJsonObjectForType(API_RESOURCE_KEY, new JSONObject(json)));
        return venmoAccountNonce;
    }

    @Override
    protected void fromJson(JSONObject json) throws JSONException {
        super.fromJson(json);
        JSONObject details = json.getJSONObject(VENMO_DETAILS_KEY);
        this.mDescription = this.mUsername = details.getString(VENMO_USERNAME_KEY);
    }

    public String getUsername() {
        return this.mUsername;
    }

    @Override
    public String getTypeLabel() {
        return "Venmo";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mUsername);
    }

    public VenmoAccountNonce() {
    }

    protected VenmoAccountNonce(Parcel in) {
        super(in);
        this.mUsername = in.readString();
    }
}

