/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.braintreepayments.api.models.BaseCardBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class UnionPayCardBuilder
extends BaseCardBuilder<UnionPayCardBuilder>
implements Parcelable {
    private static final String UNIONPAY_ENROLLMENT_KEY = "unionPayEnrollment";
    private static final String UNIONPAY_KEY = "creditCard";
    private static final String MOBILE_COUNTRY_CODE_KEY = "mobileCountryCode";
    private static final String MOBILE_PHONE_NUMBER_KEY = "mobileNumber";
    private static final String SMS_CODE_KEY = "smsCode";
    private static final String ENROLLMENT_ID_KEY = "id";
    private String mMobileCountryCode;
    private String mMobilePhoneNumber;
    private String mSmsCode;
    private String mEnrollmentId;
    public static final Parcelable.Creator<UnionPayCardBuilder> CREATOR = new Parcelable.Creator<UnionPayCardBuilder>(){

        public UnionPayCardBuilder createFromParcel(Parcel in) {
            return new UnionPayCardBuilder(in);
        }

        public UnionPayCardBuilder[] newArray(int size) {
            return new UnionPayCardBuilder[size];
        }
    };

    public UnionPayCardBuilder() {
    }

    public UnionPayCardBuilder mobileCountryCode(String mobileCountryCode) {
        this.mMobileCountryCode = TextUtils.isEmpty((CharSequence)mobileCountryCode) ? null : mobileCountryCode;
        return this;
    }

    public UnionPayCardBuilder mobilePhoneNumber(String mobilePhoneNumber) {
        this.mMobilePhoneNumber = TextUtils.isEmpty((CharSequence)mobilePhoneNumber) ? null : mobilePhoneNumber;
        return this;
    }

    public UnionPayCardBuilder smsCode(String smsCode) {
        this.mSmsCode = TextUtils.isEmpty((CharSequence)smsCode) ? null : smsCode;
        return this;
    }

    public UnionPayCardBuilder enrollmentId(String enrollmentId) {
        this.mEnrollmentId = TextUtils.isEmpty((CharSequence)enrollmentId) ? null : enrollmentId;
        return this;
    }

    @Override
    @Deprecated
    public UnionPayCardBuilder validate(boolean validate) {
        return this;
    }

    public JSONObject buildEnrollment() throws JSONException {
        JSONObject unionPayEnrollment = new JSONObject();
        unionPayEnrollment.put("number", (Object)this.mCardnumber);
        unionPayEnrollment.put("expirationMonth", (Object)this.mExpirationMonth);
        unionPayEnrollment.put("expirationYear", (Object)this.mExpirationYear);
        unionPayEnrollment.put(MOBILE_COUNTRY_CODE_KEY, (Object)this.mMobileCountryCode);
        unionPayEnrollment.put(MOBILE_PHONE_NUMBER_KEY, (Object)this.mMobilePhoneNumber);
        JSONObject payload = new JSONObject();
        payload.put(UNIONPAY_ENROLLMENT_KEY, (Object)unionPayEnrollment);
        return payload;
    }

    @Override
    protected void build(JSONObject json, JSONObject paymentMethodNonceJson) throws JSONException {
        super.build(json, paymentMethodNonceJson);
        JSONObject options = paymentMethodNonceJson.optJSONObject("options");
        if (options == null) {
            options = new JSONObject();
            paymentMethodNonceJson.put("options", (Object)options);
        }
        JSONObject unionPayEnrollment = new JSONObject();
        unionPayEnrollment.put(SMS_CODE_KEY, (Object)this.mSmsCode);
        unionPayEnrollment.put(ENROLLMENT_ID_KEY, (Object)this.mEnrollmentId);
        options.put(UNIONPAY_ENROLLMENT_KEY, (Object)unionPayEnrollment);
        json.put(UNIONPAY_KEY, (Object)paymentMethodNonceJson);
    }

    @Override
    protected void buildGraphQL(Context context, JSONObject base, JSONObject variables) {
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mMobileCountryCode);
        dest.writeString(this.mMobilePhoneNumber);
        dest.writeString(this.mSmsCode);
        dest.writeString(this.mEnrollmentId);
    }

    protected UnionPayCardBuilder(Parcel in) {
        super(in);
        this.mMobileCountryCode = in.readString();
        this.mMobilePhoneNumber = in.readString();
        this.mSmsCode = in.readString();
        this.mEnrollmentId = in.readString();
    }
}

