/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import org.json.JSONException;
import org.json.JSONObject;

public class UnionPayCapabilities
implements Parcelable {
    private static final String IS_UNIONPAY_KEY = "isUnionPay";
    private static final String IS_DEBIT_KEY = "isDebit";
    private static final String UNIONPAY_KEY = "unionPay";
    private static final String SUPPORTS_TWO_STEP_AUTH_AND_CAPTURE_KEY = "supportsTwoStepAuthAndCapture";
    private static final String IS_SUPPORTED_KEY = "isSupported";
    private boolean mIsUnionPay;
    private boolean mIsDebit;
    private boolean mSupportsTwoStepAuthAndCapture;
    private boolean mIsSupported;
    public static final Parcelable.Creator<UnionPayCapabilities> CREATOR = new Parcelable.Creator<UnionPayCapabilities>(){

        public UnionPayCapabilities createFromParcel(Parcel in) {
            return new UnionPayCapabilities(in);
        }

        public UnionPayCapabilities[] newArray(int size) {
            return new UnionPayCapabilities[size];
        }
    };

    @NonNull
    public static UnionPayCapabilities fromJson(@NonNull String jsonString) {
        UnionPayCapabilities unionPayCapabilities = new UnionPayCapabilities();
        try {
            JSONObject json = new JSONObject(jsonString);
            unionPayCapabilities.mIsUnionPay = json.optBoolean(IS_UNIONPAY_KEY);
            unionPayCapabilities.mIsDebit = json.optBoolean(IS_DEBIT_KEY);
            if (json.has(UNIONPAY_KEY)) {
                JSONObject unionPay = json.getJSONObject(UNIONPAY_KEY);
                unionPayCapabilities.mSupportsTwoStepAuthAndCapture = unionPay.optBoolean(SUPPORTS_TWO_STEP_AUTH_AND_CAPTURE_KEY);
                unionPayCapabilities.mIsSupported = unionPay.optBoolean(IS_SUPPORTED_KEY);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return unionPayCapabilities;
    }

    public boolean isUnionPay() {
        return this.mIsUnionPay;
    }

    public boolean isDebit() {
        return this.mIsDebit;
    }

    public boolean supportsTwoStepAuthAndCapture() {
        return this.mSupportsTwoStepAuthAndCapture;
    }

    public boolean isSupported() {
        return this.mIsSupported;
    }

    private UnionPayCapabilities() {
    }

    public int describeContents() {
        return 0;
    }

    public UnionPayCapabilities(Parcel in) {
        this.mIsUnionPay = in.readByte() > 0;
        this.mIsDebit = in.readByte() > 0;
        this.mSupportsTwoStepAuthAndCapture = in.readByte() > 0;
        this.mIsSupported = in.readByte() > 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.mIsUnionPay ? (byte)1 : 0);
        dest.writeByte(this.mIsDebit ? (byte)1 : 0);
        dest.writeByte(this.mSupportsTwoStepAuthAndCapture ? (byte)1 : 0);
        dest.writeByte(this.mIsSupported ? (byte)1 : 0);
    }
}

