/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import com.braintreepayments.api.models.CardNonce;
import com.braintreepayments.api.models.PayPalAccountNonce;
import com.braintreepayments.api.models.VenmoAccountNonce;
import com.braintreepayments.api.models.VisaCheckoutNonce;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PaymentMethodNonce
implements Parcelable {
    private static final String PAYMENT_METHOD_NONCE_COLLECTION_KEY = "paymentMethods";
    private static final String PAYMENT_METHOD_TYPE_KEY = "type";
    private static final String PAYMENT_METHOD_NONCE_KEY = "nonce";
    private static final String PAYMENT_METHOD_DEFAULT_KEY = "default";
    private static final String DESCRIPTION_KEY = "description";
    protected static final String DATA_KEY = "data";
    protected static final String TOKEN_KEY = "token";
    protected String mNonce;
    protected String mDescription;
    protected boolean mDefault;

    protected static JSONObject getJsonObjectForType(String apiResourceKey, JSONObject json) throws JSONException {
        return json.getJSONArray(apiResourceKey).getJSONObject(0);
    }

    @CallSuper
    protected void fromJson(JSONObject json) throws JSONException {
        this.mNonce = json.getString(PAYMENT_METHOD_NONCE_KEY);
        this.mDescription = json.getString(DESCRIPTION_KEY);
        this.mDefault = json.optBoolean(PAYMENT_METHOD_DEFAULT_KEY, false);
    }

    public String getNonce() {
        return this.mNonce;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean isDefault() {
        return this.mDefault;
    }

    public abstract String getTypeLabel();

    public static List<PaymentMethodNonce> parsePaymentMethodNonces(String jsonBody) throws JSONException {
        JSONArray paymentMethods = new JSONObject(jsonBody).getJSONArray(PAYMENT_METHOD_NONCE_COLLECTION_KEY);
        if (paymentMethods == null) {
            return Collections.emptyList();
        }
        ArrayList<PaymentMethodNonce> paymentMethodsNonces = new ArrayList<PaymentMethodNonce>();
        for (int i = 0; i < paymentMethods.length(); ++i) {
            JSONObject json = paymentMethods.getJSONObject(i);
            PaymentMethodNonce paymentMethodNonce = PaymentMethodNonce.parsePaymentMethodNonces(json, json.getString(PAYMENT_METHOD_TYPE_KEY));
            if (paymentMethodNonce == null) continue;
            paymentMethodsNonces.add(paymentMethodNonce);
        }
        return paymentMethodsNonces;
    }

    @Nullable
    public static PaymentMethodNonce parsePaymentMethodNonces(String json, String type) throws JSONException {
        return PaymentMethodNonce.parsePaymentMethodNonces(new JSONObject(json), type);
    }

    @Nullable
    public static PaymentMethodNonce parsePaymentMethodNonces(JSONObject json, String type) throws JSONException {
        switch (type) {
            case "CreditCard": {
                if (json.has("creditCards") || json.has(DATA_KEY)) {
                    return CardNonce.fromJson(json.toString());
                }
                CardNonce cardNonce = new CardNonce();
                cardNonce.fromJson(json);
                return cardNonce;
            }
            case "PayPalAccount": {
                if (json.has("paypalAccounts")) {
                    return PayPalAccountNonce.fromJson(json.toString());
                }
                PayPalAccountNonce payPalAccountNonce = new PayPalAccountNonce();
                payPalAccountNonce.fromJson(json);
                return payPalAccountNonce;
            }
            case "VenmoAccount": {
                if (json.has("venmoAccounts")) {
                    return VenmoAccountNonce.fromJson(json.toString());
                }
                VenmoAccountNonce venmoAccountNonce = new VenmoAccountNonce();
                venmoAccountNonce.fromJson(json);
                return venmoAccountNonce;
            }
            case "VisaCheckoutCard": {
                if (json.has("visaCheckoutCards")) {
                    return VisaCheckoutNonce.fromJson(json.toString());
                }
                VisaCheckoutNonce visaCheckoutNonce = new VisaCheckoutNonce();
                visaCheckoutNonce.fromJson(json);
                return visaCheckoutNonce;
            }
        }
        return null;
    }

    public PaymentMethodNonce() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mNonce);
        dest.writeString(this.mDescription);
        dest.writeByte(this.mDefault ? (byte)1 : 0);
    }

    protected PaymentMethodNonce(Parcel in) {
        this.mNonce = in.readString();
        this.mDescription = in.readString();
        this.mDefault = in.readByte() > 0;
    }
}

