/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.content.Context;
import android.os.Parcel;
import com.braintreepayments.api.exceptions.BraintreeException;
import com.braintreepayments.api.models.Authorization;
import com.braintreepayments.api.models.ClientToken;
import com.braintreepayments.api.models.MetadataBuilder;
import com.braintreepayments.api.models.TokenizationKey;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PaymentMethodBuilder<T> {
    protected static final String OPTIONS_KEY = "options";
    protected static final String OPERATION_NAME_KEY = "operationName";
    private static final String VALIDATE_KEY = "validate";
    private static final String GRAPHQL_CLIENT_SDK_METADATA_KEY = "clientSdkMetadata";
    private String mIntegration = this.getDefaultIntegration();
    private String mSource = this.getDefaultSource();
    private boolean mValidate;
    private boolean mValidateSet;
    private String mSessionId;

    public PaymentMethodBuilder() {
    }

    public T integration(String integration) {
        this.mIntegration = integration;
        return (T)this;
    }

    public T source(String source) {
        this.mSource = source;
        return (T)this;
    }

    public T validate(boolean validate) {
        this.mValidate = validate;
        this.mValidateSet = true;
        return (T)this;
    }

    public T setSessionId(String sessionId) {
        this.mSessionId = sessionId;
        return (T)this;
    }

    public String build() {
        JSONObject base = new JSONObject();
        JSONObject optionsJson = new JSONObject();
        JSONObject paymentMethodNonceJson = new JSONObject();
        try {
            base.put("_meta", (Object)new MetadataBuilder().sessionId(this.mSessionId).source(this.mSource).integration(this.mIntegration).build());
            if (this.mValidateSet) {
                optionsJson.put(VALIDATE_KEY, this.mValidate);
                paymentMethodNonceJson.put(OPTIONS_KEY, (Object)optionsJson);
            }
            this.build(base, paymentMethodNonceJson);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return base.toString();
    }

    public String buildGraphQL(Context context, Authorization authorization) throws BraintreeException {
        JSONObject base = new JSONObject();
        JSONObject input = new JSONObject();
        JSONObject variables = new JSONObject();
        try {
            base.put(GRAPHQL_CLIENT_SDK_METADATA_KEY, (Object)new MetadataBuilder().sessionId(this.mSessionId).source(this.mSource).integration(this.mIntegration).build());
            JSONObject optionsJson = new JSONObject();
            if (this.mValidateSet) {
                optionsJson.put(VALIDATE_KEY, this.mValidate);
            } else if (authorization instanceof ClientToken) {
                optionsJson.put(VALIDATE_KEY, true);
            } else if (authorization instanceof TokenizationKey) {
                optionsJson.put(VALIDATE_KEY, false);
            }
            input.put(OPTIONS_KEY, (Object)optionsJson);
            variables.put("input", (Object)input);
            this.buildGraphQL(context, base, variables);
            base.put("variables", (Object)variables);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return base.toString();
    }

    protected PaymentMethodBuilder(Parcel in) {
        this.mIntegration = in.readString();
        this.mSource = in.readString();
        this.mValidate = in.readByte() > 0;
        this.mValidateSet = in.readByte() > 0;
        this.mSessionId = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mIntegration);
        dest.writeString(this.mSource);
        dest.writeByte(this.mValidate ? (byte)1 : 0);
        dest.writeByte(this.mValidateSet ? (byte)1 : 0);
        dest.writeString(this.mSessionId);
    }

    protected String getDefaultSource() {
        return "form";
    }

    protected String getDefaultIntegration() {
        return "custom";
    }

    protected abstract void build(JSONObject var1, JSONObject var2) throws JSONException;

    protected abstract void buildGraphQL(Context var1, JSONObject var2, JSONObject var3) throws BraintreeException, JSONException;

    public abstract String getApiPath();

    public abstract String getResponsePaymentMethodType();
}

