/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Json;
import org.json.JSONObject;

public class PayPalCreditFinancingAmount
implements Parcelable {
    private static final String CURRENCY_KEY = "currency";
    private static final String VALUE_KEY = "value";
    private String mCurrency;
    private String mValue;
    public static final Parcelable.Creator<PayPalCreditFinancingAmount> CREATOR = new Parcelable.Creator<PayPalCreditFinancingAmount>(){

        public PayPalCreditFinancingAmount createFromParcel(Parcel source) {
            return new PayPalCreditFinancingAmount(source);
        }

        public PayPalCreditFinancingAmount[] newArray(int size) {
            return new PayPalCreditFinancingAmount[size];
        }
    };

    private PayPalCreditFinancingAmount() {
    }

    public static PayPalCreditFinancingAmount fromJson(JSONObject amount) {
        PayPalCreditFinancingAmount result = new PayPalCreditFinancingAmount();
        if (amount == null) {
            return result;
        }
        result.mCurrency = Json.optString((JSONObject)amount, (String)CURRENCY_KEY, null);
        result.mValue = Json.optString((JSONObject)amount, (String)VALUE_KEY, null);
        return result;
    }

    @Nullable
    public String getCurrency() {
        return this.mCurrency;
    }

    @Nullable
    public String getValue() {
        return this.mValue;
    }

    public String toString() {
        return String.format("%s %s", this.mValue, this.mCurrency);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mCurrency);
        dest.writeString(this.mValue);
    }

    private PayPalCreditFinancingAmount(Parcel in) {
        this.mCurrency = in.readString();
        this.mValue = in.readString();
    }
}

