/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.text.TextUtils;
import com.braintreepayments.api.Json;
import org.json.JSONObject;

public class PayPalConfiguration {
    private static final String DISPLAY_NAME_KEY = "displayName";
    private static final String CLIENT_ID_KEY = "clientId";
    private static final String PRIVACY_URL_KEY = "privacyUrl";
    private static final String USER_AGREEMENT_URL_KEY = "userAgreementUrl";
    private static final String DIRECT_BASE_URL_KEY = "directBaseUrl";
    private static final String ENVIRONMENT_KEY = "environment";
    private static final String TOUCH_DISABLED_KEY = "touchDisabled";
    private static final String CURRENCY_ISO_CODE_KEY = "currencyIsoCode";
    private String mDisplayName;
    private String mClientId;
    private String mPrivacyUrl;
    private String mUserAgreementUrl;
    private String mDirectBaseUrl;
    private String mEnvironment;
    private boolean mTouchDisabled;
    private String mCurrencyIsoCode;

    public static PayPalConfiguration fromJson(JSONObject json) {
        if (json == null) {
            json = new JSONObject();
        }
        PayPalConfiguration payPalConfiguration = new PayPalConfiguration();
        payPalConfiguration.mDisplayName = Json.optString((JSONObject)json, (String)DISPLAY_NAME_KEY, null);
        payPalConfiguration.mClientId = Json.optString((JSONObject)json, (String)CLIENT_ID_KEY, null);
        payPalConfiguration.mPrivacyUrl = Json.optString((JSONObject)json, (String)PRIVACY_URL_KEY, null);
        payPalConfiguration.mUserAgreementUrl = Json.optString((JSONObject)json, (String)USER_AGREEMENT_URL_KEY, null);
        payPalConfiguration.mDirectBaseUrl = Json.optString((JSONObject)json, (String)DIRECT_BASE_URL_KEY, null);
        payPalConfiguration.mEnvironment = Json.optString((JSONObject)json, (String)ENVIRONMENT_KEY, null);
        payPalConfiguration.mTouchDisabled = json.optBoolean(TOUCH_DISABLED_KEY, true);
        payPalConfiguration.mCurrencyIsoCode = Json.optString((JSONObject)json, (String)CURRENCY_ISO_CODE_KEY, null);
        return payPalConfiguration;
    }

    @Deprecated
    public boolean isEnabled() {
        boolean enabled;
        boolean bl = enabled = !TextUtils.isEmpty((CharSequence)this.mEnvironment) && !TextUtils.isEmpty((CharSequence)this.mDisplayName) && !TextUtils.isEmpty((CharSequence)this.mPrivacyUrl) && !TextUtils.isEmpty((CharSequence)this.mUserAgreementUrl);
        if (!"offline".equals(this.mEnvironment)) {
            enabled = enabled && !TextUtils.isEmpty((CharSequence)this.mClientId);
        }
        return enabled;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getPrivacyUrl() {
        return this.mPrivacyUrl;
    }

    public String getUserAgreementUrl() {
        return this.mUserAgreementUrl;
    }

    public String getDirectBaseUrl() {
        return TextUtils.isEmpty((CharSequence)this.mDirectBaseUrl) ? null : this.mDirectBaseUrl + "/v1/";
    }

    public String getEnvironment() {
        return this.mEnvironment;
    }

    public boolean isTouchDisabled() {
        return this.mTouchDisabled;
    }

    public String getCurrencyIsoCode() {
        return this.mCurrencyIsoCode;
    }
}

