/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.models.PayPalCreditFinancing;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.braintreepayments.api.models.PostalAddress;
import com.braintreepayments.api.models.PostalAddressParser;
import org.json.JSONException;
import org.json.JSONObject;

public class PayPalAccountNonce
extends PaymentMethodNonce
implements Parcelable {
    protected static final String TYPE = "PayPalAccount";
    protected static final String API_RESOURCE_KEY = "paypalAccounts";
    protected static final String PAYMENT_METHOD_DATA_KEY = "paymentMethodData";
    protected static final String TOKENIZATION_DATA_KEY = "tokenizationData";
    protected static final String TOKEN_KEY = "token";
    private static final String CREDIT_FINANCING_KEY = "creditFinancingOffered";
    private static final String DETAILS_KEY = "details";
    private static final String EMAIL_KEY = "email";
    private static final String PAYER_INFO_KEY = "payerInfo";
    private static final String ACCOUNT_ADDRESS_KEY = "accountAddress";
    private static final String SHIPPING_ADDRESS_KEY = "shippingAddress";
    private static final String BILLING_ADDRESS_KEY = "billingAddress";
    private static final String FIRST_NAME_KEY = "firstName";
    private static final String LAST_NAME_KEY = "lastName";
    private static final String PHONE_KEY = "phone";
    private static final String PAYER_ID_KEY = "payerId";
    private static final String CLIENT_METADATA_ID_KEY = "correlationId";
    private String mClientMetadataId;
    private PostalAddress mBillingAddress;
    private PostalAddress mShippingAddress;
    private String mFirstName;
    private String mLastName;
    private String mPhone;
    private String mEmail;
    private String mPayerId;
    private PayPalCreditFinancing mCreditFinancing;
    private String mAuthenticateUrl;
    public static final Parcelable.Creator<PayPalAccountNonce> CREATOR = new Parcelable.Creator<PayPalAccountNonce>(){

        public PayPalAccountNonce createFromParcel(Parcel source) {
            return new PayPalAccountNonce(source);
        }

        public PayPalAccountNonce[] newArray(int size) {
            return new PayPalAccountNonce[size];
        }
    };

    public static PayPalAccountNonce fromJson(String jsonString) throws JSONException {
        JSONObject jsonObj = new JSONObject(jsonString);
        PayPalAccountNonce payPalAccountNonce = new PayPalAccountNonce();
        if (jsonObj.has(API_RESOURCE_KEY)) {
            payPalAccountNonce.fromJson(PayPalAccountNonce.getJsonObjectForType(API_RESOURCE_KEY, jsonObj));
        } else if (jsonObj.has(PAYMENT_METHOD_DATA_KEY)) {
            JSONObject tokenObj = new JSONObject(new JSONObject(jsonString).getJSONObject(PAYMENT_METHOD_DATA_KEY).getJSONObject(TOKENIZATION_DATA_KEY).getString(TOKEN_KEY));
            payPalAccountNonce.fromJson(PayPalAccountNonce.getJsonObjectForType(API_RESOURCE_KEY, tokenObj));
            JSONObject shippingAddress = jsonObj.optJSONObject(SHIPPING_ADDRESS_KEY);
            if (shippingAddress != null) {
                payPalAccountNonce.mShippingAddress = PostalAddressParser.fromJson(shippingAddress);
            }
        } else {
            throw new JSONException("Could not parse JSON for a payment method nonce");
        }
        return payPalAccountNonce;
    }

    @Override
    protected void fromJson(JSONObject json) throws JSONException {
        super.fromJson(json);
        this.mAuthenticateUrl = Json.optString((JSONObject)json, (String)"authenticateUrl", null);
        JSONObject details = json.getJSONObject(DETAILS_KEY);
        this.mEmail = Json.optString((JSONObject)details, (String)EMAIL_KEY, null);
        this.mClientMetadataId = Json.optString((JSONObject)details, (String)CLIENT_METADATA_ID_KEY, null);
        try {
            if (details.has(CREDIT_FINANCING_KEY)) {
                JSONObject creditFinancing = details.getJSONObject(CREDIT_FINANCING_KEY);
                this.mCreditFinancing = PayPalCreditFinancing.fromJson(creditFinancing);
            }
            JSONObject payerInfo = details.getJSONObject(PAYER_INFO_KEY);
            JSONObject billingAddress = payerInfo.optJSONObject(BILLING_ADDRESS_KEY);
            if (payerInfo.has(ACCOUNT_ADDRESS_KEY)) {
                billingAddress = payerInfo.optJSONObject(ACCOUNT_ADDRESS_KEY);
            }
            this.mShippingAddress = PostalAddressParser.fromJson(payerInfo.optJSONObject(SHIPPING_ADDRESS_KEY));
            this.mBillingAddress = PostalAddressParser.fromJson(billingAddress);
            this.mFirstName = Json.optString((JSONObject)payerInfo, (String)FIRST_NAME_KEY, (String)"");
            this.mLastName = Json.optString((JSONObject)payerInfo, (String)LAST_NAME_KEY, (String)"");
            this.mPhone = Json.optString((JSONObject)payerInfo, (String)PHONE_KEY, (String)"");
            this.mPayerId = Json.optString((JSONObject)payerInfo, (String)PAYER_ID_KEY, (String)"");
            if (this.mEmail == null) {
                this.mEmail = Json.optString((JSONObject)payerInfo, (String)EMAIL_KEY, null);
            }
        }
        catch (JSONException e) {
            this.mBillingAddress = new PostalAddress();
            this.mShippingAddress = new PostalAddress();
        }
    }

    public String getEmail() {
        return this.mEmail;
    }

    @Override
    public String getDescription() {
        if (TextUtils.equals((CharSequence)super.getDescription(), (CharSequence)"PayPal") && !TextUtils.isEmpty((CharSequence)this.getEmail())) {
            return this.getEmail();
        }
        return super.getDescription();
    }

    @Override
    public String getTypeLabel() {
        return "PayPal";
    }

    public PostalAddress getBillingAddress() {
        return this.mBillingAddress;
    }

    public PostalAddress getShippingAddress() {
        return this.mShippingAddress;
    }

    public String getFirstName() {
        return this.mFirstName;
    }

    public String getLastName() {
        return this.mLastName;
    }

    public String getPhone() {
        return this.mPhone;
    }

    public String getClientMetadataId() {
        return this.mClientMetadataId;
    }

    public String getPayerId() {
        return this.mPayerId;
    }

    public boolean isTwoFactorAuthRequired() {
        return this.mAuthenticateUrl != null;
    }

    @Nullable
    public PayPalCreditFinancing getCreditFinancing() {
        return this.mCreditFinancing;
    }

    @Nullable
    public String getAuthenticateUrl() {
        return this.mAuthenticateUrl;
    }

    public PayPalAccountNonce() {
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mClientMetadataId);
        dest.writeParcelable((Parcelable)this.mBillingAddress, flags);
        dest.writeParcelable((Parcelable)this.mShippingAddress, flags);
        dest.writeString(this.mFirstName);
        dest.writeString(this.mLastName);
        dest.writeString(this.mEmail);
        dest.writeString(this.mPhone);
        dest.writeString(this.mPayerId);
        dest.writeParcelable((Parcelable)this.mCreditFinancing, flags);
        dest.writeString(this.mAuthenticateUrl);
    }

    private PayPalAccountNonce(Parcel in) {
        super(in);
        this.mClientMetadataId = in.readString();
        this.mBillingAddress = (PostalAddress)in.readParcelable(PostalAddress.class.getClassLoader());
        this.mShippingAddress = (PostalAddress)in.readParcelable(PostalAddress.class.getClassLoader());
        this.mFirstName = in.readString();
        this.mLastName = in.readString();
        this.mEmail = in.readString();
        this.mPhone = in.readString();
        this.mPayerId = in.readString();
        this.mCreditFinancing = (PayPalCreditFinancing)in.readParcelable(PayPalCreditFinancing.class.getClassLoader());
        this.mAuthenticateUrl = in.readString();
    }
}

