/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.braintreepayments.api.exceptions.InvalidArgumentException;
import com.braintreepayments.api.models.Authorization;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientToken
extends Authorization {
    protected static final String BASE_64_MATCHER = "([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)";
    private static final String CONFIG_URL_KEY = "configUrl";
    private static final String AUTHORIZATION_FINGERPRINT_KEY = "authorizationFingerprint";
    private String mConfigUrl;
    private String mAuthorizationFingerprint;
    public static final Parcelable.Creator<ClientToken> CREATOR = new Parcelable.Creator<ClientToken>(){

        public ClientToken createFromParcel(Parcel source) {
            return new ClientToken(source);
        }

        public ClientToken[] newArray(int size) {
            return new ClientToken[size];
        }
    };

    ClientToken(String clientTokenString) throws InvalidArgumentException {
        super(clientTokenString);
        try {
            clientTokenString = new String(Base64.decode((String)clientTokenString, (int)0));
            JSONObject jsonObject = new JSONObject(clientTokenString);
            this.mConfigUrl = jsonObject.getString(CONFIG_URL_KEY);
            this.mAuthorizationFingerprint = jsonObject.getString(AUTHORIZATION_FINGERPRINT_KEY);
        }
        catch (NullPointerException | JSONException e) {
            throw new InvalidArgumentException("Client token was invalid");
        }
    }

    @Override
    public String getConfigUrl() {
        return this.mConfigUrl;
    }

    @Override
    public String getBearer() {
        return this.mAuthorizationFingerprint;
    }

    public String getAuthorizationFingerprint() {
        return this.mAuthorizationFingerprint;
    }

    public String getCustomerId() {
        String[] components;
        String authorizationFingerprint = this.getAuthorizationFingerprint();
        for (String component : components = authorizationFingerprint.split("&")) {
            String[] customerComponents;
            if (!component.contains("customer_id=") || (customerComponents = component.split("=")).length <= 1) continue;
            return customerComponents[1];
        }
        return null;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mConfigUrl);
        dest.writeString(this.mAuthorizationFingerprint);
    }

    protected ClientToken(Parcel in) {
        super(in);
        this.mConfigUrl = in.readString();
        this.mAuthorizationFingerprint = in.readString();
    }
}

