/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.braintreepayments.api.Json;
import org.json.JSONObject;

public class BinData
implements Parcelable {
    public static final String BIN_DATA_KEY = "binData";
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final String UNKNOWN = "Unknown";
    private static final String PREPAID_KEY = "prepaid";
    private static final String HEALTHCARE_KEY = "healthcare";
    private static final String DEBIT_KEY = "debit";
    private static final String DURBIN_REGULATED_KEY = "durbinRegulated";
    private static final String COMMERCIAL_KEY = "commercial";
    private static final String PAYROLL_KEY = "payroll";
    private static final String ISSUING_BANK_KEY = "issuingBank";
    private static final String COUNTRY_OF_ISSUANCE_KEY = "countryOfIssuance";
    private static final String PRODUCT_ID_KEY = "productId";
    private String mPrepaid;
    private String mHealthcare;
    private String mDebit;
    private String mDurbinRegulated;
    private String mCommercial;
    private String mPayroll;
    private String mIssuingBank;
    private String mCountryOfIssuance;
    private String mProductId;
    public static final Parcelable.Creator<BinData> CREATOR = new Parcelable.Creator<BinData>(){

        public BinData createFromParcel(Parcel source) {
            return new BinData(source);
        }

        public BinData[] newArray(int size) {
            return new BinData[size];
        }
    };

    protected static BinData fromJson(JSONObject json) {
        if (json == null) {
            json = new JSONObject();
        }
        BinData binData = new BinData();
        binData.mPrepaid = Json.optString((JSONObject)json, (String)PREPAID_KEY, (String)UNKNOWN);
        binData.mHealthcare = Json.optString((JSONObject)json, (String)HEALTHCARE_KEY, (String)UNKNOWN);
        binData.mDebit = Json.optString((JSONObject)json, (String)DEBIT_KEY, (String)UNKNOWN);
        binData.mDurbinRegulated = Json.optString((JSONObject)json, (String)DURBIN_REGULATED_KEY, (String)UNKNOWN);
        binData.mCommercial = Json.optString((JSONObject)json, (String)COMMERCIAL_KEY, (String)UNKNOWN);
        binData.mPayroll = Json.optString((JSONObject)json, (String)PAYROLL_KEY, (String)UNKNOWN);
        binData.mIssuingBank = BinData.convertNullToUnknown(json, ISSUING_BANK_KEY);
        binData.mCountryOfIssuance = BinData.convertNullToUnknown(json, COUNTRY_OF_ISSUANCE_KEY);
        binData.mProductId = BinData.convertNullToUnknown(json, PRODUCT_ID_KEY);
        return binData;
    }

    private static String convertNullToUnknown(JSONObject json, String key) {
        if (json.has(key) && json.isNull(key)) {
            return UNKNOWN;
        }
        return Json.optString((JSONObject)json, (String)key, (String)"");
    }

    public String getPrepaid() {
        return this.mPrepaid;
    }

    public String getHealthcare() {
        return this.mHealthcare;
    }

    public String getDebit() {
        return this.mDebit;
    }

    public String getDurbinRegulated() {
        return this.mDurbinRegulated;
    }

    public String getCommercial() {
        return this.mCommercial;
    }

    public String getPayroll() {
        return this.mPayroll;
    }

    public String getIssuingBank() {
        return this.mIssuingBank;
    }

    public String getCountryOfIssuance() {
        return this.mCountryOfIssuance;
    }

    public String getProductId() {
        return this.mProductId;
    }

    public BinData() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int i) {
        dest.writeString(this.mPrepaid);
        dest.writeString(this.mHealthcare);
        dest.writeString(this.mDebit);
        dest.writeString(this.mDurbinRegulated);
        dest.writeString(this.mCommercial);
        dest.writeString(this.mPayroll);
        dest.writeString(this.mIssuingBank);
        dest.writeString(this.mCountryOfIssuance);
        dest.writeString(this.mProductId);
    }

    private BinData(Parcel in) {
        this.mPrepaid = in.readString();
        this.mHealthcare = in.readString();
        this.mDebit = in.readString();
        this.mDurbinRegulated = in.readString();
        this.mCommercial = in.readString();
        this.mPayroll = in.readString();
        this.mIssuingBank = in.readString();
        this.mCountryOfIssuance = in.readString();
        this.mProductId = in.readString();
    }
}

