/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.internal;

import android.net.Uri;
import com.braintreepayments.api.exceptions.AuthorizationException;
import com.braintreepayments.api.exceptions.ErrorWithResponse;
import com.braintreepayments.api.exceptions.UnprocessableEntityException;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.internal.BraintreeGatewayCertificate;
import com.braintreepayments.api.internal.HttpClient;
import com.braintreepayments.api.internal.TLSSocketFactory;
import com.braintreepayments.api.models.Authorization;
import com.braintreepayments.api.models.ClientToken;
import com.braintreepayments.api.models.PayPalUAT;
import com.braintreepayments.api.models.TokenizationKey;
import java.io.IOException;
import java.net.HttpURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class BraintreeHttpClient
extends HttpClient {
    private static final String AUTHORIZATION_FINGERPRINT_KEY = "authorizationFingerprint";
    private static final String TOKENIZATION_KEY_HEADER_KEY = "Client-Key";
    private final Authorization mAuthorization;

    public BraintreeHttpClient(Authorization authorization) {
        this.mAuthorization = authorization;
        this.setUserAgent(BraintreeHttpClient.getUserAgent());
        try {
            this.setSSLSocketFactory((SSLSocketFactory)new TLSSocketFactory(BraintreeGatewayCertificate.getCertInputStream()));
        }
        catch (SSLException e) {
            this.setSSLSocketFactory(null);
        }
    }

    public static String getUserAgent() {
        return "braintree/android/3.14.0";
    }

    public void get(String path, HttpResponseCallback callback) {
        if (path == null) {
            this.postCallbackOnMainThread(callback, new IllegalArgumentException("Path cannot be null"));
            return;
        }
        Uri uri = path.startsWith("http") ? Uri.parse((String)path) : Uri.parse((String)(this.mBaseUrl + path));
        if (this.mAuthorization instanceof ClientToken || this.mAuthorization instanceof PayPalUAT) {
            uri = uri.buildUpon().appendQueryParameter(AUTHORIZATION_FINGERPRINT_KEY, this.mAuthorization.getBearer()).build();
        }
        super.get(uri.toString(), callback);
    }

    public void post(String path, String data, HttpResponseCallback callback) {
        try {
            if (this.mAuthorization instanceof ClientToken) {
                data = new JSONObject(data).put(AUTHORIZATION_FINGERPRINT_KEY, (Object)((ClientToken)this.mAuthorization).getAuthorizationFingerprint()).toString();
            }
            super.post(path, data, callback);
        }
        catch (JSONException e) {
            this.postCallbackOnMainThread(callback, (Exception)((Object)e));
        }
    }

    public String post(String path, String data) throws Exception {
        if (this.mAuthorization instanceof ClientToken) {
            data = new JSONObject(data).put(AUTHORIZATION_FINGERPRINT_KEY, (Object)((ClientToken)this.mAuthorization).getAuthorizationFingerprint()).toString();
        }
        return super.post(path, data);
    }

    protected HttpURLConnection init(String url) throws IOException {
        HttpURLConnection connection = super.init(url);
        if (this.mAuthorization instanceof TokenizationKey) {
            connection.setRequestProperty(TOKENIZATION_KEY_HEADER_KEY, this.mAuthorization.getBearer());
        }
        return connection;
    }

    protected String parseResponse(HttpURLConnection connection) throws Exception {
        try {
            return super.parseResponse(connection);
        }
        catch (AuthorizationException | UnprocessableEntityException e) {
            if (e instanceof AuthorizationException) {
                String errorMessage = new ErrorWithResponse(403, e.getMessage()).getMessage();
                throw new AuthorizationException(errorMessage);
            }
            throw new ErrorWithResponse(422, e.getMessage());
        }
    }
}

